#Basic Configuration
DESCRIPTION = "Initial settting"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

SRC_URI = "file://LICENSE"
SRC_URI += "file://init_usb"
SRC_URI += "file://init_network"
SRC_URI += "file://init_common"
SRC_URI += "file://init_mount"
SRC_URI += "file://init_usb.service"
SRC_URI += "file://init_network.service"
SRC_URI += "file://init_common.service"
SRC_URI += "file://init_mount.service"

S = "${WORKDIR}"

FILES_${PN} = "${datadir}/init/init_usb \
               ${datadir}/init/init_network \
               ${datadir}/init/init_common \
               ${datadir}/init/init_mount "

inherit systemd

SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "init_usb.service init_network.service init_common.service init_mount.service"
FILES_${PN} += "${systemd_unitdir}/system/init_usb.service \
                ${systemd_unitdir}/system/init_network.service \
                ${systemd_unitdir}/system/init_common.service \
                ${systemd_unitdir}/system/init_mount.service "


do_install_append() {
    install -d ${D}${datadir}/init
    install -m 0755 init_usb ${D}${datadir}/init/init_usb
    install -m 0755 init_network ${D}${datadir}/init/init_network
    install -m 0755 init_common ${D}${datadir}/init/init_common
    install -m 0755 init_mount ${D}${datadir}/init/init_mount

    if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
        install -d ${D}${systemd_unitdir}/system/
        install -m 0644 init_usb.service ${D}${systemd_unitdir}/system
        install -m 0644 init_network.service ${D}${systemd_unitdir}/system
        install -m 0644 init_common.service ${D}${systemd_unitdir}/system
        install -m 0644 init_mount.service ${D}${systemd_unitdir}/system
    fi

}

