SUMMARY = "GNU Toolchain for ARC Processors"
DESCRIPTION = "GNU Toolchain for ARC Processors"
LICENSE = "GPL-3.0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/GPL-3.0;md5=c79ff39f19dfec6d293b95dea7b07891"

SRC_URI = "https://github.com/foss-for-synopsys-dwc-arc-processors/toolchain/releases/download/arc-2020.03-release/arc_gnu_2020.03_prebuilt_elf32_le_linux_install.tar.gz"
SRC_URI[md5sum] = "eb999a867d1e2cf9885f888d5e06c947"
SRC_URI[sha256sum] = "fecb5a0ae4e9669c6ab79d85986128f8f843fbc3a1355c797513e23eb35e5014"

do_patch[noexec] = "1"
do_compile[noexec] = "1"
inherit nopackages

INSANE_SKIP_${PN} += "already-stripped"
INHIBIT_SYSROOT_STRIP = "1"

SYSROOT_DIRS += "${prefix}/arc-elf32 \
		 ${bindir} \
		 ${nonarch_libdir} \
		 ${libexecdir}"

SYSROOT_DIRS_NATIVE += "${prefix}/arc-elf32 \
			${includedir} \
			${nonarch_libdir} \
			${libdir}"

do_install() {
	cd ${WORKDIR}/arc_gnu_2020.03_prebuilt_elf32_le_linux_install

	# except /share
	for folder in arc-elf32 bin include lib lib64 libexec; do
		find ${folder} -type f -exec install -D {} ${D}${prefix}/{} \;
		find ${folder} -type l -exec cp -P {} ${D}${prefix}/{} \;
	done
}
