SUMMARY = "HSM"
LICENSE = "GPL-2.0-with-linking-exception & MediaTekProprietary"
LIC_FILES_CHKSUM = "file://os/erika2/LICENSE;md5=a91a10d52dcec70595f700ac1799e2b5 \
		    file://src/LICENSE;md5=33021e5683364ac70382851bdf2e4dbd"

DEPENDS = "rt-druid \
	   packer-native \
	   hsm-crypto \
	   hsm-efuse"

inherit workonsrc deploy toolchain-arc
WORKONSRC = "${TOPDIR}/../src/bsp/hsm"
WORKONSRC_RSYNC_APPENDED_FLAG = " --exclude .git"

EXTRA_OEMAKE = "TOP_ROOT=${B} \
		PROJECT=${TARGET_PLATFORM} \
		BOOT_DEVICE=${HSM_BOOTDEV_TYPE} \
		TEE_OS_TYPE=${TEE_SUPPORT} \
		ERIKA_RTDRUID_PATH=${STAGING_DIR_HOST}${prefix}/rt-druid \
		ARC_GNU_PATH=${STAGING_DIR_HOST}${prefix} \
		PYTHON_PATH=${WORKDIR}/recipe-sysroot-native${bindir}/python-native/python2 \
		PACK_TOOL=${WORKDIR}/recipe-sysroot-native${datadir}/packer/mipack.py"

do_configure_append() {
	# copy crypto lib & headers
	cp ${WORKDIR}/recipe-sysroot${libdir}/libcrypto_ex.a ${B}src/driver/platform/${TARGET_PLATFORM}
	cp ${WORKDIR}/recipe-sysroot${includedir}/crypto_*.h ${B}src/driver/platform/${TARGET_PLATFORM}/include

	# copy efuse lib & headers
	cp ${WORKDIR}/recipe-sysroot${libdir}/efuse.a ${B}src/driver/platform/${TARGET_PLATFORM}
	cp ${WORKDIR}/recipe-sysroot${includedir}/efuse*.h ${B}src/driver/platform/${TARGET_PLATFORM}/include
}

do_compile() {
	oe_runmake bl -f ${B}src/build/Makefile
	oe_runmake hsm -f ${B}src/build/Makefile
}
