DESCRIPTION = "Modem database file"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://${MTK_LICENSE_DIR}/MediaTekProprietary;md5=c5d17c6905715d0948a3d6087602d12d"

inherit workonsrc
WORKONSRC = "${MODEM_DIR}"

FILES_${PN} = "${datadir}/modem/* ${sysconfdir}/mddb/* /vendor/*"

do_compile[noexec] = "1"

ALLOW_EMPTY_${PN} = "1"
do_install_append() {
    if [ -s ${S}/MDDB.META.ODB_*.XML.GZ ]; then
        install -d ${D}${datadir}/modem
        install ${S}/MDDB.META.ODB_*.XML.GZ ${D}${datadir}/modem/MDDB.META.ODB.XML.GZ
    fi

    if [ -s ${S}/MDDB_MT2735*.EDB ]; then
        install -d ${D}${sysconfdir}/mddb
        install ${S}/MDDB_MT2735*.EDB ${D}${sysconfdir}/mddb
    fi

    if [ -s ${S}/mddata/cacerts ]; then
        install -d ${D}/vendor
        install -d ${D}/vendor/etc
        install -d ${D}/vendor/etc/md
        install -d ${D}/vendor/etc/md/cacerts
        install -d ${D}/vendor/etc/md/cacerts/ikev2
        install -d ${D}/vendor/etc/md/cacerts/tls
        install ${S}/mddata/cacerts/ikev2/* ${D}/vendor/etc/md/cacerts/ikev2/
        install ${S}/mddata/cacerts/tls/* ${D}/vendor/etc/md/cacerts/tls/

        install -d ${D}/vendor/etc/md/plmn 
          
        cp -r ${S}/mddata/plmn/* ${D}/vendor/etc/md/plmn/

        install -d ${D}/vendor/etc/md/apncfg
        install ${S}/mddata/apncfg/* ${D}/vendor/etc/md/apncfg/
    fi
}

