DESCRIPTION = "Modem images"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://${MTK_LICENSE_DIR}/MediaTekProprietary;md5=c5d17c6905715d0948a3d6087602d12d"

PACKAGE_ARCH = "${MACHINE_ARCH}"
DEPENDS += "u-boot-mkimage-native bc-native dtc-native"

inherit workonsrc deploy nopackages
inherit md-fitimage mddsp-fitimage hsm-sign-env staging-copyfile

WORKONSRC = "${MODEM_DIR}"

do_compile[noexec] = "1"
do_install[noexec] = "1"

MD_IMAGE = "md1img.img"
MDDSP_IMAGE = "md1dsp.img"

MD_OUT = "${WORKDIR}"

do_deploy () {
    install -d ${DEPLOYDIR}
    find . -type d -exec install -d ${DEPLOYDIR}/{} \;
    find . -type f -exec install -m 755 {} ${DEPLOYDIR}/{} \;

    if [ "${SECURE_BOOT_ENABLE}" = "yes" ] ; then
        cp ${DEPLOYDIR}/dsp.bin ${WORKDIR}/dsp-org.bin
        cp ${DEPLOYDIR}/modem.img ${WORKDIR}/modem-org.img

        do_assemble_fitimage
        do_assemble_mdfitimage

    else
        cp ${DEPLOYDIR}/dsp.bin ${MD_OUT}/${MDDSP_IMAGE}
        cp ${DEPLOYDIR}/modem.img ${MD_OUT}/${MD_IMAGE}
    fi
    install ${MD_OUT}/${MD_IMAGE} ${DEPLOYDIR}/${MD_IMAGE}
    install ${MD_OUT}/${MDDSP_IMAGE} ${DEPLOYDIR}/${MDDSP_IMAGE}
}

addtask deploy after do_configure
