inherit hsm-sign-env

AVBTOOL="python ${DEPLOY_DIR_IMAGE}/avbtool"
SCATTER_FILE="${DEPLOY_DIR_IMAGE}/partition_${BOOTDEV_TYPE}.xml"

IMAGE_FSTYPE="img"
IMAGE_DIR_ROOTFS="${DEPLOY_DIR_IMAGE}"


IMAGE_NAME_ROOTFS="system.${IMAGE_FSTYPE}"

IMAGE_NAME_BOOTIMG="boot.img"
IMAGE_DIR_BOOTIMG="${DEPLOY_DIR_IMAGE}"

AVB_BLOCK_SIZE="1024"
AVB_SYSTEM_KEY_NAME="verified_key"
AVB_SYSTEM_KEY="${MTK_KEY_DIR}/${VERIFIED_KEY}.pem"

DEPENDS += "python-pycrypto-native android-tools-avbtool scatter"

exec_avbtool() {

	echo "check config setting: enable=${SECURE_BOOT_ENABLE};SE_type=${SECURE_BOOT_TYPE}"
	vb_hash_algo=`echo ${VB_HASH_ALGO}|tr 'a-z' 'A-Z'`
	vb_rsa_algo=`echo ${VB_RSA_ALGO}|tr 'a-z' 'A-Z'`
	if [ -n "${VB_HASH_ALGO}" ] && [ -n "${VB_RSA_ALGO}" ] ; then
		AVB_ALGO="${vb_hash_algo}_${vb_rsa_algo}"
	else
		AVB_ALGO="SHA256_RSA2048"
	fi
	if [ "${SECURE_BOOT_ENABLE}" = "yes" ] && [ "${SECURE_BOOT_TYPE}" = "avb" ]; then
		echo "start AVB sign ... "
		echo "PARTITION_SIZE_BOOTIMG=${PARTITION_SIZE_BOOTIMG}; PARTITION_SIZE_ROOTFS=${PARTITION_SIZE_ROOTFS}"

		PARTITION_NAME_ROOTFS="system"
		PARTITION_NAME_BOOTIMG="boot"
		if [ "${AVB_ANTIROLLBACK_VERSION}" = "" ]; then
		    AVB_ANTIROLLBACK_VERSION="0"
		fi

		echo "start to erase footer: ${IMAGE_NAME_BOOTIMG}"
		${AVBTOOL} erase_footer --image ${IMAGE_DIR_BOOTIMG}/${IMAGE_NAME_BOOTIMG} || true

		echo "start to erase footer: system.${IMAGE_FSTYPE} "
		${AVBTOOL} erase_footer --image ${IMAGE_DIR_ROOTFS}/system.${IMAGE_FSTYPE} || true

		if test -e ${IMAGE_DIR_BOOTIMG}/${IMAGE_NAME_BOOTIMG}; then
			echo "start to sign image: ${IMAGE_NAME_BOOTIMG}"
			${HSM_ENV} ${AVBTOOL} add_hash_footer --image ${IMAGE_DIR_BOOTIMG}/${IMAGE_NAME_BOOTIMG} \
				--partition_size ${PARTITION_SIZE_BOOTIMG} \
				--partition_name ${PARTITION_NAME_BOOTIMG} \
				--algorithm ${AVB_ALGO} \
				--key ${AVB_SYSTEM_KEY} \
				${HSM_SIGN_PARAM}
		fi

		if test -e ${IMAGE_DIR_ROOTFS}/system.${IMAGE_FSTYPE}; then
			echo "start to sign image: system.${IMAGE_FSTYPE} "
			${HSM_ENV} ${AVBTOOL} add_hashtree_footer --block_size ${AVB_BLOCK_SIZE} \
				--partition_size ${PARTITION_SIZE_ROOTFS} \
				--partition_name ${PARTITION_NAME_ROOTFS} \
				--image ${IMAGE_DIR_ROOTFS}/system.${IMAGE_FSTYPE} \
				--algorithm ${AVB_ALGO} \
				--key ${AVB_SYSTEM_KEY} \
				${HSM_SIGN_PARAM}

			if test -e ${IMAGE_DIR_BOOTIMG}/${IMAGE_NAME_BOOTIMG}; then
				echo "start to make vbmeta image"
				${HSM_ENV} ${AVBTOOL} make_vbmeta_image --rollback_index ${AVB_ANTIROLLBACK_VERSION} \
					--include_descriptors_from_image ${IMAGE_DIR_BOOTIMG}/${IMAGE_NAME_BOOTIMG} \
					--include_descriptors_from_image ${IMAGE_DIR_ROOTFS}/system.${IMAGE_FSTYPE} \
					--setup_rootfs_from_kernel ${IMAGE_DIR_ROOTFS}/system.${IMAGE_FSTYPE} \
					--algorithm ${AVB_ALGO} \
					--key ${AVB_SYSTEM_KEY} \
					--output vbmeta.img \
					${HSM_SIGN_PARAM}

				if [ ${BOOTDEV_TYPE} != "nand" ]; then
					echo "start to append vbmeta image"
					${AVBTOOL} append_vbmeta_image --image ${IMAGE_DIR_BOOTIMG}/${IMAGE_NAME_BOOTIMG} \
						--partition_size ${PARTITION_SIZE_BOOTIMG} \
						--vbmeta_image vbmeta.img
				else
					cp vbmeta.img  ${IMAGE_DIR_BOOTIMG}/
				fi
			fi
		fi
	else
		exit 0
	fi
}

python do_avb_sign_img() {
    import xml.dom.minidom
    import math
    secure_boot_type = d.getVar('SECURE_BOOT_TYPE', True)
    if secure_boot_type != "avb":
        return
    bootdev_type = d.getVar('BOOTDEV_TYPE', True)

    deploy_path = d.getVar('DEPLOY_DIR_IMAGE',True)
    for file in os.listdir(deploy_path):
        if os.path.splitext(file)[1] == '.xml':
            partition_path =  os.path.join(deploy_path,file)
            root = xml.dom.minidom.parse(partition_path)
            for partition in root.childNodes:
                if partition.nodeName == "partition":
                    break
            lbs = partition.getAttribute("lbs")
            lbs = lbs and eval(lbs) or 512
            for node in partition.childNodes:
                if node.nodeName != "entry":
                    continue
                start = eval(node.getAttribute("start"))
                end = eval(node.getAttribute("end"))
                name = node.getAttribute("name")
                size = (end-start+1)*lbs
                #0.92=62/64 *0.95
                if (bootdev_type == 'nand'):
                    size = math.ceil(size*0.92/4096)*4096
                if name == "BOOTIMG" or name == "boot_a" or name == "boot_b":
                    d.setVar('PARTITION_SIZE_BOOTIMG', str(size))
                if name == "ROOTFS" or name == "system_a" or name == "system_b":
                    d.setVar('PARTITION_SIZE_ROOTFS', str(size))
    bb.build.exec_func('exec_avbtool', d)
}

addtask avb_sign_img after do_image_complete before do_build
