DEPENDS += "android-tools-fsutils-native abtools-native"
HOSTTOOLS += "zip unzip"
PATH_prepend = "/mtkoss/openjdk/1.8.0_ubuntu-14.04/bin:${STAGING_DIR_NATIVE}${datadir}/abtools/scripts:"

AFTER_CMD = "${@bb.utils.contains("BOARD_AVB_ENABLE","true", "do_avb_sign_img","do_image_complete",d)}"

do_make_otafull_package() {
	if [ "${AB_OTA_UPDATER}" = "yes" ]; then
		export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:${STAGING_DIR_NATIVE}/usr/lib
		rm -rf ${DEPLOY_DIR_IMAGE}/target-files
		mkdir ${DEPLOY_DIR_IMAGE}/target-files
		mkdir ${DEPLOY_DIR_IMAGE}/target-files/IMAGES
		mkdir ${DEPLOY_DIR_IMAGE}/target-files/SYSTEM
		mkdir ${DEPLOY_DIR_IMAGE}/target-files/META
		cp ${STAGING_DIR_NATIVE}/../rootfs/etc/update_engine/build.prop ${DEPLOY_DIR_IMAGE}/target-files/SYSTEM/
		cp ${STAGING_DIR_NATIVE}/../rootfs/etc/update_engine/update_engine.conf ${DEPLOY_DIR_IMAGE}/target-files/META/update_engine_config.txt

		if test -e ${DEPLOY_DIR_IMAGE}/target-files/META/misc_info.txt; then
			rm ${DEPLOY_DIR_IMAGE}/target-files/META/misc_info.txt
		fi
		echo "recovery_api_version=3" >> ${DEPLOY_DIR_IMAGE}/target-files/META/misc_info.txt
		echo "fstab_version=2" >> ${DEPLOY_DIR_IMAGE}/target-files/META/misc_info.txt
		echo "ab_update=true" >> ${DEPLOY_DIR_IMAGE}/target-files/META/misc_info.txt

		if [ ! -z "${AB_OTA_PARTITIONS}" ]; then
			if test -e ${DEPLOY_DIR_IMAGE}/target-files/META/ab_partitions.txt; then
				rm ${DEPLOY_DIR_IMAGE}/target-files/META/ab_partitions.txt
			fi
			tmp="${AB_OTA_PARTITIONS}"
			for entry in $tmp ; do
				echo $entry >> ${DEPLOY_DIR_IMAGE}/target-files/META/ab_partitions.txt
				if [ ! -f ${DEPLOY_DIR_IMAGE}/$entry.img ]; then
					if [ ! -n "${BUILD_ID}" ]; then
						exit 0
					fi
				fi
				cp  ${DEPLOY_DIR_IMAGE}/$entry.img  ${DEPLOY_DIR_IMAGE}/target-files/IMAGES/
			done
		fi
		if test -e ${DEPLOY_DIR_IMAGE}/system.ext4 ; then
			e2fsdroid ${DEPLOY_DIR_IMAGE}/system.ext4 -e  -B ${DEPLOY_DIR_IMAGE}/target-files/IMAGES/system.map
		fi

		if test "x${BOARD_AVB_ENABLE}" = "xtrue" ; then
			echo "avb_enable=true" >> ${DEPLOY_DIR_IMAGE}/target-files/META/misc_info.txt
			echo "avb_system_hashtree_enable=true" >> ${DEPLOY_DIR_IMAGE}/target-files/META/misc_info.txt
			add_care_map_to_target_files.py ${DEPLOY_DIR_IMAGE}/target-files
		fi

		cd ${DEPLOY_DIR_IMAGE}/target-files && zip -r -q ../target-files.zip IMAGES META SYSTEM && cd -
		ota_from_target_files.py -p ${STAGING_DIR_NATIVE} --signapk_shared_library_path=usr/lib --signapk_path=usr/bin/signapk.jar -k ${STAGING_DATADIR_NATIVE}/abtools/security/testkey ${DEPLOY_DIR_IMAGE}/target-files.zip ${DEPLOY_DIR_IMAGE}/ota_full.zip
	else
		exit 0
	fi
}

create_misc_folder() {
	if [ "${AB_OTA_UPDATER}" = "yes" ]; then
		install -d ${IMAGE_ROOTFS}/misc
	fi
}

ROOTFS_PREPROCESS_COMMAND += " create_misc_folder;"


addtask do_make_otafull_package after ${AFTER_CMD} before do_build
