CHROME_DIR_IMAGE_SIZE ?= "${MKUBIFS_CHROME_IMAGE_SZ}"
CHROME_EXT4_IMAGE_SIZE ?= "${CHROME_IMAGE_SZ}"
CHROME_DIR_IMAGE_PATH = "${DEPLOY_DIR_IMAGE}/chrome"
CHROME_DIR_CONTENT = "${IMAGE_ROOTFS}/../chrome"

IMAGE_FSTYPES_NO_WHITESPACE="$(echo "${IMAGE_FSTYPES}" | tr -d '[:space:]')"
CHROME_FS_PARTITION = "chrome_fs.ubi"
CHROME_PARTITION = "chrome.ubi"
CHROME_PARTITION_EXT4 = "chrome.ext4"

mk_chrome_image() {

	mkdir -p ${CHROME_DIR_CONTENT}/tmp
	mkdir -p ${CHROME_DIR_CONTENT}/etc
	mkdir -p ${CHROME_DIR_CONTENT}/var
	
	install -d ${IMAGE_ROOTFS}/chrome
	for i in ${CHROME_DIR_CONTENT}; do
        CHROME_DIR_FILE_PATH=${CHROME_DIR_IMAGE_PATH}/${i##${CHROME_DIR_CONTENT}}
        install -d ${CHROME_DIR_FILE_PATH}
        if [ "$(ls -A ${i})" ]; then
                cp -a ${i}/* ${CHROME_DIR_FILE_PATH}
        else
                echo "${i} is empty"
        fi
    done
	
    if test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ubi"; then
	echo \[ubifs\] > ubinize.cfg
	echo mode=ubi >> ubinize.cfg
	echo image=${CHROME_FS_PARTITION} >> ubinize.cfg
	echo vol_id=0 >> ubinize.cfg
	echo vol_size=${MKUBIFS_CHROME_VOL_SZ}
	echo vol_type=dynamic >> ubinize.cfg
	echo vol_name=chrome >> ubinize.cfg
	echo vol_flags=autoresize >> ubinize.cfg
	dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${CHROME_FS_PARTITION} seek=${CHROME_DIR_IMAGE_SIZE} count=0 bs=1k
	mkfs.ubifs -r ${CHROME_DIR_FILE_PATH} ${MKUBIFS_CHROME_ARGS} -o ${CHROME_FS_PARTITION}
	#ubinize -o ${CHROME_PARTITION} -m 2048 -p 128KiB -s 2048 ubinize.cfg
	ubinize -o ${CHROME_PARTITION} ${UBINIZE_ARGS} ubinize.cfg
	cp ${CHROME_PARTITION} ${DEPLOY_DIR_IMAGE}/${CHROME_PARTITION}
    elif test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ext4"; then
	dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${CHROME_PARTITION_EXT4} seek=${CHROME_EXT4_IMAGE_SIZE} count=${CHROME_IMAGE_CNT} bs=1k
	mkfs.ext4 -F -i 4096 ${DEPLOY_DIR_IMAGE}/${CHROME_PARTITION_EXT4} -d ${CHROME_DIR_IMAGE_PATH}
    else
	echo "No method to make ${IMAGE_FSTYPES_NO_WHITESPACE} type state image"
    fi
}

ROOTFS_POSTPROCESS_COMMAND += " mk_chrome_image;"


