inherit hsm-sign-env

python __anonymous () {
        depends = d.getVar("DEPENDS", True)
        depends = "%s u-boot-mkimage-native lz4-native dtc-native" % depends
        d.setVar("DEPENDS", depends)
}

#
# Emit the fitImage ITS header
#
fitimage_emit_fit_header() {
        cat << EOF >> ${WORKDIR}/fit-image.its
/dts-v1/;

/ {
        description = "TINYSYS fitImage";
        #address-cells = <1>;
EOF
}

#
# Emit the fitImage section bits
#
# $1 ... Section bit type: imagestart - image section start
#                          confstart  - configuration section start
#                          sectend    - section end
#                          fitend     - fitimage end
#
fitimage_emit_section_maint() {
        case $1 in
        imagestart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        images {
EOF
        ;;
        confstart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        configurations {
EOF
        ;;
        sectend)
                cat << EOF >> ${WORKDIR}/fit-image.its
        };
EOF
        ;;
        fitend)
                cat << EOF >> ${WORKDIR}/fit-image.its
};
EOF
        ;;
        esac
}

fitimage_emit_section_tinysys() {

        if [ -n "${IMAGE_HASH_ALGO}" ] ; then
            tinysys_csum="${IMAGE_HASH_ALGO}"
        else
            tinysys_csum="sha256"
        fi

        cat << EOF >> ${WORKDIR}/fit-image.its
                tinysys_1 {
                        description = "TINYSYS Image";
                        data = /incbin/("${1}");
                        type = "kernel";
                        arch = "arm";
                        os = "FreeRTOS";
                        compression = "${2}";
                        load = <${TINYSYS_LOADADDRESS}>;
                        entry = <${TINYSYS_ENTRYPOINT}>;
                        hash {
                                algo = "${tinysys_csum}";
                        };
                };
EOF
}

#
# Emit the fitImage ITS configuration section
#
fitimage_emit_section_config() {

        if [ -n "${VB_HASH_ALGO}" ] && [ -n "${VB_RSA_ALGO}" ] ; then
            conf_csum="${VB_HASH_ALGO},${VB_RSA_ALGO}"
        else
            conf_csum="sha256,rsa2048"
        fi
        conf_key_name="dev"

        conf_desc="${MTK_PROJECT} configuration"

        cat << EOF >> ${WORKDIR}/fit-image.its
                default = "conf_1";
                conf_1 {
                        description = "${conf_desc}";
                        kernel = "tinysys_1";
                        signature {
                                algo = "${conf_csum}";
                                key-name-hint="${conf_key_name}";
                                sign-images = "kernel";
                        };
                };
EOF
}

do_assemble_fitimage() {

                rm -f ${WORKDIR}/fit-image.its

                fitimage_emit_fit_header

                #
                # Step 1: Prepare a tinysys image section.
                #
                fitimage_emit_section_maint imagestart


                fitimage_emit_section_tinysys ${TINYSYS_OUT}/${TINYSYS_BIN}.bin ${TINYSYS_COMPRESS}

                fitimage_emit_section_maint sectend

                #
                # Step 2: Prepare a configurations section
                #
                fitimage_emit_section_maint confstart

                fitimage_emit_section_config

                fitimage_emit_section_maint sectend

                fitimage_emit_section_maint fitend

                #
                # Step 3: Assemble the image
                #
                ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -f ${WORKDIR}/fit-image.its ${WORKDIR}/${TINYSYS_IMAGE}

                if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
                        mkdir -p ./mykeys
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ./mykeys/dev.crt
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ./mykeys/dev.key
                        ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -k ./mykeys -f ${WORKDIR}/fit-image.its -r ${WORKDIR}/${TINYSYS_IMAGE}
                fi
}

addtask assemble_fitimage before do_package after do_install
