DESCRIPTION = "Mediatek debug tool"
SECTION = "base"
LICENSE = "MediaTekProprietary"

AEE_SRC = "${TOPDIR}/../src/devtools/aee"

WORKONSRC = "${AEE_SRC}"

DEPENDS = "zlib libunwind "
DEPENDS += "${@bb.utils.contains('TARGET_PLATFORM','mt2731','libsncfg platform-libs-header','libprop',d)}"
BB_LDFLAGS_ADD = "${@bb.utils.contains('TARGET_PLATFORM','mt2731','-lsncfg','-lprop -lpthread',d)}"
TARGET_CC_ARCH = "${@bb.utils.contains('TARGET_PLATFORM','mt2731','-pthread','-mfloat-abi=hard',d)}"
BB_CFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -g"
BB_INCLUDE_ADD  = "-I${MTK_SRC}/inc \
                   -I${STAGING_DIR_HOST}  \
                   -I${STAGING_INCDIR} \
                   "

inherit deploy workonsrc

#Parameters passed to do_compile
EXTRA_OEMAKE = "BB_INCLUDE_ADD=${BB_INCLUDE_ADD} \
                BB_LDFLAGS_ADD="${BB_LDFLAGS_ADD}""

FILES_${PN} = "${libdir}/*.so ${bindir}"
FILES_${PN}-dev = "${includedir}"

# Avoid QA Issue: No GNU_HASH in the elf binary
INSANE_SKIP_${PN} = "ldflags"

# Avoid QA Issue: Files/directories were installed but not shipped in any package
INSANE_SKIP_${PN} += "installed-vs-shipped"

#Skip strip check in QA test.
INSANE_SKIP_${PN} += "already-stripped"

do_compile () {
	oe_runmake CFLAGS="${BB_CFLAGS_ADD}" TUNE_FEATURES="${TUNE_FEATURES}"
}

do_install () {
	oe_runmake PREFIX="${prefix}" DESTDIR="${D}" PACKAGE_ARCH="${PACKAGE_ARCH}" TARGET_PLATFORM="${TARGET_PLATFORM}" install
}

inherit systemd
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "aed.service"
FILES_${PN} += "${systemd_unitdir}/system/aed.service"
do_install_append() {
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		if [ -s ${B}/aed.service ] && [ -f ${B}/aed.service ]; then
			install -m 0644 ${B}/aed.service ${D}${systemd_unitdir}/system
		fi
		if [ -s ${B}/lib/systemd/system/aed.service ] && [ -f ${B}/lib/systemd/system/aed.service ]; then
			install -m 0644 ${B}/lib/systemd/system/aed.service ${D}${systemd_unitdir}/system
		fi
	fi
}

create_misc_mount_point() {
	install -d ${IMAGE_ROOTFS}/misc
}
ROOTFS_PREPROCESS_COMMAND += "create_misc_mount_point;"

addtask bachclean
do_bachclean () {
	oe_runmake clean
}
