DESCRIPTION = "A/B update package tools"
LICENSE = "Apache-2.0"
LIC_FILES_CHKSUM = "file://LICENSE;md5=562c740877935f40b262db8af30bca36"
BBCLASSEXTEND = "native nativesdk"

WORKONSRC = "${TOPDIR}/../src/support/ab_tools"
OECMAKE_SOURCEPATH = "${S}"

inherit workonsrc

FILES_${PN}-dev = ""
FILES_${PN} += "${libdir}"
FILES_${PN} += "${bindir}"
FILES_${PN} += "${datadir}"

do_install_append() {
	install -d ${D}${libdir}
	install -d ${D}${bindir}
	install -d ${D}${bindir}/lib/shflags
	install -d ${D}${datadir}/abtools
	install -d ${D}${datadir}/abtools/scripts
	install -d ${D}${datadir}/abtools/scripts/lib/shflags
	install -d ${D}${datadir}/abtools/lib
	install -d ${D}${datadir}/abtools/security

	install -m 0755 ${S}/security/testkey.pk8 ${D}${datadir}/abtools/security
	install -m 0755 ${S}/security/testkey.x509.pem ${D}${datadir}/abtools/security

	install -m 0755 ${S}/bin/delta_generator ${D}${bindir}
	install -m 0755 ${S}/bin/signapk.jar ${D}${bindir}
	install -m 0755 ${S}/bin/e2fsdroid ${D}${bindir}

	install -m 0755 ${S}/scripts/brillo_update_payload ${D}${datadir}/abtools/scripts 
	install -m 0755 ${S}/scripts/ota_from_target_files.py ${D}${datadir}/abtools/scripts
	install -m 0755 ${S}/scripts/add_care_map_to_target_files.py ${D}${datadir}/abtools/scripts
	install -m 0755 ${S}/scripts/common.py ${D}${datadir}/abtools/scripts
	install -m 0755 ${S}/scripts/blockimgdiff.py ${D}${datadir}/abtools/scripts
	install -m 0755 ${S}/scripts/rangelib.py ${D}${datadir}/abtools/scripts
	install -m 0755 ${S}/scripts/edify_generator.py ${D}${datadir}/abtools/scripts
	install -m 0755 ${S}/scripts/sparse_img.py ${D}${datadir}/abtools/scripts
	install -m 0755 ${S}/scripts/lib/shflags/shflags ${D}${datadir}/abtools/scripts/lib/shflags

	install -m 0644 ${S}/lib/libc++.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libbase.so ${D}${libdir} 
	install -m 0644 ${S}/lib/libbrillo.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libbrillo-stream.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libchrome.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libcrypto_utils.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libcrypto-host.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libevent-host.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libext2fs-host.so  ${D}${libdir}
	install -m 0644 ${S}/lib/liblog.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libprotobuf-cpp-lite.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libsparse-host.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libssl-host.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libz-host.so  ${D}${libdir}
	install -m 0644 ${S}/lib/libconscrypt_openjdk_jni.so  ${D}${libdir}
}

PATH_prepend = "${STAGING_DIR_NATIVE}${datadir}/abtools/scripts:"
EXTRANATIVEPATH += ""


