inherit autotools
DESCRIPTION = "Android platform libraries"
LICENSE = "Apache-2.0"
LIC_FILES_CHKSUM = " \
	file://system/core/NOTICE;md5=c1a3ff0b97f199c7ebcfdd4d3fed238e \
	"

SRC_URI = " \
	git://android.googlesource.com/platform/system/core;name=platform/system/core;destsuffix=platform/system/core/ \
	file://base.patch \
	file://parseint.patch \
	file://include.patch \
	file://liblog.patch \
	file://string.patch \
"

SRCREV_platform/system/core = "c6160d2a0ef648ccb3d217c589c60b5c00b80387"

FILESEXTRAPATHS_prepend := "${THISDIR}:"

DEPENDS += "openssl glog "

S = "${WORKDIR}/platform"

LDFLAGS += "-lcrypto -lpthread -lglog"

SECURITY_CFLAGS=""

do_configure_prepend() {
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-common/files/makefiles/platform/Makefile.am ${WORKDIR}/platform/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-common/files/makefiles/platform/configure.ac ${WORKDIR}/platform/configure.ac
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-common/files/makefiles/platform/system/core/base/Makefile.am ${WORKDIR}/platform/system/core/base/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-common/files/makefiles/platform/system/core/base/include/Makefile.am ${WORKDIR}/platform/system/core/base/include/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-common/files/makefiles/platform/system/core/include/Makefile.am ${WORKDIR}/platform/system/core/include/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-common/files/makefiles/platform/system/core/liblog/Makefile.am ${WORKDIR}/platform/system/core/liblog/Makefile.am
}

do_install_append() {
	install -d ${D}${includedir}
	install -d ${D}${includedir}/log
	install -d ${D}${includedir}/android
	install -m 644 ${S}/system/core/include/log/* ${D}/${includedir}/log
	install -m 644 ${S}/system/core/include/android/* ${D}/${includedir}/android
}
