inherit autotools
DESCRIPTION = "Android platform libraries"
LICENSE = "Apache-2.0"
LIC_FILES_CHKSUM = " \
	file://system/core/NOTICE;md5=c1a3ff0b97f199c7ebcfdd4d3fed238e \
	"

SRC_URI = " \
	git://android.googlesource.com/platform/external/brotli;name=platform/external/brotli;destsuffix=platform/external/brotli/ \
	git://android.googlesource.com/platform/external/bsdiff;name=platform/external/bsdiff;destsuffix=platform/external/bsdiff/ \
	git://android.googlesource.com/platform/external/puffin;name=platform/external/puffin;destsuffix=platform/external/puffin/ \
	git://android.googlesource.com/platform/external/libevent;name=platform/external/libevent;destsuffix=platform/external/libevent/ \
	git://android.googlesource.com/platform/external/libdivsufsort;name=platform/external/libdivsufsort;destsuffix=platform/external/libdivsufsort/ \
	git://android.googlesource.com/platform/external/libbrillo;name=platform/external/libbrillo;destsuffix=platform/external/libbrillo/ \
	git://android.googlesource.com/platform/external/libchrome;name=platform/external/libchrome;destsuffix=platform/external/libchrome/ \
	git://android.googlesource.com/platform/external/modp_b64;name=platform/external/modp_b64;destsuffix=platform/external/modp_b64/ \
	git://android.googlesource.com/platform/external/xz-embedded;name=platform/external/xz-embedded;destsuffix=platform/external/xz-embedded/ \
	git://android.googlesource.com/platform/external/cros/system_api;name=platform/external/cros/system_api;destsuffix=platform/external/cros/system_api/ \
	git://android.googlesource.com/platform/system/core;name=platform/system/core;destsuffix=platform/system/core/ \
	file://base.patch \
	file://libchrome.patch \
	file://fstab.patch \
	file://puffin.patch \
	file://libevent.patch \
	file://libbrillo.patch \
	file://file_stream.patch \
"

SRCREV_platform/external/brotli = "5ccabc48199cb108fd914222cd6bdbe12c7e15e6"
SRCREV_platform/external/bsdiff = "f0c8211af44d092cf6cc816b1e9af72f14fe80f6"
SRCREV_platform/external/puffin = "7c492ae6e97dadf21d9282e26711d318ccddfc9b"
SRCREV_platform/external/libevent = "becbc79be28cd4f92d14c3f395d562995fc73bf9"
SRCREV_platform/external/libdivsufsort = "fcee868119b5eac60a8cd9fc9ddebb9627ffd172"
SRCREV_platform/external/libbrillo = "11469312f6dce4ee8a4b98d33a36a0814b7f77c2"
SRCREV_platform/external/libchrome = "b6fcee758cbc64842e10cb155780818aaad02420"
SRCREV_platform/external/modp_b64 = "6f11b5c9b4ffb38dc9375f3cf344da4300a2741a"
SRCREV_platform/external/xz-embedded = "180f9115008b00e7c1a2b35317f2bca709fce8a1"
SRCREV_platform/external/cros/system_api = "b48922224f13c7323a389cc8b2585d43dc1ba724"
SRCREV_platform/system/core = "f0c6e2494ebb7fdbb95494fc4e461542e02bdfeb"

FILESEXTRAPATHS_prepend := "${THISDIR}:"

DEPENDS += "openssl-native openssl gtest bzip2 glog protobuf platform-libs-common ${@bb.utils.contains("BOOTDEV_TYPE", "nand", "nandapi", "", d)}"

S = "${WORKDIR}/platform"

LDFLAGS += "-lcrypto -lpthread -lglog -lbase"

SECURITY_CFLAGS=""

do_configure_prepend() {
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/Makefile.am ${WORKDIR}/platform/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/configure.ac ${WORKDIR}/platform/configure.ac
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/system/core/fs_mgr/Makefile.am ${WORKDIR}/platform/system/core/fs_mgr/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/system/core/fs_mgr/include_fstab/Makefile.am ${WORKDIR}/platform/system/core/fs_mgr/include_fstab/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/modp_b64/Makefile.am ${WORKDIR}/platform/external/modp_b64/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/libbrillo/Makefile.am ${WORKDIR}/platform/external/libbrillo/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/libchrome/Makefile.am ${WORKDIR}/platform/external/libchrome/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/libevent/Makefile.am ${WORKDIR}/platform/external/libevent/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/cros/system_api/dbus/Makefile.am ${WORKDIR}/platform/external/cros/system_api/dbus/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/xz-embedded/Makefile.am ${WORKDIR}/platform/external/xz-embedded/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/xz-embedded/linux/include/linux/Makefile.am ${WORKDIR}/platform/external/xz-embedded/linux/include/linux/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/bsdiff/Makefile.am ${WORKDIR}/platform/external/bsdiff/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/bsdiff/include/Makefile.am ${WORKDIR}/platform/external/bsdiff/include/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/brotli/Makefile.am ${WORKDIR}/platform/external/brotli/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/puffin/src/include/Makefile.am ${WORKDIR}/platform/external/puffin/src/include/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/puffin/Makefile.am ${WORKDIR}/platform/external/puffin/Makefile.am
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek/recipes-support/platform-libs-for-updateengine/files/makefiles/platform/external/libdivsufsort/Makefile.am ${WORKDIR}/platform/external/libdivsufsort/Makefile.am
}

