inherit ptest

SRC_URI += "file://run-ptest \
           "
do_install_ptest () {
	mkdir -p ${D}${PTEST_PATH}
	sed -e "s:\/usr\/local:${bindir}:g" -i cpan/version/t/*
	sed -e "s:\/opt:\/usr:" -i Porting/add-package.pl
	sed -e "s:\/local\/gnu\/:\/:" -i hints/cxux.sh
	tar -c --exclude='*.o' --exclude=libperl.so --exclude=Makefile --exclude=makefile --exclude=hostperl \
	    --exclude=cygwin --exclude=os2 --exclude=djgpp --exclude=qnx --exclude=symbian --exclude=haiku \
	    --exclude=vms --exclude=vos --exclude=NetWare --exclude=amigaos4  --exclude=buildcustomize.pl \
	    --exclude='win32/config.*' --exclude=plan9 --exclude=README.plan9 --exclude=perlplan9.pod --exclude=Configure \
	    --exclude=veryclean.sh --exclude=realclean.sh  --exclude=getioctlsizes \
	    --exclude=dl_aix.xs --exclude=sdbm.3 --exclude='cflags.SH' --exclude=makefile.old \
		--exclude=miniperl --exclude=generate_uudmap --exclude=patches * | ( cd ${D}${PTEST_PATH} && tar -x )

	ln -sf ${bindir}/perl ${D}${PTEST_PATH}/t/perl

	# Remove build host references from various scattered files...
	find "${D}${PTEST_PATH}" \
	     \( -name '*.PL' -o -name 'myconfig' -o -name 'cflags' -o -name '*.pl' -o -name '*.sh' -o -name '*.pm' \
	     -o -name 'h2xs' -o -name 'h2ph' \
	     -o -name '*.h' -o -name 'config.sh-*' -o -name 'pod2man'  -o -name 'pod2text' \) \
	    -type f -exec sed -i \
	       -e "s,${D},,g" \
	       -e "s,--sysroot=${STAGING_DIR_HOST},,g" \
	       -e "s,-isystem${STAGING_INCDIR} ,,g" \
	       -e 's|${DEBUG_PREFIX_MAP}||g' \
	       -e "s,${STAGING_BINDIR_NATIVE}/perl-native/,${bindir}/,g" \
	       -e "s,${STAGING_LIBDIR},${libdir},g" \
	       -e "s,${STAGING_BINDIR},${bindir},g" \
	       -e "s,${STAGING_INCDIR},${includedir},g" \
	       -e "s,${STAGING_BINDIR_NATIVE}/,,g" \
	       -e "s,${STAGING_BINDIR_TOOLCHAIN}/${TARGET_PREFIX},${bindir},g" \
	       -e 's:${RECIPE_SYSROOT_NATIVE}::g' \
	       -e 's:${RECIPE_SYSROOT}::g' \
	        {} +

	 # Remove a useless timestamp...
	 sed -i -e '/Autogenerated starting on/d' ${D}${PTEST_PATH}/lib/unicore/mktables.lst
}

python populate_packages_prepend() {
    # Put all *.t files from the lib dir in the ptest package
    # do_split_packages requires a pair of () in the regex, but we have nothing
    # to match, so use an empty pair.
    if bb.utils.contains('DISTRO_FEATURES', 'ptest', True, False, d):
        do_split_packages(d, d.expand('${libdir}/perl/${PV}'), '.*\.t()',
            '${PN}-ptest%s', '%s', recursive=True, match_path=True)
}

RDEPENDS_${PN}-ptest += "${PN}-modules ${PN}-doc ${PN}-misc sed"

# The perl-ptest package contains Perl internal modules and generating file
# dependencies for it causes problems.
SKIP_FILEDEPS_${PN}-ptest = '1'
