inherit hsm-sign-env

python __anonymous () {
        depends = d.getVar("DEPENDS", True)
        depends = "%s u-boot-mkimage-native lz4-native dtc-native" % depends
        d.setVar("DEPENDS", depends)
}

# $1 ... Set compress bin name
tinysys_prep_image() {

        tinysys_comp=${TINYSYS_COMPRESS}

        if test "${tinysys_comp}" = "lz4"; then
                tinysys_suffix=".lz4"
        elif test "${tinysys_comp}" = "gzip"; then
                tinysys_suffix=".gz"
        else
                tinysys_suffix=""
        fi

        if test "${tinysys_comp}" = "lz4"; then
                lz4 -l -c1 ${1} > ${1}${tinysys_suffix}
                # append uncompressed filesize info
                dec_size=0
                fsize=$(stat -c "%s" "${1}")
                dec_size=$(expr $dec_size + $fsize)
                printf "%08x\n" $dec_size |
                        sed 's/\(..\)/\1 /g' | {
                                read ch0 ch1 ch2 ch3;
                                for ch in $ch3 $ch2 $ch1 $ch0; do
                                        printf `printf '%s%03o' '\\' 0x$ch` >> ${1}${tinysys_suffix};
                                done;
                        }
        elif test "${tinysys_comp}" = "gzip"; then
                gzip -9 ${1}
        else
                echo "For none case or another compressing"
        fi

        if ! test "${tinysys_comp}" = "none"; then
                mv -f "${1}${tinysys_suffix}" ${1}
        else
                echo "No tinysys compression"
        fi

        echo "${tinysys_comp}"
}


#
# Emit the fitImage ITS header
#
fitimage_emit_fit_header() {
        cat << EOF >> ${WORKDIR}/fit-image.its
/dts-v1/;

/ {
        description = "scpsys fitImage for fusa";
        #address-cells = <2>;
EOF
}

#
fitimage_emit_scpdata_fit_header() {
        cat << EOF >> ${WORKDIR}/fit-image.its
/dts-v1/;

/ {
        description = "scpdata fitImage for fusa";
        #address-cells = <2>;
EOF
}

#
# Emit the fitImage section bits
#
# $1 ... Section bit type: imagestart - image section start
#                          confstart  - configuration section start
#                          sectend    - section end
#                          fitend     - fitimage end
#
fitimage_emit_section_maint() {
        case $1 in
        imagestart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        images {
EOF
        ;;
        confstart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        configurations {
EOF
        ;;
        sectend)
                cat << EOF >> ${WORKDIR}/fit-image.its
        };
EOF
        ;;
        fitend)
                cat << EOF >> ${WORKDIR}/fit-image.its
};
EOF
        ;;
        esac
}

fitimage_emit_section_scpsys() {

        if [ -n "${IMAGE_HASH_ALGO}" ] ; then
            tinysys_csum="${IMAGE_HASH_ALGO}"
        else
            tinysys_csum="sha256"
        fi

        cat << EOF >> ${WORKDIR}/fit-image.its
                ${3}_1 {
                        description = "scp firmware";
                        data = /incbin/("${1}");
                        type = "${7}";
                        compression = "${2}";
                        load = <0x00 0x130000>;
                        hash {
                                algo = "sha256";
                        };
                };
EOF
}

fitimage_emit_section_scpdata() {

        if [ -n "${IMAGE_HASH_ALGO}" ] ; then
            tinysys_csum="${IMAGE_HASH_ALGO}"
        else
            tinysys_csum="sha256"
        fi

        cat << EOF >> ${WORKDIR}/fit-image.its
                ${3}_1 {
                        description = "${3}";
                        data = /incbin/("${1}");
                        type = "loadable";
                        compression = "${2}";
                        load = <${4}>;
                        hash {
                                algo = "sha256";
                        };
                };
EOF
}

#
# Emit the fitImage ITS configuration section
#
fitimage_emit_section_config() {

        if [ -n "${VB_HASH_ALGO}" ] && [ -n "${VB_RSA_ALGO}" ] ; then
            conf_csum="${VB_HASH_ALGO},${VB_RSA_ALGO}"
        else
            conf_csum="sha256,rsa2048"
        fi
        conf_key_name="dev"

        conf_desc="${MTK_PROJECT} configuration"

        if [ ! -n "${FUSA_EATURE_ENABLE}" ]; then
           dram_node="firmware = \"scp_dram@1\";"
           dram_img_type=",\"firmware\";"
        else
           dram_img_type=";"
        fi

        cat << EOF >> ${WORKDIR}/fit-image.its
                default = "conf_1";
                conf_1 {
                        description = "${conf_desc}";
                        kernel = "scpsys_1";
                        signature {
                                algo = "${conf_csum}";
                                key-name-hint="${conf_key_name}";
                                sign-images = "kernel"${dram_img_type}
                        };
                };
EOF
}

do_assemble_fitimage() {

        rm -f ${WORKDIR}/fit-image.its

        fitimage_emit_fit_header

        #
        # Step 1: Prepare a tinysys image section.
        #
        fitimage_emit_section_maint imagestart

        # compress scp dram image using lz4
        ${S}build/lz4_compress.sh ${S}tinysys-scp_out/freertos/source/${TINYSYS_DRAM_BIN} ${TINYSYS_COMPRESS}

        fitimage_emit_section_scpsys ${S}tinysys-scp_out/freertos/source/${TINYSYS_BIN} \
        none scpsys ${SCP_SRAM_DESCRIPTION} 0 ${SCP_SRAM_LOAD_ADDR} ${SCP_SRAM_TYPE}

        # to decide if dram image need to be load or not
        if [ ! -n "${FUSA_EATURE_ENABLE}" ]; then
           if [ -n "${4GB_DRAM_PROJECT}" ]; then
              fitimage_emit_section_scpsys ${S}tinysys-scp_out/freertos/source/${TINYSYS_DRAM_BIN}.${TINYSYS_COMPRESS} \
              lz4 scp_dram ${SCP_DRAM_DESCRIPTION} ${SCP_4GB_DRAM_LOAD_ADDR_UPPER_BITS} ${SCP_4GB_DRAM_LOAD_ADDR_LOWER_BITS} ${SCP_DRAM_TYPE}
           else
              fitimage_emit_section_scpsys ${S}tinysys-scp_out/freertos/source/${TINYSYS_DRAM_BIN}.${TINYSYS_COMPRESS} \
              lz4 scp_dram ${SCP_DRAM_DESCRIPTION} ${SCP_NON_4GB_DRAM_LOAD_ADDR_UPPER_BITS} ${SCP_NON_4GB_DRAM_LOAD_ADDR_LOWER_BITS} ${SCP_DRAM_TYPE}
           fi
        fi


        fitimage_emit_section_maint sectend

        #
        # Step 2: Prepare a configurations section
        #
        fitimage_emit_section_maint confstart

        fitimage_emit_section_config

        fitimage_emit_section_maint sectend

        fitimage_emit_section_maint fitend

        #
        # Step 3: Assemble the image
        #
        mkdir -p ./mykeys
        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ./mykeys/dev.crt
        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ./mykeys/dev.key
        uboot-mkimage -k ./mykeys -f ${WORKDIR}/fit-image.its -r ${WORKDIR}/${TINYSYS_IMAGE}
	cp ${WORKDIR}/fit-image.its ${WORKDIR}/scpsys-fit-image.its

        # scp_data image
        if [ ! -n "${FUSA_EATURE_ENABLE}" ]; then
           rm -f ${WORKDIR}/fit-image.its

           fitimage_emit_scpdata_fit_header

           #
           # Step 1: Prepare a tinysys image section.
           #
           fitimage_emit_section_maint imagestart

           cp -f ${SCP_LOGO_IMAGE} ${S}tinysys-scp_out/scp-logo
           cp -f ${SCP_WARNING_IMAGE} ${S}tinysys-scp_out/scp-warning
           cp -f ${SCP_CVBS_IMAGE} ${S}tinysys-scp_out/scp-cvbs
           cp -f ${SCP_GUIDELING} ${S}tinysys-scp_out/scp-guideline
           tinysys_prep_image ${S}tinysys-scp_out/scp-logo
           tinysys_prep_image ${S}tinysys-scp_out/scp-warning
           tinysys_prep_image ${S}tinysys-scp_out/scp-cvbs
           tinysys_prep_image ${S}tinysys-scp_out/scp-guideline
           fitimage_emit_section_scpdata ${S}tinysys-scp_out/scp-logo ${TINYSYS_COMPRESS} logo 0 ${SCP_LOGO_LOAD_ADDRESS}
           fitimage_emit_section_scpdata ${S}tinysys-scp_out/scp-warning ${TINYSYS_COMPRESS} warnmsg 0 ${SCP_WARNMSG_LOAD_ADDRESS}
           fitimage_emit_section_scpdata ${S}tinysys-scp_out/scp-cvbs ${TINYSYS_COMPRESS} cvbsimg 0 ${SCP_CVBSIMG_LOAD_ADDRESS}
           fitimage_emit_section_scpdata ${S}tinysys-scp_out/scp-guideline ${TINYSYS_COMPRESS} guideline 0 ${SCP_GUILDLINE_LOAD_ADDRESS}

           fitimage_emit_section_maint sectend

           fitimage_emit_section_maint fitend

           #
           # Step 3: Assemble the image
           #
           uboot-mkimage -f ${WORKDIR}/fit-image.its -r ${WORKDIR}/${TINYDATA_IMAGE}
           cp ${WORKDIR}/fit-image.its ${WORKDIR}/scpdata-fit-image.its
        fi
}

addtask assemble_fitimage before do_package after do_install
