inherit hsm-sign-env

python __anonymous () {
        depends = d.getVar("DEPENDS", True)
        depends = "%s u-boot-mkimage-native dtc-native" % depends
        d.setVar("DEPENDS", depends)
}

#
# Emit the fitImage ITS header
#
fitimage_emit_fit_header() {
        cat << EOF >> ${WORKDIR}/fit-image.its
/dts-v1/;

/ {
        description = "SSPM fitImage";
        #address-cells = <1>;
EOF
}

#
# Emit the fitImage section bits
#
# $1 ... Section bit type: imagestart - image section start
#                          confstart  - configuration section start
#                          sectend    - section end
#                          fitend     - fitimage end
#
fitimage_emit_section_maint() {
        case $1 in
        imagestart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        images {
EOF
        ;;
        confstart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        configurations {
EOF
        ;;
        sectend)
                cat << EOF >> ${WORKDIR}/fit-image.its
        };
EOF
        ;;
        fitend)
                cat << EOF >> ${WORKDIR}/fit-image.its
};
EOF
        ;;
        esac
}

#
# Emit the fitImage ITS sspm section
#
# $1 ... Path to sspm image
# $2 ... Compression type
fitimage_emit_section_sspm() {

        if [ -n "${IMAGE_HASH_ALGO}" ] ; then
            sspm_csum="${IMAGE_HASH_ALGO}"
        else
            sspm_csum="sha256"
        fi

        cat << EOF >> ${WORKDIR}/fit-image.its
                sspm_1 {
                        description = "SSPM firmware";
                        data = /incbin/("${1}");
                        type = "kernel";
                        arch = "arm";
                        os = "linux";
                        compression = "${2}";
                        load = <${SSPM_LOADADDRESS}>;
                        entry = <${SSPM_ENTRYPOINT}>;
                        hash@1 {
                                algo = "${sspm_csum}";
                        };
                };
EOF
}

#
# Emit the fitImage ITS configuration section
#
# $1 ... sspm image ID
fitimage_emit_section_config() {

        if [ -n "${VB_HASH_ALGO}" -a -n "${VB_RSA_ALGO}" ] ; then
            conf_csum="${VB_HASH_ALGO},${VB_RSA_ALGO}"
        else
            conf_csum="sha256,rsa2048"
        fi
        conf_key_name="dev"
        conf_desc="sspm configuration"

        sspm_line="kernel = \"sspm_1\";"
        sign_images_line="sign-images = \"kernel\";"

        cat << EOF >> ${WORKDIR}/fit-image.its
                default = "conf_1";
                conf_1 {
                        description = "${conf_desc}";
                        ${sspm_line}
                        signature {
                                algo = "${conf_csum}";
                                key-name-hint="${conf_key_name}";
                                ${sign_images_line}
                        };
                };
EOF
}

do_assemble_fitimage() {

                rm -f ${WORKDIR}/fit-image.its

                fitimage_emit_fit_header

                #
                # Step 1: Prepare a sspm image section.
                #
                fitimage_emit_section_maint imagestart

                fitimage_emit_section_sspm ${SSPM_OUT}/${SSPM_BINARY} ${SSPM_COMPRESS}

                fitimage_emit_section_maint sectend

                #
                # Step 2: Prepare a configurations section
                #
                fitimage_emit_section_maint confstart

                fitimage_emit_section_config

                fitimage_emit_section_maint sectend

                fitimage_emit_section_maint fitend

                #
                # Step 3: Assemble the image
                #
                ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -f ${WORKDIR}/fit-image.its ${WORKDIR}/${SSPM_IMAGE}

                if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
			if [ "${STANDALONE_SIGN_PREPARE}" = "yes" ];then
				exit 0
			fi
                        mkdir -p ./mykeys
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ./mykeys/dev.crt
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ./mykeys/dev.key
                        ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -k ./mykeys -f ${WORKDIR}/fit-image.its -r ${WORKDIR}/${SSPM_IMAGE}
                fi
}

addtask assemble_fitimage before do_deploy after do_install

