/* SPDX-License-Identifier: MediaTekProprietary */

#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <errno.h>
#include <cutils/properties.h>

#define	PROP_CORE_PROP_LOCAL		"/data/local.prop"

int main(int argc, char* const argv[]) {
    char value[PROPERTY_VALUE_MAX];

    if (argc < 2)
	{
	    FILE *fp;
	    if ((fp = fopen(PROP_CORE_PROP_LOCAL, "r")) == NULL) {
		    printf("Open prop file fail\n");
		    return -1;
	    }

	    while (!feof(fp)) {
		    fgets(value, PROPERTY_VALUE_MAX, fp);
		    printf("%s", value);
	    }

	    fclose(fp);
	    printf("\n");
	    return 0;
	} else {
        property_get(argv[1], value, "");
        printf("%s\n", value);
    }

    return 0;
}
