/* SPDX-License-Identifier: MediaTekProprietary */

#ifndef __REQUEST_H__
#define __REQUEST_H__


/*******************************************************************************/
/* REQUEST definitions                                                         */
/*******************************************************************************/
#define SNCFG_REQUEST_MAGIC			0x2287
#define SNCFG_REQUEST_FOLDER        "/tmp/prop"
#define SNCFG_REQUEST_UNIX_SOCKET	"/tmp/prop/sncfg.socket"

#ifdef __MEM_COSTDOWN__
#define SNCFG_REQUEST_MAX_SIZE		512
#else
#define SNCFG_REQUEST_MAX_SIZE		4096
#endif


/*******************************************************************************/
/* REQUEST prototypes                                                          */
/*******************************************************************************/
enum {
	SNCFG_REQUEST_TYPE_PROP_SET,
	SNCFG_REQUEST_TYPE_PROP_GET,
	SNCFG_REQUEST_TYPE_PROP_RELOAD,
	SNCFG_REQUEST_TYPE_PROP_DEBUG,
	SNCFG_REQUEST_TYPE_PROP_CTRLSTOP_SIGNAL,
	SNCFG_REQUEST_TYPE_PROP_TEST,

	SNCFG_REQUEST_TYPE_RESERVED
};
	

struct sncfg_request {
	unsigned short magic;
	unsigned short type;
	int status;
	int reservedLen;
	char *key;
	char *value;
	char string[SNCFG_REQUEST_MAX_SIZE];	/* enough ?? */
};

struct request_list {
	struct request_list *prev, *next;
};

struct req {
	struct request_list	next;
	int	sock;
    int child_pid; 
	struct sncfg_request request;
};


/*******************************************************************************/
/* REQUEST variables                                                           */
/*******************************************************************************/


/*******************************************************************************/
/* REQUEST functions                                                           */
/*******************************************************************************/
extern int pack_request(struct sncfg_request *request);
extern int unpack_request(struct sncfg_request *request, int size);
extern int connect_request(void);
extern int accept_request(int sockfd);
extern int request_for_sncfg(struct sncfg_request *request);

#endif	// __REQUEST_H__
