/* SPDX-License-Identifier: MediaTekProprietary */

#ifndef _SNCFG_PROPERTY_DB_H
#define _SNCFG_PROPERTY_DB_H

#include "list.h"
#include <cutils/properties.h>


#define PROP_DB_VALUE_SIZE   PROPERTY_VALUE_MAX
#define PROP_DB_KEY_SIZE     PROPERTY_KEY_MAX

typedef struct 
{
	struct  list    sibling;		/* sibling list, for hash */
    char            *prop_key;
    char            *prop_value;
    int             flags;    
    
}prop_db_info_t;

int prop_db_set(const char *in_key, const char *in_value);
int prop_db_get(const char *in_key, char *in_value);
void prop_db_dump(void);
void prop_db_init(void);

#endif
