/* SPDX-License-Identifier: MediaTekProprietary */

#ifndef __SNCFGD_H__
#define __SNCFGD_H__

#include "list.h"


/*******************************************************************************/
/* SNCFGD definitions                                                         */
/*******************************************************************************/
#ifdef DEBUG
#define ASSERT_CHECK(x)	assert(x)

#define DEBUG_PRINT(str, args...) \
	do { \
		printf("[SNCFGD] %s - ", __FUNCTION__); \
		printf(str, ##args); \
		printf("\n"); \
	} while(0)

#define LOG_PRINT(level, str, args...) \
	do { \
		printf("[SNCFGD] %s - ", __FUNCTION__); \
		printf(str, ##args); \
		printf("\n"); \
	} while(0)
#else
#define ASSERT_CHECK(x)

#define DEBUG_PRINT(str, args...)

#define LOG_PRINT(level, str, args...) \
	do { \
		syslog(level, str, ##args); \
	} while(0)
#endif

/*******************************************************************************/
/* SNCFGD functions                                                           */
/*******************************************************************************/
/*Only for debug/test*/
int property_reload(void);
int property_debug(char *key, char *value);
int property_test(char *key, char *value);

#endif	// __SNCFGD_H__
