/* SPDX-License-Identifier: MediaTekProprietary */

#include <stdio.h>
#include <stdlib.h>
#ifdef DEBUG
#include <assert.h>
#endif
#include "list.h"

/*******************************************************************************/
/* LIST local definitions                                                      */
/*******************************************************************************/

/*******************************************************************************/
/* LIST local prototypes                                                       */
/*******************************************************************************/
static inline void __list_add(struct list *entry, struct list *prev, struct list *next)
{
	next->prev = entry;
	entry->next = next;
	entry->prev = prev;
	prev->next = entry;
}

static inline void __list_del(struct list *prev, struct list *next)
{
	next->prev = prev;
	prev->next = next;
}

/*******************************************************************************/
/* LIST local variables                                                        */
/*******************************************************************************/

/*******************************************************************************/
/* LIST local functions                                                        */
/*******************************************************************************/

/*******************************************************************************/
/* LIST functions                                                              */
/*******************************************************************************/
void list_add(struct list *entry, struct list *head)
{
	__list_add(entry, head, head->next);
}

void list_add_tail(struct list *entry, struct list *head)
{
	__list_add(entry, head->prev, head);
}

void list_del(struct list *entry)
{
	__list_del(entry->prev, entry->next);
}

void list_del_init(struct list *entry)
{
	__list_del(entry->prev, entry->next);
	INIT_LIST(entry);
}

void list_replace(struct list *orig, struct list *repl)
{
	if (!list_empty(orig)) {
		repl->next = orig->next;
		repl->prev = orig->prev;
		repl->next->prev = repl;
		repl->prev->next = repl;
		INIT_LIST(orig);
	} else {
		INIT_LIST(repl);
	}
}

int list_empty(const struct list *head)
{
	return (head->next == head);
}
