/* SPDX-License-Identifier: MediaTekProprietary */

#ifndef _PROP_SVC_H
#define _PROP_SVC_H

#include "list.h"
#include <cutils/properties.h>

#define PROP_SVC_RUNNING     		(0x1<<2)  /* currently active */
#define PROP_SVC_STOPPING     		(0x1<<3)  /* currently active */
#define PROP_SVC_STOPPED     		(0x1<<4)  /* currently active */

#define PROP_SVC_ACTION_MAX_SIZE    (128)   /*???*/
#define	PROP_SVC_ACTION_BUF_SIZE 	(1024)	/*???*/
#define	PROP_SVC_TYPE_MAX_SIZE		(256)
#define PROP_SVC_MAX_ARGS_NUM		(12)
#define	PROP_SVC_ONPROPERTY	"on property:"
#define	PROP_SVC_SERVICE		"service "

#define PROP_SVC_TYPE_ON_PROPERTY   (0x1<<1)
#define PROP_SVC_TYPE_SERVICE       (0x1<<2)

typedef struct
{
    struct list    	alist;
	char			line_buf[PROP_SVC_ACTION_MAX_SIZE];
	char			act_name[PROP_SVC_ACTION_MAX_SIZE];
	int				args_num;
	char			*args[PROP_SVC_MAX_ARGS_NUM];
}prop_svc_act_t;

typedef struct
{
    struct  		list slist;
	char			svc_name[PROP_SVC_TYPE_MAX_SIZE]; //"service", or "on property"...
    char    		svc_value[PROPERTY_VALUE_MAX];
    char    		svc_key[PROPERTY_KEY_MAX];
	int			    svc_type;     //"service", or "on property"...
	struct list  	act_list;
    pid_t   		pid;
    int     		flags;
}prop_svc_t;

prop_svc_t * prop_svc_find_by_pid(const pid_t pid);
prop_svc_t * prop_svc_find_by_name(const char *svc_name, const char *prop_key, const char *prop_value);
int prop_svc_get_actions(const prop_svc_t *act_item, char *in_buf);
int prop_svc_del(const prop_svc_t *svc);
int prop_svc_add(const prop_svc_t *svc);
prop_svc_t * prop_svc_exe_by_name(const char *svc_name, const char *prop_key, const char *prop_value, void (*callabck)());
void prop_svc_dump(void);
int prop_svc_add_act(const char *svc_name, const char *svc_key, const char *svc_value, const char *actions);
void prop_svc_init(void);
int prop_svc_get_actions_by_name(const char *svc_name, const char *svc_key, const char *svc_value, char *in_buf);
int prop_svc_get_daemon(const prop_svc_t *act_item, char *in_buf);
int prop_svc_get_daemon_ext(const prop_svc_t *act_item, char *in_buf);
pid_t prop_svc_get_pid(const prop_svc_t *act_item);

#endif
