/* SPDX-License-Identifier: MediaTekProprietary */

#ifndef __PROP_DEBUG_H
#define __PROP_DEBUG_H
#include <syslog.h>

#define PROP_DEBUG_OFF                  0
#define PROP_DEBUG_TEST                 1
#define PROP_DEBUG_ERROR                2
#define PROP_DEBUG_WARN                 3
#define PROP_DEBUG_TRACE                4
#define PROP_DEBUG_INFO                 5
#define PROP_DEBUG_LOUD                 6

extern unsigned int  prop_debug_level;
extern char *prop_debug_name[];
int prop_debug_set(unsigned int level);
int prop_debug_get(void);

#if 0

#define PROP_DEBUG_PRINT(level, str, args...)               \
	do {                                                    \
        if(level<=prop_debug_level)                         \
        {   												\
			printf("\n\r[SNCFGD-PROP] %s - %s ", __FUNCTION__, prop_debug_name[level]); 		\
    		printf(str, ##args);                            \
        }                                                   \
	} while(0)

#define PROP_DEBUG_LOG(level, str, args...)                 \
	do {                                                    \
        if(level<=prop_debug_level)                         \
        {   												\
			printf("\n\r[SNCFGD-PROP] %s - %s ", __FUNCTION__, prop_debug_name[level]); 		\
    		printf(str, ##args);                            \
        }                                                   \
	} while(0)
#else

#define PROP_DEBUG_PRINT(level, str, args...)               \
	do {                                                    \
        if(level<=prop_debug_level)                         \
        { 													\
			syslog(LOG_DEBUG, "[PROP][%s:%d]: " str "\n", __FUNCTION__, __LINE__,  ## args);\
        }      									            \
	} while(0)

#define PROP_DEBUG_LOG(level, str, args...)                 \
	do {                                                    \
        if(level<=prop_debug_level)                         \
        {   												\
			syslog(LOG_DEBUG, "[PROP][%s:%d]: " str "\n", __FUNCTION__, __LINE__,  ## args);\
        }                                                   \
	} while(0)

#endif

#endif
