/*
 * Copyright (c) 2019 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <debug.h>
#include <lib/android_dtbo.h>

int android_dtbo_check_header(const void *dtbo)
{
    if (android_dtbo_magic(dtbo) != DT_TABLE_MAGIC)
        return -DTBO_ERR_BADMAGIC;

    return DTBO_RET_OK;
}

int android_dtbo_get_dt_table_entry(const void *dtbo, uint32_t index,
                                    struct dt_table_entry **entry)
{
    uint32_t offset;

    if (index >= android_dtbo_dt_entry_count(dtbo))
        return -DTBO_ERR_ENTRY_CNT;

    offset = android_dtbo_dt_entries_offset(dtbo) +
             android_dtbo_dt_entry_size(dtbo) * index;
    *entry = (struct dt_table_entry *)(dtbo + offset);

    return DTBO_RET_OK;
}

void *android_dtbo_get_dt_dtbo_entry(const void *dtbo, uint32_t index)
{
    struct dt_table_entry *tbl_entry;

    if (android_dtbo_get_dt_table_entry(dtbo, index, &tbl_entry) != DTBO_RET_OK)
        return NULL;

    return (void *)(dtbo + android_dtbo_tbl_entry_dt_offset(tbl_entry));
}
