#ifndef _RSA_H
#define _RSA_H

#include <errno.h>
#include "image.h"

#define RSA2048_BYTES   (2048 / 8)
#define RSA4096_BYTES   (4096 / 8)

/* This is the minimum/maximum key size we support, in bits */
#define RSA_MIN_KEY_BITS    2048
#define RSA_MAX_KEY_BITS    4096

/* This is the maximum signature length that we support, in bits */
#define RSA_MAX_SIG_BITS    4096

struct key_prop {

    const void *rr;
    const void *modulus;
    const void *public_exponent;
    uint64_t n0inv;
    int num_bits;
    uint32_t exp_len;
};

int rsa_verify(struct sig_info *info,
               const struct fdt_region region[], int region_count,
               uint8_t *sig, uint sig_len);
void get_pubkey_info(struct key_prop *pubkey, const void *blob,int node,
                            int *len);

#endif
