/*
 * Copyright (c) 2019 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <assert.h>
#include <debug.h>
#include <err.h>
#include <fit.h>
#include <lib/console.h>
#include <lib/kcmdline.h>
#include <lib/mempool.h>
#include <libfdt.h>
#include <malloc.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if WITH_LIB_CKSUM
#include <lib/cksum.h>
#endif

#if defined(WITH_LIB_CONSOLE)

#if LK_DEBUGLEVEL > 0
static int cmd_kcmdline(int argc, const cmd_args *argv);

STATIC_COMMAND_START
STATIC_COMMAND("kcmdline", "kcmdline debug commands", &cmd_kcmdline)
STATIC_COMMAND_END(kcmdline);

static int cmd_kcmdline(int argc, const cmd_args *argv)
{
    int rc = 0;

    if (argc < 2) {
notenoughargs:
        printf("not enough arguments:\n");
usage:
        printf("%s init  - init kcmdline\n", argv[0].str);
        printf("%s print - print kcmdline buffer\n", argv[0].str);
        printf("%s append <append_arg>\n", argv[0].str);
        printf("%s subst <old_arg> <new_arg>\n", argv[0].str);
        printf("%s finalized <part_name> - write buffer to <part_name> dtb\n",
               argv[0].str);
        return -1;
    }

    if (!strcmp(argv[1].str, "init")) {
        if ((rc = kcmdline_init()) != NO_ERROR) {
            printf("kcmdline init failed, rc=%d\n", rc);
            return -1;
        }
    } else if (!strcmp(argv[1].str, "print")) {
        kcmdline_print();
    } else if (!strcmp(argv[1].str, "append")) {
        if ((rc = kcmdline_append(argv[2].str)) != NO_ERROR) {
            printf("kcmdline append %s failed, rc=%d\n", argv[2].str, rc);
            return -1;
        }
    } else if (!strcmp(argv[1].str, "subst")) {
        if ((rc = kcmdline_subst(argv[2].str, argv[3].str)) != NO_ERROR) {
            printf("kcmdline subst failed, old: %s, new: %s, rc=%d\n",
                   argv[2].str, argv[3].str, rc);
            return -1;
        }
    } else if (!strcmp(argv[1].str, "finalized")) {
        void *fit;
        addr_t load;

        rc = fit_get_image(argv[2].str, &fit);
        if (rc < 0) {
            printf("fit_get_image: %s failed, rc=%d\n", argv[2].str, rc);
            return -1;
        }
        rc = fit_load_image(NULL, "fdt", fit, &load, NULL, NULL, false);
        if (rc < 0) {
            printf("fit_load_image: load fdt failed, rc=%d\n", rc);
            return -1;
        }
        hexdump((const void *)load, 512);

        if ((rc = kcmdline_finalized((void *)load, 0x200000)) != NO_ERROR) {
            printf("kcmdline finalized failed, rc=%d\n", rc);
            return -1;
        }
    } else {
        printf("unrecognized subcommand\n");
        goto usage;
    }

    return rc;
}
#endif
#endif
