/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once

#include <stddef.h>

#define CMDLINE_LEN   2048

/*
 * kcmdline_init() - initialized kcmdline
 *
 * This function initialize and malloc memory to support later kcmdline
 * operations.
 *
 * return:
 *     NO_ERROR, on success
 *     otherwise, on failure
 */
int kcmdline_init(void);

/*
 * kcmdline_finalized() - update buffered boot args change to device tree blob
 *
 * This function update all buffered kernel boot args changes, including
 * appended boot args and substitued args to kernel device tree blob.
 *
 * @fdt:    pointer to device tree blob
 * @size:   max size for device tree blob
 *
 * return:
 *     NO_ERROR, on success
 *     otherwise, on failure
 */
int kcmdline_finalized(void *fdt, size_t size);

/*
 * kcmdline_print() - print buffered boot args changes
 */
void kcmdline_print(void);

/*
 * kcmdline_append() - append a boot args string to kcmdline buffer
 *
 * This function append a arg string to kcmdline buffer, which will be updated
 * to kernel cmdline (bootargs) of device tree blob later.
 *
 * @append_arg: pointer to the arg string to be appended to kernel cmdline
 *
 * return:
 *     NO_ERROR, on success
 *     otherwise, on failure
 */
int kcmdline_append(const char *append_arg);

/*
 * kcmdline_subst() - add a boot arg substitution request to kcmdline buffer
 *
 * This function records a boot arg substitution request, and keep it in a list.
 * The args in substitution list will be updated to kernel cmdline (bootargs)
 * of device tree blob later.
 *
 * @old_arg: old arg to be searched and substituted
 * @new_arg: new arg for substitution when old_arg exists
 *
 * return:
 *     NO_ERROR, on success
 *     otherwise, on failure
 */
int kcmdline_subst(const char *old_arg, const char *new_arg);
