#include <stdbool.h>
#include <stdint.h>
#include <string.h>
#include <rsa.h>
#if defined(__aarch64__)
typedef __uint128_t uint128_t;
typedef uint128_t uintptr2_t;
#elif defined(__arm__)
typedef uint64_t uintptr2_t;
#else
#error Unsupport architecture
#endif

#define N_BYTES (2048 / 8)
#define N_WORDS (N_BYTES / sizeof(uintptr_t))

int bn_mul_mont(uintptr_t *rp, const uintptr_t *ap, const uintptr_t *bp,
                const uintptr_t *np, const uint64_t *n0, int num);

void mod_exp_65537_mont(uintptr_t *r, const uintptr_t *a, const struct key_prop  *pkey)
{
    const uintptr_t *m, *rr;
    uint64_t n0inv;
    uint32_t n_words;
    size_t i;

    m=pkey->modulus;
    rr=pkey->rr;
    n0inv=pkey->n0inv;
    n_words=(pkey->num_bits/8)/sizeof(uintptr_t);

    uintptr_t ar[n_words];

    bn_mul_mont(ar, a, rr, m, &n0inv, n_words);
    bn_mul_mont(r, ar, ar, m, &n0inv, n_words);
    for (i = 15; i != 0; i--)
        bn_mul_mont(r, r, r, m, &n0inv, n_words);
    bn_mul_mont(r, r, ar, m, &n0inv, n_words);

    memset(ar, 0, sizeof(ar));
    ar[0] = 1;
    bn_mul_mont(r, r, ar, m, &n0inv, n_words);
}

