/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file uart_sw.h
 * @brief Header file of uart_cust driver
 *
 * Foo driver is a blah blah driver, which provides blah blah functions.
 * Several interfaces, init, config, set, get, tx and rx are provided to
 * manipulated the underlying hardware.
 */

#pragma once

#include "cust_common.h"

#define CLOCK_RATE_6M               6000000
#define CLOCK_RATE_12M              12000000
#define CLOCK_RATE_26M              26000000
#define CLOCK_RATE_40M              40000000
#define CLOCK_RATE_52M              52000000
#define UART_CLOCK_RATE             CLOCK_RATE_26M

#define HW_SUPPORT_UART_PORTS       6
#define DRV_SUPPORT_UART_PORTS      6

#define EINVAL_PORT_NUM    -1      /* invalid UART port */
#define EFAULT_POINT       -2      /* invalid piont */
#define EUNINIT_PORT       -3      /* UART port not init */
#define EOUT_RANGE         -4      /* length out of range */
#define EUNCONFIGURE       -5      /* UART port not configure */

#define UART_USING_DMA  1

#define UART_DEBUG      0
#if UART_DEBUG
#define ULOG_ALWAYS ALWAYS
#define ULOG_INFO   ALWAYS
#define ULOG_DEBUG  INFO
#else
#define ULOG_ALWAYS ALWAYS
#define ULOG_INFO   INFO
#define ULOG_DEBUG  INFO
#endif

typedef enum {
    UART_UNINIT,
    UART_INIT,
} UART_INIT_e;

struct uart_info {
    uint32_t irq;
    uint32_t line;
    uint32_t dropped;
    uint32_t status;
    uint32_t baudrate;
    void *base_addr;
    struct circ_buf tx_circ;
    struct circ_buf rx_circ;
};

#define UART_READ32(addr)            readl(addr)
#define UART_WRITE32(addr, value)    writel(value, addr)
#define UART_READ8(addr)             readb(addr)
#define UART_WRITE8(addr, value)     writeb(value, addr)

