/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once

#include <stddef.h>
#include <stdint.h>

/*
 * Define hardware registers.
 */
#define EINT_BASE               (0x1000B000)
#define EINT_STA_OFFSET         (0x000)
#define EINT_INTACK_OFFSET      (0x040)
#define EINT_MASK_OFFSET        (0x080)
#define EINT_MASK_SET_OFFSET    (0x0c0)
#define EINT_MASK_CLR_OFFSET    (0x100)
#define EINT_SENS_OFFSET        (0x140)
#define EINT_SENS_SET_OFFSET    (0x180)
#define EINT_SENS_CLR_OFFSET    (0x1c0)
#define EINT_POL_OFFSET         (0x300)
#define EINT_POL_SET_OFFSET     (0x340)
#define EINT_POL_CLR_OFFSET     (0x380)
#define EINT_D0_EN_OFFSET       (0x400)

/*
 * Define constants.
 */
#define LOW_POLARITY_TRIGGER 0
#define HIGH_POLARITY_TRIGGER 1
#define EDGE_SENSITIVE 0
#define LEVEL_SENSITIVE 1
#define EINT_AP_MAXNUMBER 229
#define EINT_MAX_CHANNEL 229
#define MAX_HW_DEBOUNCE_CNT 40
#define MAX_DEINT_CNT 4
#define EINT_IRQ_BIT_ID  185

typedef enum wrap_handler_return (*eint_handler)(void *arg);

/*
 * EINT Driver interface.
 */
int eint_cust_ack (unsigned int eint_num);
int eint_cust_mask (unsigned int eint_num);
int eint_cust_unmask (unsigned int eint_num);
int eint_cust_set_sens (unsigned int eint_num, unsigned int sens);
int eint_cust_set_polarity (unsigned int eint_num, unsigned int pol);
void eint_cust_registration (unsigned int eint_num, eint_handler handler, void *arg);
int eint_cust_init (void);

