/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file uart_cust.h
 * @brief Header file of uart_cust driver
 *
 * Foo driver is a blah blah driver, which provides blah blah functions.
 * Several interfaces, init, config, set, get, tx and rx are provided to
 * manipulated the underlying hardware.
 */

#pragma once

#include <stddef.h>
#include <stdint.h>

typedef enum {
    UART_PORT0,
    UART_PORT1,
    UART_PORT2,
    UART_PORT3,
    UART_PORT4,
    UART_PORT5,
} UART_PORT_e;

#define BAUD_RATE_115200            115200
#define BAUD_RATE_921600            921600
#define BAUD_RATE_3M                3000000

/**
 * @brief
 *
 * Detail description about uart_cust_init
 * @return 0: on success, -1: otherwise
 */
int uart_cust_init(UART_PORT_e port_line, char *tx_buff, uint32_t tx_buf_len,
                   char *rx_buff, uint32_t rx_buf_len);

/**
 * @brief Foo driver configure function
 *
 * Detail description about uart_cust_config
 * @param attr: uart_cust attribute to be configured
 * @param val: the value to be set to attr
 * @note Add your note here if any
 * @return 0: on success, -1: other wise
 */
int uart_cust_config(UART_PORT_e port_line, uint32_t baudrate,
                   char *dma_buff, uint32_t dma_len);

/**
 */
int uart_cust_tx(UART_PORT_e port_line, const uint8_t *buf, uint32_t size);

/**
 * @brief receiver data from uart port
 * this function will blocked and not return until data availabled
 *
 */
int uart_cust_rx(UART_PORT_e port_line, uint8_t *pbuf, uint32_t size);
