/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <err.h>
#include <eint.h>
#include <stdio.h>
#include <stdlib.h>
#include <unittest.h>

#define eint_num 78

static bool test_eint_cust_init(void)
{
    BEGIN_TEST;

    EXPECT_EQ(1, eint_cust_init(), "fail to test eint_cust_init");

    END_TEST;
}

static bool test_eint_cust_set_sens(void)
{
    BEGIN_TEST;

    EXPECT_EQ(1, eint_cust_set_sens(eint_num,LEVEL_SENSITIVE), "fail to test eint_cust_set_sens");

    END_TEST;
}

static bool test_eint_cust_set_polarity(void)
{
    BEGIN_TEST;

    EXPECT_EQ(1, eint_cust_set_polarity(eint_num,LOW_POLARITY_TRIGGER), "fail to test eint_cust_set_polarity");

    END_TEST;
}

static bool test_eint_cust_unmask(void)
{
    BEGIN_TEST;

    EXPECT_EQ(1, eint_cust_unmask(eint_num), "fail to test eint_cust_unmask");

    END_TEST;
}

static bool test_eint_cust_ack(void)
{
    BEGIN_TEST;

    EXPECT_EQ(1, eint_cust_ack(eint_num), "fail to test eint_cust_ack");

    END_TEST;
}

static bool test_eint_cust_mask(void)
{
    BEGIN_TEST;

    EXPECT_EQ(1, eint_cust_mask(eint_num), "fail to test eint_cust_mask");

    END_TEST;
}

BEGIN_TEST_CASE(eint_tests);
RUN_TEST(test_eint_cust_init);
RUN_TEST(test_eint_cust_set_sens);
RUN_TEST(test_eint_cust_set_polarity);
RUN_TEST(test_eint_cust_unmask);
RUN_TEST(test_eint_cust_ack);
RUN_TEST(test_eint_cust_mask);
END_TEST_CASE(eint_tests);

