/*
* copyright (c) 2018 MediaTek Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining
* a copy of this software and associated documentation files
* (the "Software"), to deal in the Software without restriction,
* including without limitation the rights to use, copy, modify, merge,
* publish, distribute, sublicense, and/or sell copies of the Software,
* and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
*
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <unittest.h>
#include <gpio.h>

/**
 * lib/unittest defines several macros for unittest,
 * EXPECT_EQ, EXPECT_NEQ, EXPECT_LE, EXPECT_LT, EXPECT_GE, EXPECT_GT,
 * EXPECT_TRUE, EXPECT_FALSE, EXPECT_BYTES_EQ, EXPECT_BYTES_NE, EXPECT_EQ_LL,
 * ASSERT_NOT_NULL.
 * For detail, please refer to lib/unittest/include/unittest.h
 */

int gpio_num = 58;

static bool test_gpio_cust_set_mode(void)
{
    BEGIN_TEST;
    gpio_cust_init();

    EXPECT_EQ(NO_ERROR, gpio_cust_set_mode(gpio_num, 0), "fail to test gpio_cust_set_mode(0, 0)");

    END_TEST;
}

static bool test_gpio_cust_get_mode(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_get_mode(gpio_num), "fail to test gpio_cust_get_mode(0)");

    END_TEST;
}

static bool test_gpio_cust_set_dir(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_set_dir(gpio_num, 0), "fail to gpio_cust_set_dir(0, 0)");

    END_TEST;
}

static bool test_gpio_cust_get_dir(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_get_dir(gpio_num), "fail to gpio_cust_get_dir(0)");

    END_TEST;
}

static bool test_gpio_cust_set_pull_enable(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_set_pull_enable(gpio_num, 0, 0), "fail to gpio_cust_set_pull_enable(0, 0, 0)");

    END_TEST;
}

static bool test_gpio_cust_get_pull_enable(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_get_pull_enable(gpio_num), "fail to test gpio_cust_get_pull_enable(0)");

    END_TEST;
}

static bool test_gpio_cust_set_pull_select(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_set_pull_select(gpio_num, 0), "fail to test gpio_cust_set_pull_select(0, 1)");

    END_TEST;
}

static bool test_gpio_cust_get_pull_select(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_get_pull_select(gpio_num), "fail to test gpio_cust_get_pull_select(0)");

    END_TEST;
}

static bool test_gpio_cust_set_out(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_set_out(gpio_num, 0), "fail to test gpio_cust_set_out(0, 1)");

    END_TEST;
}

static bool test_gpio_cust_get_out(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_get_out(gpio_num), "fail to test gpio_cust_get_out(0)");

    END_TEST;
}

static bool test_gpio_cust_get_in(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_get_in(gpio_num), "fail to test gpio_cust_get_in(0)");

    END_TEST;
}

static bool test_gpio_cust_set_driving(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_set_driving(gpio_num, 4), "fail to test gpio_cust_set_driving(0, 0)");

    END_TEST;
}

static bool test_gpio_cust_set_driving_spec(void)
{
    BEGIN_TEST;

    EXPECT_EQ(NO_ERROR, gpio_cust_set_driving(59, 208), "fail to test gpio_cust_set_driving(58, 0)");

    END_TEST;
}

static bool test_gpio_cust_get_irq(void)
{
    BEGIN_TEST;

    EXPECT_EQ(73, gpio_cust_get_irq(gpio_num), "fail to test gpio_cust_get_irq(gpio_num)");

    END_TEST;
}



BEGIN_TEST_CASE(gpio_tests);

RUN_TEST(test_gpio_cust_set_mode);
RUN_TEST(test_gpio_cust_get_mode);

RUN_TEST(test_gpio_cust_set_pull_enable);
RUN_TEST(test_gpio_cust_get_pull_enable);

RUN_TEST(test_gpio_cust_set_pull_select);
RUN_TEST(test_gpio_cust_get_pull_select);

RUN_TEST(test_gpio_cust_set_out);
RUN_TEST(test_gpio_cust_get_out);

RUN_TEST(test_gpio_cust_set_dir);
RUN_TEST(test_gpio_cust_get_dir);

RUN_TEST(test_gpio_cust_get_in);

RUN_TEST(test_gpio_cust_set_driving);

RUN_TEST(test_gpio_cust_set_driving_spec);

RUN_TEST(test_gpio_cust_get_irq);

END_TEST_CASE(gpio_tests);


