/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file uart_dma_hw.h
 * @brief Header file of uart_cust driver
 *
 * Foo driver is a blah blah driver, which provides blah blah functions.
 * Several interfaces, init, config, set, get, tx and rx are provided to
 * manipulated the underlying hardware.
 */

#pragma once

#define APDMA_BASE          (IO_PHYS + 0x1000000)

#define UART_APDMA_OFFSET   0x400   /*the UART0 TX offset from APDMA base Addr */
#define UART_DMA_BASE       (APDMA_BASE + UART_APDMA_OFFSET)

/* Attention! DMA channel address maybe not continues */
#define VFF_BASE_CH_0           (UART_DMA_BASE + 0x0080*0)
#define VFF_BASE_CH_1           (UART_DMA_BASE + 0x0080*1)
#define VFF_BASE_CH_2           (UART_DMA_BASE + 0x0080*2)
#define VFF_BASE_CH_3           (UART_DMA_BASE + 0x0080*3)
#define VFF_BASE_CH_4           (UART_DMA_BASE + 0x0080*4)
#define VFF_BASE_CH_5           (UART_DMA_BASE + 0x0080*5)
#define VFF_BASE_CH_6           (UART_DMA_BASE + 0x0080*6)
#define VFF_BASE_CH_7           (UART_DMA_BASE + 0x0080*7)
#define VFF_BASE_CH_8           (UART_DMA_BASE + 0x0080*8)
#define VFF_BASE_CH_9           (UART_DMA_BASE + 0x0080*9)
#define VFF_BASE_CH_10          (UART_DMA_BASE + 0x0080*10)
#define VFF_BASE_CH_11          (UART_DMA_BASE + 0x0080*11)

#define AP_DMA_UART_IRQ_ID_NA   0
#define VFF_UART0_TX_IRQ_ID     135
#define VFF_UART0_RX_IRQ_ID     136
#define VFF_UART1_TX_IRQ_ID     137
#define VFF_UART1_RX_IRQ_ID     138
#define VFF_UART2_TX_IRQ_ID     139
#define VFF_UART2_RX_IRQ_ID     140
#define VFF_UART3_TX_IRQ_ID     141
#define VFF_UART3_RX_IRQ_ID     142
#define VFF_UART4_TX_IRQ_ID     143
#define VFF_UART4_RX_IRQ_ID     144
#define VFF_UART5_TX_IRQ_ID     145
#define VFF_UART5_RX_IRQ_ID     146


#define VFF_INT_FLAG(_baseaddr)        (_baseaddr+0x0000)
#define VFF_INT_EN(_baseaddr)          (_baseaddr+0x0004)
#define VFF_EN(_baseaddr)              (_baseaddr+0x0008)
#define VFF_RST(_baseaddr)             (_baseaddr+0x000C)
#define VFF_STOP(_baseaddr)            (_baseaddr+0x0010)
#define VFF_FLUSH(_baseaddr)           (_baseaddr+0x0014)
#define VFF_ADDR(_baseaddr)            (_baseaddr+0x001C)
#define VFF_LEN(_baseaddr)             (_baseaddr+0x0024)
#define VFF_THRE(_baseaddr)            (_baseaddr+0x0028)
#define VFF_WPT(_baseaddr)             (_baseaddr+0x002C)
#define VFF_RPT(_baseaddr)             (_baseaddr+0x0030)
#define VFF_RX_FLOWCTL_THRE(_baseaddr) (_baseaddr+0x0034)
#define VFF_INT_BUF_SIZE(_baseaddr)    (_baseaddr+0x0038)
#define VFF_VALID_SIZE(_baseaddr)      (_baseaddr+0x003C)
#define VFF_LEFT_SIZE(_baseaddr)       (_baseaddr+0x0040)
#define VFF_DEBUG_STATUS(_baseaddr)    (_baseaddr+0x0050)


/* VFF_INT_STATUS */
#define VFF_RX_INT_FLAG0_B      (1 << 0)    /*rx_vff_valid_size >= rx_vff_thre*/
#define VFF_RX_INT_FLAG1_B      (1 << 1)    /*when UART issues flush to DMA and all data in UART VFIFO is transferred to VFF*/
#define VFF_RX_INT_FLAG_CLR_B   (VFF_RX_INT_FLAG0_B|VFF_RX_INT_FLAG1_B) /* write 1 to clear INT*/
#define VFF_TX_INT_FLAG0_B      (1 << 0)    /*tx_vff_left_size >= tx_vff_thrs*/
#define VFF_TX_INT_FLAG_CLR_B   (0)     /* write 0 to clear INT*/

/* VFF_INT_EN */
#define VFF_RX_INT_EN0_B        (1 << 0)    /*rx_vff_valid_size >= rx_vff_thre*/
#define VFF_RX_INT_EN1_B        (1 << 1)    /*when UART issues flush to DMA and all data in UART VFIFO is transferred to VFF*/
#define VFF_TX_INT_EN_B         (1 << 0)    /*tx_vff_left_size >= tx_vff_thrs*/
#define VFF_INT_EN_CLR_B        (0 << 0)
#define VFF_RX_INT_ENABLE       (VFF_RX_INT_EN0_B|VFF_RX_INT_EN1_B)
#define VFF_TX_INT_ENABLE       (VFF_TX_INT_EN_B)

/* VFF_EN */
#define VFF_EN_B                (1 << 0)

/* VFF_STOP */
#define VFF_STOP_B              (1 << 0)
#define VFF_STOP_CLR_B          (0 << 0)

/* VFF_FLUSH */
#define VFF_FLUSH_B             (1 << 0)
#define VFF_FLUSH_CLR_B         (0 << 0)

#define UART_DMA_RING_SIZE      0xffff
#define UART_DMA_RING_WRAP      0x10000 /* invert this bit when wrap ring head again*/

/* Virtual FIFO Length */
#define UART_DMA_VFF_LEN_MIN    0x20
#define UART_DMA_VFF_LEN_MAX    0xFFFF

