/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein
* is confidential and proprietary to MediaTek Inc. and/or its licensors.
* Without the prior written permission of MediaTek inc. and/or its licensors,
* any reproduction, modification, use or disclosure of MediaTek Software,
* and information contained herein, in whole or in part, shall be strictly prohibited.
*
* MediaTek Inc. (C) 2020. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
* AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
* NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
* SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
* SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
* THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
* THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
* CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
* SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
* CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
* AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
* OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
* MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
* applicable license agreements with MediaTek Inc.
*/

#pragma once

/******************************************************************************
* CPU FREQUENCE INFO
******************************************************************************/
enum CA35_SPD {
    CA35_SPD_FREE,
    CA35_SPD_1196MHZ,
    CA35_SPD_1001MHZ,
    CA35_SPD_806MHZ
};

enum CA72_SPD {
    CA72_SPD_FREE,
    CA72_SPD_1599MHZ,
    CA72_SPD_1495MHZ,
    CA72_SPD_1391MHZ,
    CA72_SPD_1196MHZ,
    CA72_SPD_1105MHZ,
    CA72_SPD_1001MHZ
};

/******************************************************************************
* SEGMENT INFO
*******************************************************************************/
enum SKUs {
    SKU_FREE,
    SKU_E,
    SKU_M,
    SKU_H,
    SKU_C,
    SKU_A,
    SKU_S,
    SKU_P,
};

/******************************************************************************
 * INTERFACE
 ******************************************************************************/
/*
 * Get the IC segment information.
 * returns: success, The definition of SKUs.
 *          otherwise, -1, an unknown case
 */
int get_cpu_sku(void);

/*
 * Get the CA35 CPU speed bounding.
 * returns: The definition of CA35_SPD.
 */
int get_ca35_freq(void);

/*
 * Get the CA72 CPU speed bounding.
 * returns: success, The definition of CA72_SPD.
 *          otherwise, -1, an unknown case
 */
int get_ca72_freq(void);
