#! /bin/sh

PROJECT=$1
OUT=$2
BOOTDEV_TYPE=$3
SCATTER_SRC=$4
NAND_CHIP_NAME=$5
NAND_HEADER_VERSION=$6
HEADER_LK_MERGE=$7


if [ ! -e ${PROJECT}/gen-partitions.ini ]; then
	echo ERROR: can not find $1
	exit 1
fi

mkdir -p ${OUT}
cat ${PROJECT}/gen-partitions.ini | while read p s m t
do
	if [ "$t" = "" ]; then
		OUT_T=""
	else
		OUT_T=${OUT}/$t
	fi

	GEN_PARTITION_SCRIPT=gen-partition.py
	if [ "${BOOTDEV_TYPE}" = "nand" ]; then
		if [ "${HEADER_LK_MERGE}" = "yes" ]; then
			GEN_PARTITION_SCRIPT=gen-partition-nand_merge.py
		else
			GEN_PARTITION_SCRIPT=gen-partition-nand.py
		fi
	fi

	python3 ${SCATTER_SRC}/${GEN_PARTITION_SCRIPT} ${PROJECT}/$p ${PROJECT}/$s ${OUT}/$m ${OUT_T}

	if [ "${BOOTDEV_TYPE}" = "nand" ]; then
		if [ "${NAND_HEADER_VERSION}" = "2.0" ]; then
			if [ "$m" = "MBR_NAND" ]; then
				python3 -B ${PWD}/tools/nand-utils/gen_nand_header.py ${NAND_CHIP_NAME} ${OUT}/$m
			fi
		elif [ "${NAND_HEADER_VERSION}" = "1.1" ]; then
			lk_start=$(grep 'name="bl2"' ${PROJECT}/$p | grep -o 'start="[0-9]*"' | grep -o [0-9]*)
			if [ "${lk_start}" = "" ]; then
				echo ERROR: can not find UBOOT in ${PROJECT}/$p
				exit 1
			fi
			temp_header_file="temp_nand_header.bin"
			python3 -B ${PWD}/tools/nand-utils/gen_nand_header_v11.py ${NAND_CHIP_NAME} ${lk_start} ${OUT}/${temp_header_file}
			cat ${OUT}/$m >> ${OUT}/${temp_header_file}
			rm ${OUT}/$m
			mv ${OUT}/${temp_header_file} ${OUT}/$m
		elif [ "${NAND_HEADER_VERSION}" = "1.2" ]; then
			temp_header_file="temp_nand_header.bin"
			python3 -B ${PWD}/tools/nand-utils/gen_nand_header_v12.py ${NAND_CHIP_NAME} ${OUT}/${temp_header_file}
			dd if=${OUT}/${temp_header_file} of=${OUT}/$m conv=notrunc
			rm ${OUT}/${temp_header_file}
		elif [ "${NAND_HEADER_VERSION}" = "1.3" ]; then
			preloader_start=$(grep 'name="preloader"' ${PROJECT}/$p | grep -o 'start="[0-9]*"' | grep -o [0-9]*)
			if [ "${preloader_start}" = "" ]; then
					echo ERROR: can not find preloader in ${PROJECT}/$p
					exit 1
			fi
			temp_header_file="temp_nand_header.bin"
			python3 -B ${PWD}/tools/nand-utils/gen_nand_header_v13.py ${NAND_CHIP_NAME} ${preloader_start} ${OUT}/${temp_header_file}
			cat ${OUT}/$m >> ${OUT}/${temp_header_file}
			rm ${OUT}/$m
			mv ${OUT}/${temp_header_file} ${OUT}/$m
		elif [ "${NAND_HEADER_VERSION}" = "1.4" ]; then
			temp_header_file="temp_nand_header.bin"
			python3 -B ${PWD}/tools/nand-utils/gen_nand_header_v14.py ${NAND_CHIP_NAME} ${OUT}/${temp_header_file}
			dd if=${OUT}/${temp_header_file} of=${OUT}/$m conv=notrunc
			rm ${OUT}/${temp_header_file}
		elif [ "${NAND_HEADER_VERSION}" = "3.0" ]; then
			if [ "$m" = "MBR_NAND" ]; then
				python -B ${PWD}/tools/nand-utils/gen_nand_header_mt2731.py ${NAND_CHIP_NAME} ${OUT}/$m
			fi
		elif [ "${NAND_HEADER_VERSION}" = "4.0" ]; then
			if [ "$m" = "MBR_NAND" ]; then
				python3 -B ${PWD}/tools/nand-utils/gen_nand_header_v4.py ${NAND_CHIP_NAME} ${OUT}/$m
			fi
		elif [ "${NAND_HEADER_VERSION}" = "5.0" ]; then
			if [ "$m" = "MBR_NAND" ]; then
				python -B ${PWD}/tools/nand-utils/gen_nand_header_mt2735_hsm.py ${NAND_CHIP_NAME} ${OUT}/$m
			fi
		elif [ "${NAND_HEADER_VERSION}" = "6.0" ]; then
			if [ "$m" = "MBR_NAND" ]; then
				python3 -B ${PWD}/tools/nand-utils/gen_nand_header_v6.py ${NAND_CHIP_NAME} ${OUT}/$m ${HEADER_LK_MERGE}
			fi
		else
			if [ "${NAND_CHIP_NAME}" = "" ]; then
				echo ERROR: please check NAND_CHIP_NAME ${NAND_CHIP_NAME}
				exit 2
			fi

			PAGE_SIZE=$(grep -o '^'${NAND_CHIP_NAME}'	[0-9]*' nand-setting.txt | grep -o '[0-9]*$')
			LBS=$(grep -o 'lbs="[0-9]*"' ${PROJECT}/$p | grep -o [0-9]*)
			if [ "${PAGE_SIZE}" != "${LBS}" ]; then
				echo ERROR: PAGE_SIZE ${PAGE_SIZE} of NAND ${NAND_CHIP_NAME} != LBS ${LBS} of partition table ${PROJECT}/$p
				exit 3
			fi

			LK1=$(grep 'name="LK1"' ${PROJECT}/$p | grep -o 'start="[0-9]*"' | grep -o [0-9]*)
			if [ "${LK1}" = "" ]; then
				echo ERROR: can not find LK1 in ${PROJECT}/$p
				exit 4
			fi

			LK2=$(grep 'name="LK2"' ${PROJECT}/$p | grep -o 'start="[0-9]*"' | grep -o [0-9]*)
			if [ "${LK2}" = "" ]; then
				echo ERROR: can not find LK2 in ${PROJECT}/$p
				exit 5
			fi

			python3 scripts/dev-info-hdr-tool.py ${BOOTDEV_TYPE} ${OUT}/$m ${OUT}/$m ${NAND_CHIP_NAME} ${LK1} ${LK2}
		fi
	fi
done
