#!/usr/bin/env python

import ecc_bch
import sys
import os
import struct
import argparse

def gen_header(nand_name, header_file):
	""" device info:
	name vendor pagesize(B) sparesize(B) pageperblock blocks cycle
	"""
	with open(os.getcwd() + "/tools/nand-utils/nand_device_list_mt2735_hsm.txt", "r") as f:
		found = 0
		for l in f:
			s = l.split()
			if s[0] == nand_name:
				found = 1
				vendor = s[1]
				page_size = int(s[2])
				spare_size = int(s[3])
				pages_per_block = int(s[4])
				blocks = int(s[5])
				cycle = int(s[6])
				config = int(s[7], 16)
				pll = int(s[8])
				acccon = int(s[9], 16)
				strobe_sel = int(s[10])
				latch_lat = int(s[11])
				sam_dly = int(s[12])
		if not found:
			raise KeyError("not support " + nand_name)

	# step1: generate nand header info #
	header = "NANDCFG!"
	version = 1
	sector_size = 1024
	fdm_size = 8
	fdmecc_size = 1
	lbs = 0
	header += struct.pack("IIIIII", version, config, sector_size,\
					fdm_size, fdmecc_size, lbs)
	plane_sel_poi = 12
	# parameter page is enabled
	parameter_page_en = (1 << 2)
	if (config & parameter_page_en):
		nand = struct.pack("IIIII", 0, 0,\
					0,  0,\
					plane_sel_poi)
	else:
		#For SGPT, BROM will read SGPT from blocks-5, the last 4 blocks are BBT blocks
		blocks = blocks - 4
		nand = struct.pack("IIIII", page_size, spare_size,\
					pages_per_block,  blocks,\
					plane_sel_poi)
	header += nand
	acccon1 = 0
	dqs_delay_mux = 0
	dqs_delay_ctrl = 0
	delay_ctrl = 0
	driving = 0
	high_speed = struct.pack("IIIIIIIIII", pll, acccon, strobe_sel,\
					acccon1, dqs_delay_mux,\
					dqs_delay_ctrl, delay_ctrl,\
					latch_lat, sam_dly, driving)
	header += high_speed
	bl_start = 0
	bl_end = 0
	header += struct.pack("II", bl_start, bl_end)
	ecc_level = 24
	header_size = len(header) + ecc_level * 14 / 8
	print "header_size: %d" % header_size

	ecc = ecc_bch.bch_enc_14(header, len(header), ecc_level)
	header += ecc

	with open(header_file, "wb") as f:
		f.write(header)

	return (header_size, sector_size, fdm_size, fdmecc_size, lbs)

def main(argv):
	parser = argparse.ArgumentParser()
	parser.add_argument('nand_name', help = 'nand device name')
	parser.add_argument('gpt_image', help = 'pmbr + gpt entry image ')
	args = parser.parse_args()

	header_file = args.nand_name + '_header.bin'
	# generate nand device header #
	gen_header(args.nand_name, header_file)

	# pad nand header #
	with open(header_file, "rb") as f_h:
		h_buf = f_h.read()
	with open(args.gpt_image, "rb+") as f_g:
		f_g.seek(440, 0)
		h_buf += '\x00' * (440 - len(h_buf))
		h_buf = h_buf + f_g.read()
		f_g.seek(0, 0)
		f_g.write(h_buf)

	os.remove(header_file)

if __name__ == "__main__":
	sys.exit(main(sys.argv))
