#!/usr/bin/env python3

import math

M_14_4 = ((0x85,0x5c,0x9a,0x89,0x8a,0x48,0x9b,0x01),
	  (0x0a,0xb9,0x34,0x13,0x15,0x91,0x36,0x03),
	  (0x14,0x72,0x69,0x26,0x2a,0x22,0x6d,0x06),
	  (0x28,0xe4,0xd2,0x4c,0x54,0x44,0xda,0x0c),
	  (0x50,0xc8,0xa5,0x99,0xa8,0x88,0xb4,0x19),
	  (0xa0,0x90,0x4b,0x33,0x51,0x11,0x69,0x33),
	  (0x40,0x21,0x97,0x66,0xa2,0x22,0xd2,0x66),
	  (0x80,0x42,0x2e,0xcd,0x44,0x45,0xa4,0xcd))

M_14_6 = ((0xf9,0x0f,0x2a,0x86,0x79,0xef,0x10,0x33,0xaf,0x5c,0x12,0x00),
	  (0xf2,0x1f,0x54,0x0c,0xf3,0xde,0x21,0x66,0x5e,0xb9,0x24,0x00),
	  (0xe4,0x3f,0xa8,0x18,0xe6,0xbd,0x43,0xcc,0xbc,0x72,0x49,0x00),
	  (0xc8,0x7f,0x50,0x31,0xcc,0x7b,0x87,0x98,0x79,0xe5,0x92,0x00),
	  (0x90,0xff,0xa0,0x62,0x98,0xf7,0x0e,0x31,0xf3,0xca,0x25,0x01),
	  (0x20,0xff,0x41,0xc5,0x30,0xef,0x1d,0x62,0xe6,0x95,0x4b,0x02),
	  (0x40,0xfe,0x83,0x8a,0x61,0xde,0x3b,0xc4,0xcc,0x2b,0x97,0x04),
	  (0x80,0xfc,0x07,0x15,0xc3,0xbc,0x77,0x88,0x99,0x57,0x2e,0x09))

M_14_8 = ((0xff,0xbc,0xd3,0xff,0x94,0x43,0x78,0xdc,0x34,0x8f,0x9c,0x67,0x75,0x68,0x01),
	  (0xfe,0x79,0xa7,0xff,0x29,0x87,0xf0,0xb8,0x69,0x1e,0x39,0xcf,0xea,0xd0,0x02),
	  (0xfc,0xf3,0x4e,0xff,0x53,0x0e,0xe1,0x71,0xd3,0x3c,0x72,0x9e,0xd5,0xa1,0x05),
	  (0xf8,0xe7,0x9d,0xfe,0xa7,0x1c,0xc2,0xe3,0xa6,0x79,0xe4,0x3c,0xab,0x43,0x0b),
	  (0xf0,0xcf,0x3b,0xfd,0x4f,0x39,0x84,0xc7,0x4d,0xf3,0xc8,0x79,0x56,0x87,0x16),
	  (0xe0,0x9f,0x77,0xfa,0x9f,0x72,0x08,0x8f,0x9b,0xe6,0x91,0xf3,0xac,0x0e,0x2d),
	  (0xc0,0x3f,0xef,0xf4,0x3f,0xe5,0x10,0x1e,0x37,0xcd,0x23,0xe7,0x59,0x1d,0x5a),
	  (0x80,0x7f,0xde,0xe9,0x7f,0xca,0x21,0x3c,0x6e,0x9a,0x47,0xce,0xb3,0x3a,0xb4))

M_14_10 = ((0x39,0xb4,0xc5,0x64,0x41,0x71,0xe9,0xdc,0x14,0x76,0x1f,0x20,0xc4,0xdb,0xb7,0xb4,0x92,0x16,0x00),
	   (0x72,0x68,0x8b,0xc9,0x82,0xe2,0xd2,0xb9,0x29,0xec,0x3e,0x40,0x88,0xb7,0x6f,0x69,0x25,0x2d,0x00),
	   (0xe4,0xd0,0x16,0x93,0x05,0xc5,0xa5,0x73,0x53,0xd8,0x7d,0x80,0x10,0x6f,0xdf,0xd2,0x4a,0x5a,0x00),
	   (0xc8,0xa1,0x2d,0x26,0x0b,0x8a,0x4b,0xe7,0xa6,0xb0,0xfb,0x00,0x21,0xde,0xbe,0xa5,0x95,0xb4,0x00),
	   (0x90,0x43,0x5b,0x4c,0x16,0x14,0x97,0xce,0x4d,0x61,0xf7,0x01,0x42,0xbc,0x7d,0x4b,0x2b,0x69,0x01),
	   (0x20,0x87,0xb6,0x98,0x2c,0x28,0x2e,0x9d,0x9b,0xc2,0xee,0x03,0x84,0x78,0xfb,0x96,0x56,0xd2,0x02),
	   (0x40,0x0e,0x6d,0x31,0x59,0x50,0x5c,0x3a,0x37,0x85,0xdd,0x07,0x08,0xf1,0xf6,0x2d,0xad,0xa4,0x05),
	   (0x80,0x1c,0xda,0x62,0xb2,0xa0,0xb8,0x74,0x6e,0x0a,0xbb,0x0f,0x10,0xe2,0xed,0x5b,0x5a,0x49,0x0b))

M_14_12 = ((0x09,0xba,0x4b,0x25,0xd5,0xac,0x8b,0x18,0x40,0xfa,0x59,0x74,0xbd,0x76,0x3c,0xaf,0x8e,0x99,0x61,0xd4,0x60,0x01),
	   (0x12,0x74,0x97,0x4a,0xaa,0x59,0x17,0x31,0x80,0xf4,0xb3,0xe8,0x7a,0xed,0x78,0x5e,0x1d,0x33,0xc3,0xa8,0xc1,0x02),
	   (0x24,0xe8,0x2e,0x95,0x54,0xb3,0x2e,0x62,0x00,0xe9,0x67,0xd1,0xf5,0xda,0xf1,0xbc,0x3a,0x66,0x86,0x51,0x83,0x05),
	   (0x48,0xd0,0x5d,0x2a,0xa9,0x66,0x5d,0xc4,0x00,0xd2,0xcf,0xa2,0xeb,0xb5,0xe3,0x79,0x75,0xcc,0x0c,0xa3,0x06,0x0b),
	   (0x90,0xa0,0xbb,0x54,0x52,0xcd,0xba,0x88,0x01,0xa4,0x9f,0x45,0xd7,0x6b,0xc7,0xf3,0xea,0x98,0x19,0x46,0x0d,0x16),
	   (0x20,0x41,0x77,0xa9,0xa4,0x9a,0x75,0x11,0x03,0x48,0x3f,0x8b,0xae,0xd7,0x8e,0xe7,0xd5,0x31,0x33,0x8c,0x1a,0x2c),
	   (0x40,0x82,0xee,0x52,0x49,0x35,0xeb,0x22,0x06,0x90,0x7e,0x16,0x5d,0xaf,0x1d,0xcf,0xab,0x63,0x66,0x18,0x35,0x58),
	   (0x80,0x04,0xdd,0xa5,0x92,0x6a,0xd6,0x45,0x0c,0x20,0xfd,0x2c,0xba,0x5e,0x3b,0x9e,0x57,0xc7,0xcc,0x30,0x6a,0xb0))

M_14_14 = (
	(0x99,0xb1,0x75,0x12,0xb5,0xb2,0xee,0x98,0xe1,0x46,0x4a,0x20,0xd7,0xc9,0xfd,0x38,0xff,0x67,0xc8,0xff,0xa6,0xe7,0xcb,0xe5,0x13,0x00),
	(0x32,0x63,0xeb,0x24,0x6a,0x65,0xdd,0x31,0xc3,0x8d,0x94,0x40,0xae,0x93,0xfb,0x71,0xfe,0xcf,0x90,0xff,0x4d,0xcf,0x97,0xcb,0x27,0x00),
	(0x64,0xc6,0xd6,0x49,0xd4,0xca,0xba,0x63,0x86,0x1b,0x29,0x81,0x5c,0x27,0xf7,0xe3,0xfc,0x9f,0x21,0xff,0x9b,0x9e,0x2f,0x97,0x4f,0x00),
	(0xc8,0x8c,0xad,0x93,0xa8,0x95,0x75,0xc7,0x0c,0x37,0x52,0x02,0xb9,0x4e,0xee,0xc7,0xf9,0x3f,0x43,0xfe,0x37,0x3d,0x5f,0x2e,0x9f,0x00),
	(0x90,0x19,0x5b,0x27,0x51,0x2b,0xeb,0x8e,0x19,0x6e,0xa4,0x04,0x72,0x9d,0xdc,0x8f,0xf3,0x7f,0x86,0xfc,0x6f,0x7a,0xbe,0x5c,0x3e,0x01),
	(0x20,0x33,0xb6,0x4e,0xa2,0x56,0xd6,0x1d,0x33,0xdc,0x48,0x09,0xe4,0x3a,0xb9,0x1f,0xe7,0xff,0x0c,0xf9,0xdf,0xf4,0x7c,0xb9,0x7c,0x02),
	(0x40,0x66,0x6c,0x9d,0x44,0xad,0xac,0x3b,0x66,0xb8,0x91,0x12,0xc8,0x75,0x72,0x3f,0xce,0xff,0x19,0xf2,0xbf,0xe9,0xf9,0x72,0xf9,0x04),
	(0x80,0xcc,0xd8,0x3a,0x89,0x5a,0x59,0x77,0xcc,0x70,0x23,0x25,0x90,0xeb,0xe4,0x7e,0x9c,0xff,0x33,0xe4,0x7f,0xd3,0xf3,0xe5,0xf2,0x09))

M_14_16 = (
	(0x67,0x48,0x60,0x1c,0xa4,0x8a,0x25,0x51,0x86,0x8a,0x12,0x09,0x34,0xe5,0xfd,
		0xd7,0x8f,0x87,0x57,0x33,0x44,0x2e,0x6f,0x23,0xab,0x82,0xdd,0xe6,0x01),
	(0xce,0x90,0xc0,0x38,0x48,0x15,0x4b,0xa2,0x0c,0x15,0x25,0x12,0x68,0xca,0xfb,
		0xaf,0x1f,0x0f,0xaf,0x66,0x88,0x5c,0xde,0x46,0x56,0x05,0xbb,0xcd,0x03),
	(0x9c,0x21,0x81,0x71,0x90,0x2a,0x96,0x44,0x19,0x2a,0x4a,0x24,0xd0,0x94,0xf7,
		0x5f,0x3f,0x1e,0x5e,0xcd,0x10,0xb9,0xbc,0x8d,0xac,0x0a,0x76,0x9b,0x07),
	(0x38,0x43,0x02,0xe3,0x20,0x55,0x2c,0x89,0x32,0x54,0x94,0x48,0xa0,0x29,0xef,
		0xbf,0x7e,0x3c,0xbc,0x9a,0x21,0x72,0x79,0x1b,0x59,0x15,0xec,0x36,0x0f),
	(0x70,0x86,0x04,0xc6,0x41,0xaa,0x58,0x12,0x65,0xa8,0x28,0x91,0x40,0x53,0xde,
		0x7f,0xfd,0x78,0x78,0x35,0x43,0xe4,0xf2,0x36,0xb2,0x2a,0xd8,0x6d,0x1e),
	(0xe0,0x0c,0x09,0x8c,0x83,0x54,0xb1,0x24,0xca,0x50,0x51,0x22,0x81,0xa6,0xbc,
		0xff,0xfa,0xf1,0xf0,0x6a,0x86,0xc8,0xe5,0x6d,0x64,0x55,0xb0,0xdb,0x3c),
	(0xc0,0x19,0x12,0x18,0x07,0xa9,0x62,0x49,0x94,0xa1,0xa2,0x44,0x02,0x4d,0x79,
		0xff,0xf5,0xe3,0xe1,0xd5,0x0c,0x91,0xcb,0xdb,0xc8,0xaa,0x60,0xb7,0x79),
	(0x80,0x33,0x24,0x30,0x0e,0x52,0xc5,0x92,0x28,0x43,0x45,0x89,0x04,0x9a,0xf2,
		0xfe,0xeb,0xc7,0xc3,0xab,0x19,0x22,0x97,0xb7,0x91,0x55,0xc1,0x6e,0xf3))

M_14_18 = (
	(0x05,0x2c,0x4b,0x17,0x5e,0x12,0x96,0x3a,0x12,0x8e,0x9d,0x4b,0xcb,0x85,0x8d,
		0xa5,0x7d,0x91,0x59,0x4e,0x86,0xb6,0x5a,0xca,0xc7,0x0c,0x3f,0x1c,0x20,0xd3,0x7e,0x1a,0x00),
	(0x0a,0x58,0x96,0x2e,0xbc,0x24,0x2c,0x75,0x24,0x1c,0x3b,0x97,0x96,0x0b,0x1b,
		0x4b,0xfb,0x22,0xb3,0x9c,0x0c,0x6d,0xb5,0x94,0x8f,0x19,0x7e,0x38,0x40,0xa6,0xfd,0x34,0x00),
	(0x14,0xb0,0x2c,0x5d,0x78,0x49,0x58,0xea,0x48,0x38,0x76,0x2e,0x2d,0x17,0x36,
		0x96,0xf6,0x45,0x66,0x39,0x19,0xda,0x6a,0x29,0x1f,0x33,0xfc,0x70,0x80,0x4c,0xfb,0x69,0x00),
	(0x28,0x60,0x59,0xba,0xf0,0x92,0xb0,0xd4,0x91,0x70,0xec,0x5c,0x5a,0x2e,0x6c,
		0x2c,0xed,0x8b,0xcc,0x72,0x32,0xb4,0xd5,0x52,0x3e,0x66,0xf8,0xe1,0x00,0x99,0xf6,0xd3,0x00),
	(0x50,0xc0,0xb2,0x74,0xe1,0x25,0x61,0xa9,0x23,0xe1,0xd8,0xb9,0xb4,0x5c,0xd8,
		0x58,0xda,0x17,0x99,0xe5,0x64,0x68,0xab,0xa5,0x7c,0xcc,0xf0,0xc3,0x01,0x32,0xed,0xa7,0x01),
	(0xa0,0x80,0x65,0xe9,0xc2,0x4b,0xc2,0x52,0x47,0xc2,0xb1,0x73,0x69,0xb9,0xb0,
		0xb1,0xb4,0x2f,0x32,0xcb,0xc9,0xd0,0x56,0x4b,0xf9,0x98,0xe1,0x87,0x03,0x64,0xda,0x4f,0x03),
	(0x40,0x01,0xcb,0xd2,0x85,0x97,0x84,0xa5,0x8e,0x84,0x63,0xe7,0xd2,0x72,0x61,
		0x63,0x69,0x5f,0x64,0x96,0x93,0xa1,0xad,0x96,0xf2,0x31,0xc3,0x0f,0x07,0xc8,0xb4,0x9f,0x06),
	(0x80,0x02,0x96,0xa5,0x0b,0x2f,0x09,0x4b,0x1d,0x09,0xc7,0xce,0xa5,0xe5,0xc2,
		0xc6,0xd2,0xbe,0xc8,0x2c,0x27,0x43,0x5b,0x2d,0xe5,0x63,0x86,0x1f,0x0e,0x90,0x69,0x3f,0x0d))
M_14_20 = (
	(0xe1,0xa2,0x8a,0xab,0x20,0x3f,0xfa,0x57,0x9f,0x6b,0xe5,0x09,0x6b,0xb4,0xc2,0x9a,
		0x1d,0xaa,0xd3,0xde,0xd7,0x84,0x38,0x7a,0x50,0x9b,0x98,0x15,0xf1,0xd5,0xb5,0x2c,0x13,0x87,0x35,0x01),
	(0xc2,0x45,0x15,0x57,0x41,0x7e,0xf4,0xaf,0x3e,0xd7,0xca,0x13,0xd6,0x68,0x85,0x35,
		0x3b,0x54,0xa7,0xbd,0xaf,0x09,0x71,0xf4,0xa0,0x36,0x31,0x2b,0xe2,0xab,0x6b,0x59,0x26,0x0e,0x6b,0x02),
	(0x84,0x8b,0x2a,0xae,0x82,0xfc,0xe8,0x5f,0x7d,0xae,0x95,0x27,0xac,0xd1,0x0a,0x6b,
		0x76,0xa8,0x4e,0x7b,0x5f,0x13,0xe2,0xe8,0x41,0x6d,0x62,0x56,0xc4,0x57,0xd7,0xb2,0x4c,0x1c,0xd6,0x04),
	(0x08,0x17,0x55,0x5c,0x05,0xf9,0xd1,0xbf,0xfa,0x5c,0x2b,0x4f,0x58,0xa3,0x15,0xd6,
		0xec,0x50,0x9d,0xf6,0xbe,0x26,0xc4,0xd1,0x83,0xda,0xc4,0xac,0x88,0xaf,0xae,0x65,0x99,0x38,0xac,0x09),
	(0x10,0x2e,0xaa,0xb8,0x0a,0xf2,0xa3,0x7f,0xf5,0xb9,0x56,0x9e,0xb0,0x46,0x2b,0xac,
		0xd9,0xa1,0x3a,0xed,0x7d,0x4d,0x88,0xa3,0x07,0xb5,0x89,0x59,0x11,0x5f,0x5d,0xcb,0x32,0x71,0x58,0x13),
	(0x20,0x5c,0x54,0x71,0x15,0xe4,0x47,0xff,0xea,0x73,0xad,0x3c,0x61,0x8d,0x56,0x58,
		0xb3,0x43,0x75,0xda,0xfb,0x9a,0x10,0x47,0x0f,0x6a,0x13,0xb3,0x22,0xbe,0xba,0x96,0x65,0xe2,0xb0,0x26),
	(0x40,0xb8,0xa8,0xe2,0x2a,0xc8,0x8f,0xfe,0xd5,0xe7,0x5a,0x79,0xc2,0x1a,0xad,0xb0,
		0x66,0x87,0xea,0xb4,0xf7,0x35,0x21,0x8e,0x1e,0xd4,0x26,0x66,0x45,0x7c,0x75,0x2d,0xcb,0xc4,0x61,0x4d),
	(0x80,0x70,0x51,0xc5,0x55,0x90,0x1f,0xfd,0xab,0xcf,0xb5,0xf2,0x84,0x35,0x5a,0x61,
		0xcd,0x0e,0xd5,0x69,0xef,0x6b,0x42,0x1c,0x3d,0xa8,0x4d,0xcc,0x8a,0xf8,0xea,0x5a,0x96,0x89,0xc3,0x9a))

M_14_22 = (
	(0x33,0xdb,0xdc,0x30,0x9c,0xe3,0xd0,0x5d,0x4f,0xfe,0x2f,0x46,0xe6,0x42,0xf9,0x14,0x3b,0xbf,
		0x84,0xff,0xc6,0x12,0xc8,0x8e,0x88,0x2d,0x62,0xf7,0xd7,0xdf,0x4a,0xfa,0x92,0x8a,0xd6,0x0c,0xb3,0xc9,0x13,0x00),
	(0x66,0xb6,0xb9,0x61,0x38,0xc7,0xa1,0xbb,0x9e,0xfc,0x5f,0x8c,0xcc,0x85,0xf2,0x29,0x76,0x7e,
		0x09,0xff,0x8d,0x25,0x90,0x1d,0x11,0x5b,0xc4,0xee,0xaf,0xbf,0x95,0xf4,0x25,0x15,0xad,0x19,0x66,0x93,0x27,0x00),
	(0xcc,0x6c,0x73,0xc3,0x70,0x8e,0x43,0x77,0x3d,0xf9,0xbf,0x18,0x99,0x0b,0xe5,0x53,0xec,0xfc,
		0x12,0xfe,0x1b,0x4b,0x20,0x3b,0x22,0xb6,0x88,0xdd,0x5f,0x7f,0x2b,0xe9,0x4b,0x2a,0x5a,0x33,0xcc,0x26,0x4f,0x00),
	(0x98,0xd9,0xe6,0x86,0xe1,0x1c,0x87,0xee,0x7a,0xf2,0x7f,0x31,0x32,0x17,0xca,0xa7,0xd8,0xf9,
		0x25,0xfc,0x37,0x96,0x40,0x76,0x44,0x6c,0x11,0xbb,0xbf,0xfe,0x56,0xd2,0x97,0x54,0xb4,0x66,0x98,0x4d,0x9e,0x00),
	(0x30,0xb3,0xcd,0x0d,0xc3,0x39,0x0e,0xdd,0xf5,0xe4,0xff,0x62,0x64,0x2e,0x94,0x4f,0xb1,0xf3,
		0x4b,0xf8,0x6f,0x2c,0x81,0xec,0x88,0xd8,0x22,0x76,0x7f,0xfd,0xad,0xa4,0x2f,0xa9,0x68,0xcd,0x30,0x9b,0x3c,0x01),
	(0x60,0x66,0x9b,0x1b,0x86,0x73,0x1c,0xba,0xeb,0xc9,0xff,0xc5,0xc8,0x5c,0x28,0x9f,0x62,0xe7,
		0x97,0xf0,0xdf,0x58,0x02,0xd9,0x11,0xb1,0x45,0xec,0xfe,0xfa,0x5b,0x49,0x5f,0x52,0xd1,0x9a,0x61,0x36,0x79,0x02),
	(0xc0,0xcc,0x36,0x37,0x0c,0xe7,0x38,0x74,0xd7,0x93,0xff,0x8b,0x91,0xb9,0x50,0x3e,0xc5,0xce,
		0x2f,0xe1,0xbf,0xb1,0x04,0xb2,0x23,0x62,0x8b,0xd8,0xfd,0xf5,0xb7,0x92,0xbe,0xa4,0xa2,0x35,0xc3,0x6c,0xf2,0x04),
	(0x80,0x99,0x6d,0x6e,0x18,0xce,0x71,0xe8,0xae,0x27,0xff,0x17,0x23,0x73,0xa1,0x7c,0x8a,0x9d,
		0x5f,0xc2,0x7f,0x63,0x09,0x64,0x47,0xc4,0x16,0xb1,0xfb,0xeb,0x6f,0x25,0x7d,0x49,0x45,0x6b,0x86,0xd9,0xe4,0x09))

M_14_24 = (
	(0xe3,0x52,0x0e,0x48,0x62,0x13,0x72,0xa9,0x45,0x49,0x9d,0x16,0x6f,0x37,0x17,0x32,0xfe,0x9c,0xe1,0xe2,
		0x62,0xc9,0x86,0x96,0x28,0x92,0x8b,0x0b,0x24,0xb4,0x17,0xaa,0xed,0xa0,0x25,0x93,0xb2,0x58,0xad,0x57,0x18,0xee,0x01),
	(0xc6,0xa5,0x1c,0x90,0xc4,0x26,0xe4,0x52,0x8b,0x92,0x3a,0x2d,0xde,0x6e,0x2e,0x64,0xfc,0x39,0xc3,0xc5,
		0xc5,0x92,0x0d,0x2d,0x51,0x24,0x17,0x17,0x48,0x68,0x2f,0x54,0xdb,0x41,0x4b,0x26,0x65,0xb1,0x5a,0xaf,0x30,0xdc,0x03),
	(0x8c,0x4b,0x39,0x20,0x89,0x4d,0xc8,0xa5,0x16,0x25,0x75,0x5a,0xbc,0xdd,0x5c,0xc8,0xf8,0x73,0x86,0x8b,
		0x8b,0x25,0x1b,0x5a,0xa2,0x48,0x2e,0x2e,0x90,0xd0,0x5e,0xa8,0xb6,0x83,0x96,0x4c,0xca,0x62,0xb5,0x5e,0x61,0xb8,0x07),
	(0x18,0x97,0x72,0x40,0x12,0x9b,0x90,0x4b,0x2d,0x4a,0xea,0xb4,0x78,0xbb,0xb9,0x90,0xf1,0xe7,0x0c,0x17,
		0x17,0x4b,0x36,0xb4,0x44,0x91,0x5c,0x5c,0x20,0xa1,0xbd,0x50,0x6d,0x07,0x2d,0x99,0x94,0xc5,0x6a,0xbd,0xc2,0x70,0x0f),
	(0x30,0x2e,0xe5,0x80,0x24,0x36,0x21,0x97,0x5a,0x94,0xd4,0x69,0xf1,0x76,0x73,0x21,0xe3,0xcf,0x19,0x2e,
		0x2e,0x96,0x6c,0x68,0x89,0x22,0xb9,0xb8,0x40,0x42,0x7b,0xa1,0xda,0x0e,0x5a,0x32,0x29,0x8b,0xd5,0x7a,0x85,0xe1,0x1e),
	(0x60,0x5c,0xca,0x01,0x49,0x6c,0x42,0x2e,0xb5,0x28,0xa9,0xd3,0xe2,0xed,0xe6,0x42,0xc6,0x9f,0x33,0x5c,
		0x5c,0x2c,0xd9,0xd0,0x12,0x45,0x72,0x71,0x81,0x84,0xf6,0x42,0xb5,0x1d,0xb4,0x64,0x52,0x16,0xab,0xf5,0x0a,0xc3,0x3d),
	(0xc0,0xb8,0x94,0x03,0x92,0xd8,0x84,0x5c,0x6a,0x51,0x52,0xa7,0xc5,0xdb,0xcd,0x85,0x8c,0x3f,0x67,0xb8,
		0xb8,0x58,0xb2,0xa1,0x25,0x8a,0xe4,0xe2,0x02,0x09,0xed,0x85,0x6a,0x3b,0x68,0xc9,0xa4,0x2c,0x56,0xeb,0x15,0x86,0x7b),
	(0x80,0x71,0x29,0x07,0x24,0xb1,0x09,0xb9,0xd4,0xa2,0xa4,0x4e,0x8b,0xb7,0x9b,0x0b,0x19,0x7f,0xce,0x70,
		0x71,0xb1,0x64,0x43,0x4b,0x14,0xc9,0xc5,0x05,0x12,0xda,0x0b,0xd5,0x76,0xd0,0x92,0x49,0x59,0xac,0xd6,0x2b,0x0c,0xf7))

M_14_28 = (
	(0x71,0x5c,0xcd,0xf7,0x4c,0x41,0x3d,0x9b,0xa0,0x5e,0x93,0x46,0x1b,0x6e,0x2d,0x27,0xe6,0x50,
		0xd8,0xf6,0x31,0x0c,0x17,0xdc,0xee,0x29,0xf5,0x71,0x0a,0x34,0xb7,0xa8,0x40,0x3a,0xe1,
		0xc9,0x00,0xfb,0x50,0xd3,0x64,0x27,0x9f,0xe9,0x2f,0x15,0xed,0x99,0x19,0x01),
	(0xe2,0xb8,0x9a,0xef,0x99,0x82,0x7a,0x36,0x41,0xbd,0x26,0x8d,0x36,0xdc,0x5a,0x4e,0xcc,0xa1,
		0xb0,0xed,0x63,0x18,0x2e,0xb8,0xdd,0x53,0xea,0xe3,0x14,0x68,0x6e,0x51,0x81,0x74,0xc2,
		0x93,0x01,0xf6,0xa1,0xa6,0xc9,0x4e,0x3e,0xd3,0x5f,0x2a,0xda,0x33,0x33,0x02),
	(0xc4,0x71,0x35,0xdf,0x33,0x05,0xf5,0x6c,0x82,0x7a,0x4d,0x1a,0x6d,0xb8,0xb5,0x9c,0x98,0x43,
		0x61,0xdb,0xc7,0x30,0x5c,0x70,0xbb,0xa7,0xd4,0xc7,0x29,0xd0,0xdc,0xa2,0x02,0xe9,0x84,
		0x27,0x03,0xec,0x43,0x4d,0x93,0x9d,0x7c,0xa6,0xbf,0x54,0xb4,0x67,0x66,0x04),
	(0x88,0xe3,0x6a,0xbe,0x67,0x0a,0xea,0xd9,0x04,0xf5,0x9a,0x34,0xda,0x70,0x6b,0x39,0x31,0x87,
		0xc2,0xb6,0x8f,0x61,0xb8,0xe0,0x76,0x4f,0xa9,0x8f,0x53,0xa0,0xb9,0x45,0x05,0xd2,0x09,
		0x4f,0x06,0xd8,0x87,0x9a,0x26,0x3b,0xf9,0x4c,0x7f,0xa9,0x68,0xcf,0xcc,0x08),
	(0x10,0xc7,0xd5,0x7c,0xcf,0x14,0xd4,0xb3,0x09,0xea,0x35,0x69,0xb4,0xe1,0xd6,0x72,0x62,0x0e,
		0x85,0x6d,0x1f,0xc3,0x70,0xc1,0xed,0x9e,0x52,0x1f,0xa7,0x40,0x73,0x8b,0x0a,0xa4,0x13,
		0x9e,0x0c,0xb0,0x0f,0x35,0x4d,0x76,0xf2,0x99,0xfe,0x52,0xd1,0x9e,0x99,0x11),
	(0x20,0x8e,0xab,0xf9,0x9e,0x29,0xa8,0x67,0x13,0xd4,0x6b,0xd2,0x68,0xc3,0xad,0xe5,0xc4,0x1c,
		0x0a,0xdb,0x3e,0x86,0xe1,0x82,0xdb,0x3d,0xa5,0x3e,0x4e,0x81,0xe6,0x16,0x15,0x48,0x27,
		0x3c,0x19,0x60,0x1f,0x6a,0x9a,0xec,0xe4,0x33,0xfd,0xa5,0xa2,0x3d,0x33,0x23),
	(0x40,0x1c,0x57,0xf3,0x3d,0x53,0x50,0xcf,0x26,0xa8,0xd7,0xa4,0xd1,0x86,0x5b,0xcb,0x89,0x39,
		0x14,0xb6,0x7d,0x0c,0xc3,0x05,0xb7,0x7b,0x4a,0x7d,0x9c,0x02,0xcd,0x2d,0x2a,0x90,0x4e,
		0x78,0x32,0xc0,0x3e,0xd4,0x34,0xd9,0xc9,0x67,0xfa,0x4b,0x45,0x7b,0x66,0x46),
	(0x80,0x38,0xae,0xe6,0x7b,0xa6,0xa0,0x9e,0x4d,0x50,0xaf,0x49,0xa3,0x0d,0xb7,0x96,0x13,0x73,
		0x28,0x6c,0xfb,0x18,0x86,0x0b,0x6e,0xf7,0x94,0xfa,0x38,0x05,0x9a,0x5b,0x54,0x20,0x9d,
		0xf0,0x64,0x80,0x7d,0xa8,0x69,0xb2,0x93,0xcf,0xf4,0x97,0x8a,0xf6,0xcc,0x8c))

M_14_32 = (
	(0xe9,0xad,0x1d,0x01,0x8d,0x7a,0xce,0xe3,0x9d,0xea,0x5f,0x5b,0x0b,0xc1,0x33,0x1b,0x1e,0xc4,0xeb,
		0x8d,0x56,0x0a,0x03,0xb3,0x6c,0x36,0x35,0x60,0xc7,0x66,0xdc,0x33,0x1f,0xb7,0x9a,0x24,0x75,0x5c,0xf9,
		0x64,0xdb,0x1e,0x71,0x7a,0xfd,0x91,0x36,0x72,0xfd,0xf0,0xa3,0xab,0x90,0xf2,0xf1,0x13,0x01),
	(0xd2,0x5b,0x3b,0x02,0x1a,0xf5,0x9c,0xc7,0x3b,0xd5,0xbf,0xb6,0x16,0x82,0x67,0x36,0x3c,0x88,0xd7,
		0x1b,0xad,0x14,0x06,0x66,0xd9,0x6c,0x6a,0xc0,0x8e,0xcd,0xb8,0x67,0x3e,0x6e,0x35,0x49,0xea,0xb8,0xf2,
		0xc9,0xb6,0x3d,0xe2,0xf4,0xfa,0x23,0x6d,0xe4,0xfa,0xe1,0x47,0x57,0x21,0xe5,0xe3,0x27,0x02),
	(0xa4,0xb7,0x76,0x04,0x34,0xea,0x39,0x8f,0x77,0xaa,0x7f,0x6d,0x2d,0x04,0xcf,0x6c,0x78,0x10,0xaf,
		0x37,0x5a,0x29,0x0c,0xcc,0xb2,0xd9,0xd4,0x80,0x1d,0x9b,0x71,0xcf,0x7c,0xdc,0x6a,0x92,0xd4,0x71,0xe5,
		0x93,0x6d,0x7b,0xc4,0xe9,0xf5,0x47,0xda,0xc8,0xf5,0xc3,0x8f,0xae,0x42,0xca,0xc7,0x4f,0x04),
	(0x48,0x6f,0xed,0x08,0x68,0xd4,0x73,0x1e,0xef,0x54,0xff,0xda,0x5a,0x08,0x9e,0xd9,0xf0,0x20,0x5e,
		0x6f,0xb4,0x52,0x18,0x98,0x65,0xb3,0xa9,0x01,0x3b,0x36,0xe3,0x9e,0xf9,0xb8,0xd5,0x24,0xa9,0xe3,0xca,
		0x27,0xdb,0xf6,0x88,0xd3,0xeb,0x8f,0xb4,0x91,0xeb,0x87,0x1f,0x5d,0x85,0x94,0x8f,0x9f,0x08),
	(0x90,0xde,0xda,0x11,0xd0,0xa8,0xe7,0x3c,0xde,0xa9,0xfe,0xb5,0xb5,0x10,0x3c,0xb3,0xe1,0x41,0xbc,
		0xde,0x68,0xa5,0x30,0x30,0xcb,0x66,0x53,0x03,0x76,0x6c,0xc6,0x3d,0xf3,0x71,0xab,0x49,0x52,0xc7,0x95,
		0x4f,0xb6,0xed,0x11,0xa7,0xd7,0x1f,0x69,0x23,0xd7,0x0f,0x3f,0xba,0x0a,0x29,0x1f,0x3f,0x11),
	(0x20,0xbd,0xb5,0x23,0xa0,0x51,0xcf,0x79,0xbc,0x53,0xfd,0x6b,0x6b,0x21,0x78,0x66,0xc3,0x83,0x78,
		0xbd,0xd1,0x4a,0x61,0x60,0x96,0xcd,0xa6,0x06,0xec,0xd8,0x8c,0x7b,0xe6,0xe3,0x56,0x93,0xa4,0x8e,0x2b,
		0x9f,0x6c,0xdb,0x23,0x4e,0xaf,0x3f,0xd2,0x46,0xae,0x1f,0x7e,0x74,0x15,0x52,0x3e,0x7e,0x22),
	(0x40,0x7a,0x6b,0x47,0x40,0xa3,0x9e,0xf3,0x78,0xa7,0xfa,0xd7,0xd6,0x42,0xf0,0xcc,0x86,0x07,0xf1,
		0x7a,0xa3,0x95,0xc2,0xc0,0x2c,0x9b,0x4d,0x0d,0xd8,0xb1,0x19,0xf7,0xcc,0xc7,0xad,0x26,0x49,0x1d,0x57,
		0x3e,0xd9,0xb6,0x47,0x9c,0x5e,0x7f,0xa4,0x8d,0x5c,0x3f,0xfc,0xe8,0x2a,0xa4,0x7c,0xfc,0x44),
	(0x80,0xf4,0xd6,0x8e,0x80,0x46,0x3d,0xe7,0xf1,0x4e,0xf5,0xaf,0xad,0x85,0xe0,0x99,0x0d,0x0f,0xe2,
		0xf5,0x46,0x2b,0x85,0x81,0x59,0x36,0x9b,0x1a,0xb0,0x63,0x33,0xee,0x99,0x8f,0x5b,0x4d,0x92,0x3a,0xae,
		0x7c,0xb2,0x6d,0x8f,0x38,0xbd,0xfe,0x48,0x1b,0xb9,0x7e,0xf8,0xd1,0x55,0x48,0xf9,0xf8,0x89))

M_14_36 = (
	(0x0b,0x60,0xbf,0x81,0x57,0x76,0xb3,0x6c,0xaa,0xd3,0xb7,0xc1,0x3b,0xf7,0x8f,0x6c,0xef,0x2a,0x35,0x63,
		0x0c,0xad,0xc0,0xdb,0x40,0x49,0x27,0x9c,0x40,0x1f,0xfc,0x83,0xe4,0x85,0x3f,0x75,0x0b,0x7f,0x60,0x3c,0x73,
		0xcd,0x64,0x3c,0x0d,0xd9,0xf2,0x17,0xf0,0x3e,0x1c,0xe4,0x3c,0xe4,0xa1,0x9e,0xba,0x51,0xd5,0xfd,0x09,0x56,0x6c,0x01),
	(0x16,0xc0,0x7e,0x03,0xaf,0xec,0x66,0xd9,0x54,0xa7,0x6f,0x83,0x77,0xee,0x1f,0xd9,0xde,0x55,0x6a,0xc6,
		0x18,0x5a,0x81,0xb7,0x81,0x92,0x4e,0x38,0x81,0x3e,0xf8,0x07,0xc9,0x0b,0x7f,0xea,0x16,0xfe,0xc0,0x78,0xe6,
		0x9a,0xc9,0x78,0x1a,0xb2,0xe5,0x2f,0xe0,0x7d,0x38,0xc8,0x79,0xc8,0x43,0x3d,0x75,0xa3,0xaa,0xfb,0x13,0xac,0xd8,0x02),
	(0x2c,0x80,0xfd,0x06,0x5e,0xd9,0xcd,0xb2,0xa9,0x4e,0xdf,0x06,0xef,0xdc,0x3f,0xb2,0xbd,0xab,0xd4,0x8c,
		0x31,0xb4,0x02,0x6f,0x03,0x25,0x9d,0x70,0x02,0x7d,0xf0,0x0f,0x92,0x17,0xfe,0xd4,0x2d,0xfc,0x81,0xf1,0xcc,
		0x35,0x93,0xf1,0x34,0x64,0xcb,0x5f,0xc0,0xfb,0x70,0x90,0xf3,0x90,0x87,0x7a,0xea,0x46,0x55,0xf7,0x27,0x58,0xb1,0x05),
	(0x58,0x00,0xfb,0x0d,0xbc,0xb2,0x9b,0x65,0x53,0x9d,0xbe,0x0d,0xde,0xb9,0x7f,0x64,0x7b,0x57,0xa9,0x19,
		0x63,0x68,0x05,0xde,0x06,0x4a,0x3a,0xe1,0x04,0xfa,0xe0,0x1f,0x24,0x2f,0xfc,0xa9,0x5b,0xf8,0x03,0xe3,0x99,
		0x6b,0x26,0xe3,0x69,0xc8,0x96,0xbf,0x80,0xf7,0xe1,0x20,0xe7,0x21,0x0f,0xf5,0xd4,0x8d,0xaa,0xee,0x4f,0xb0,0x62,0x0b),
	(0xb0,0x00,0xf6,0x1b,0x78,0x65,0x37,0xcb,0xa6,0x3a,0x7d,0x1b,0xbc,0x73,0xff,0xc8,0xf6,0xae,0x52,0x33,
		0xc6,0xd0,0x0a,0xbc,0x0d,0x94,0x74,0xc2,0x09,0xf4,0xc1,0x3f,0x48,0x5e,0xf8,0x53,0xb7,0xf0,0x07,0xc6,0x33,
		0xd7,0x4c,0xc6,0xd3,0x90,0x2d,0x7f,0x01,0xef,0xc3,0x41,0xce,0x43,0x1e,0xea,0xa9,0x1b,0x55,0xdd,0x9f,0x60,0xc5,0x16),
	(0x60,0x01,0xec,0x37,0xf0,0xca,0x6e,0x96,0x4d,0x75,0xfa,0x36,0x78,0xe7,0xfe,0x91,0xed,0x5d,0xa5,0x66,
		0x8c,0xa1,0x15,0x78,0x1b,0x28,0xe9,0x84,0x13,0xe8,0x83,0x7f,0x90,0xbc,0xf0,0xa7,0x6e,0xe1,0x0f,0x8c,0x67,
		0xae,0x99,0x8c,0xa7,0x21,0x5b,0xfe,0x02,0xde,0x87,0x83,0x9c,0x87,0x3c,0xd4,0x53,0x37,0xaa,0xba,0x3f,0xc1,0x8a,0x2d),
	(0xc0,0x02,0xd8,0x6f,0xe0,0x95,0xdd,0x2c,0x9b,0xea,0xf4,0x6d,0xf0,0xce,0xfd,0x23,0xdb,0xbb,0x4a,0xcd,
		0x18,0x43,0x2b,0xf0,0x36,0x50,0xd2,0x09,0x27,0xd0,0x07,0xff,0x20,0x79,0xe1,0x4f,0xdd,0xc2,0x1f,0x18,0xcf,
		0x5c,0x33,0x19,0x4f,0x43,0xb6,0xfc,0x05,0xbc,0x0f,0x07,0x39,0x0f,0x79,0xa8,0xa7,0x6e,0x54,0x75,0x7f,0x82,0x15,0x5b),
	(0x80,0x05,0xb0,0xdf,0xc0,0x2b,0xbb,0x59,0x36,0xd5,0xe9,0xdb,0xe0,0x9d,0xfb,0x47,0xb6,0x77,0x95,0x9a,
		0x31,0x86,0x56,0xe0,0x6d,0xa0,0xa4,0x13,0x4e,0xa0,0x0f,0xfe,0x41,0xf2,0xc2,0x9f,0xba,0x85,0x3f,0x30,0x9e,
		0xb9,0x66,0x32,0x9e,0x86,0x6c,0xf9,0x0b,0x78,0x1f,0x0e,0x72,0x1e,0xf2,0x50,0x4f,0xdd,0xa8,0xea,0xfe,0x04,0x2b,0xb6))

M_14_40 = (
	(0x07,0xfc,0x23,0x1b,0x0b,0x76,0x74,0xd3,0x0c,0xf3,0x99,0x16,0x24,0xcd,0x55,0xde,0xf6,0x72,0xe5,0x93,
		0x5f,0xc9,0xef,0x51,0xee,0x1b,0x7e,0x95,0x33,0x51,0x2b,0x68,0x66,0x93,0x54,0x29,0x02,0x18,0xc4,0x7d,
		0xef,0xf8,0x99,0xa3,0x34,0x6f,0xf4,0x8b,0x10,0xea,0x8f,0xee,0xf7,0xeb,0x96,0x44,0xf6,0x19,0x65,0x4b,
		0xc1,0x8d,0xda,0x49,0x0a,0x80,0x72,0xee,0x69,0x07,0x01),
	(0x0e,0xf8,0x47,0x36,0x16,0xec,0xe8,0xa6,0x19,0xe6,0x33,0x2d,0x48,0x9a,0xab,0xbc,0xed,0xe5,0xca,0x27,
		0xbf,0x92,0xdf,0xa3,0xdc,0x37,0xfc,0x2a,0x67,0xa2,0x56,0xd0,0xcc,0x26,0xa9,0x52,0x04,0x30,0x88,0xfb,
		0xde,0xf1,0x33,0x47,0x69,0xde,0xe8,0x17,0x21,0xd4,0x1f,0xdd,0xef,0xd7,0x2d,0x89,0xec,0x33,0xca,0x96,
		0x82,0x1b,0xb5,0x93,0x14,0x00,0xe5,0xdc,0xd3,0x0e,0x02),
	(0x1c,0xf0,0x8f,0x6c,0x2c,0xd8,0xd1,0x4d,0x33,0xcc,0x67,0x5a,0x90,0x34,0x57,0x79,0xdb,0xcb,0x95,0x4f,
		0x7e,0x25,0xbf,0x47,0xb9,0x6f,0xf8,0x55,0xce,0x44,0xad,0xa0,0x99,0x4d,0x52,0xa5,0x08,0x60,0x10,0xf7,
		0xbd,0xe3,0x67,0x8e,0xd2,0xbc,0xd1,0x2f,0x42,0xa8,0x3f,0xba,0xdf,0xaf,0x5b,0x12,0xd9,0x67,0x94,0x2d,
		0x05,0x37,0x6a,0x27,0x29,0x00,0xca,0xb9,0xa7,0x1d,0x04),
	(0x38,0xe0,0x1f,0xd9,0x58,0xb0,0xa3,0x9b,0x66,0x98,0xcf,0xb4,0x20,0x69,0xae,0xf2,0xb6,0x97,0x2b,0x9f,
		0xfc,0x4a,0x7e,0x8f,0x72,0xdf,0xf0,0xab,0x9c,0x89,0x5a,0x41,0x33,0x9b,0xa4,0x4a,0x11,0xc0,0x20,0xee,
		0x7b,0xc7,0xcf,0x1c,0xa5,0x79,0xa3,0x5f,0x84,0x50,0x7f,0x74,0xbf,0x5f,0xb7,0x24,0xb2,0xcf,0x28,0x5b,
		0x0a,0x6e,0xd4,0x4e,0x52,0x00,0x94,0x73,0x4f,0x3b,0x08),
	(0x70,0xc0,0x3f,0xb2,0xb1,0x60,0x47,0x37,0xcd,0x30,0x9f,0x69,0x41,0xd2,0x5c,0xe5,0x6d,0x2f,0x57,0x3e,
		0xf9,0x95,0xfc,0x1e,0xe5,0xbe,0xe1,0x57,0x39,0x13,0xb5,0x82,0x66,0x36,0x49,0x95,0x22,0x80,0x41,0xdc,
		0xf7,0x8e,0x9f,0x39,0x4a,0xf3,0x46,0xbf,0x08,0xa1,0xfe,0xe8,0x7e,0xbf,0x6e,0x49,0x64,0x9f,0x51,0xb6,
		0x14,0xdc,0xa8,0x9d,0xa4,0x00,0x28,0xe7,0x9e,0x76,0x10),
	(0xe0,0x80,0x7f,0x64,0x63,0xc1,0x8e,0x6e,0x9a,0x61,0x3e,0xd3,0x82,0xa4,0xb9,0xca,0xdb,0x5e,0xae,0x7c,
		0xf2,0x2b,0xf9,0x3d,0xca,0x7d,0xc3,0xaf,0x72,0x26,0x6a,0x05,0xcd,0x6c,0x92,0x2a,0x45,0x00,0x83,0xb8,
		0xef,0x1d,0x3f,0x73,0x94,0xe6,0x8d,0x7e,0x11,0x42,0xfd,0xd1,0xfd,0x7e,0xdd,0x92,0xc8,0x3e,0xa3,0x6c,
		0x29,0xb8,0x51,0x3b,0x49,0x01,0x50,0xce,0x3d,0xed,0x20),
	(0xc0,0x01,0xff,0xc8,0xc6,0x82,0x1d,0xdd,0x34,0xc3,0x7c,0xa6,0x05,0x49,0x73,0x95,0xb7,0xbd,0x5c,0xf9,
		0xe4,0x57,0xf2,0x7b,0x94,0xfb,0x86,0x5f,0xe5,0x4c,0xd4,0x0a,0x9a,0xd9,0x24,0x55,0x8a,0x00,0x06,0x71,
		0xdf,0x3b,0x7e,0xe6,0x28,0xcd,0x1b,0xfd,0x22,0x84,0xfa,0xa3,0xfb,0xfd,0xba,0x25,0x91,0x7d,0x46,0xd9,
		0x52,0x70,0xa3,0x76,0x92,0x02,0xa0,0x9c,0x7b,0xda,0x41),
	(0x80,0x03,0xfe,0x91,0x8d,0x05,0x3b,0xba,0x69,0x86,0xf9,0x4c,0x0b,0x92,0xe6,0x2a,0x6f,0x7b,0xb9,0xf2,
		0xc9,0xaf,0xe4,0xf7,0x28,0xf7,0x0d,0xbf,0xca,0x99,0xa8,0x15,0x34,0xb3,0x49,0xaa,0x14,0x01,0x0c,0xe2,
		0xbe,0x77,0xfc,0xcc,0x51,0x9a,0x37,0xfa,0x45,0x08,0xf5,0x47,0xf7,0xfb,0x75,0x4b,0x22,0xfb,0x8c,0xb2,
		0xa5,0xe0,0x46,0xed,0x24,0x05,0x40,0x39,0xf7,0xb4,0x83))

M_14_44 = (
	(0x7d,0xa2,0x90,0xd1,0x9e,0x20,0xfb,0xa2,0xfc,0xec,0x54,0xbe,0xe8,0x7c,0xc7,0xcf,0x35,0xe2,0x9e,0x88,
		0xbb,0x90,0x85,0x87,0xb0,0xce,0x13,0x68,0xe7,0xa1,0xfc,0xd7,0xe0,0x8b,0x65,0x5a,0xad,0xf2,0xfd,0x0c,
		0x14,0x48,0x8c,0xa1,0x2c,0x93,0xc1,0xac,0x2c,0x90,0x73,0x0e,0xe7,0xcb,0xf9,0x3c,0xef,0xb4,0xd8,0x6e,
		0x6e,0xed,0x5a,0x44,0xe9,0xde,0x74,0xfc,0xec,0x76,0x29,0xcb,0x9d,0x46,0x3a,0xd9,0x98,0x01),
	(0xfa,0x44,0x21,0xa3,0x3d,0x41,0xf6,0x45,0xf9,0xd9,0xa9,0x7c,0xd1,0xf9,0x8e,0x9f,0x6b,0xc4,0x3d,0x11,
		0x77,0x21,0x0b,0x0f,0x61,0x9d,0x27,0xd0,0xce,0x43,0xf9,0xaf,0xc1,0x17,0xcb,0xb4,0x5a,0xe5,0xfb,0x19,
		0x28,0x90,0x18,0x43,0x59,0x26,0x83,0x59,0x59,0x20,0xe7,0x1c,0xce,0x97,0xf3,0x79,0xde,0x69,0xb1,0xdd,
		0xdc,0xda,0xb5,0x88,0xd2,0xbd,0xe9,0xf8,0xd9,0xed,0x52,0x96,0x3b,0x8d,0x74,0xb2,0x31,0x03),
	(0xf4,0x89,0x42,0x46,0x7b,0x82,0xec,0x8b,0xf2,0xb3,0x53,0xf9,0xa2,0xf3,0x1d,0x3f,0xd7,0x88,0x7b,0x22,
		0xee,0x42,0x16,0x1e,0xc2,0x3a,0x4f,0xa0,0x9d,0x87,0xf2,0x5f,0x83,0x2f,0x96,0x69,0xb5,0xca,0xf7,0x33,
		0x50,0x20,0x31,0x86,0xb2,0x4c,0x06,0xb3,0xb2,0x40,0xce,0x39,0x9c,0x2f,0xe7,0xf3,0xbc,0xd3,0x62,0xbb,
		0xb9,0xb5,0x6b,0x11,0xa5,0x7b,0xd3,0xf1,0xb3,0xdb,0xa5,0x2c,0x77,0x1a,0xe9,0x64,0x63,0x06),
	(0xe8,0x13,0x85,0x8c,0xf6,0x04,0xd9,0x17,0xe5,0x67,0xa7,0xf2,0x45,0xe7,0x3b,0x7e,0xae,0x11,0xf7,0x44,
		0xdc,0x85,0x2c,0x3c,0x84,0x75,0x9e,0x40,0x3b,0x0f,0xe5,0xbf,0x06,0x5f,0x2c,0xd3,0x6a,0x95,0xef,0x67,
		0xa0,0x40,0x62,0x0c,0x65,0x99,0x0c,0x66,0x65,0x81,0x9c,0x73,0x38,0x5f,0xce,0xe7,0x79,0xa7,0xc5,0x76,
		0x73,0x6b,0xd7,0x22,0x4a,0xf7,0xa6,0xe3,0x67,0xb7,0x4b,0x59,0xee,0x34,0xd2,0xc9,0xc6,0x0c),
	(0xd0,0x27,0x0a,0x19,0xed,0x09,0xb2,0x2f,0xca,0xcf,0x4e,0xe5,0x8b,0xce,0x77,0xfc,0x5c,0x23,0xee,0x89,
		0xb8,0x0b,0x59,0x78,0x08,0xeb,0x3c,0x81,0x76,0x1e,0xca,0x7f,0x0d,0xbe,0x58,0xa6,0xd5,0x2a,0xdf,0xcf,
		0x40,0x81,0xc4,0x18,0xca,0x32,0x19,0xcc,0xca,0x02,0x39,0xe7,0x70,0xbe,0x9c,0xcf,0xf3,0x4e,0x8b,0xed,
		0xe6,0xd6,0xae,0x45,0x94,0xee,0x4d,0xc7,0xcf,0x6e,0x97,0xb2,0xdc,0x69,0xa4,0x93,0x8d,0x19),
	(0xa0,0x4f,0x14,0x32,0xda,0x13,0x64,0x5f,0x94,0x9f,0x9d,0xca,0x17,0x9d,0xef,0xf8,0xb9,0x46,0xdc,0x13,
		0x71,0x17,0xb2,0xf0,0x10,0xd6,0x79,0x02,0xed,0x3c,0x94,0xff,0x1a,0x7c,0xb1,0x4c,0xab,0x55,0xbe,0x9f,
		0x81,0x02,0x89,0x31,0x94,0x65,0x32,0x98,0x95,0x05,0x72,0xce,0xe1,0x7c,0x39,0x9f,0xe7,0x9d,0x16,0xdb,
		0xcd,0xad,0x5d,0x8b,0x28,0xdd,0x9b,0x8e,0x9f,0xdd,0x2e,0x65,0xb9,0xd3,0x48,0x27,0x1b,0x33),
	(0x40,0x9f,0x28,0x64,0xb4,0x27,0xc8,0xbe,0x28,0x3f,0x3b,0x95,0x2f,0x3a,0xdf,0xf1,0x73,0x8d,0xb8,0x27,
		0xe2,0x2e,0x64,0xe1,0x21,0xac,0xf3,0x04,0xda,0x79,0x28,0xff,0x35,0xf8,0x62,0x99,0x56,0xab,0x7c,0x3f,
		0x03,0x05,0x12,0x63,0x28,0xcb,0x64,0x30,0x2b,0x0b,0xe4,0x9c,0xc3,0xf9,0x72,0x3e,0xcf,0x3b,0x2d,0xb6,
		0x9b,0x5b,0xbb,0x16,0x51,0xba,0x37,0x1d,0x3f,0xbb,0x5d,0xca,0x72,0xa7,0x91,0x4e,0x36,0x66),
	(0x80,0x3e,0x51,0xc8,0x68,0x4f,0x90,0x7d,0x51,0x7e,0x76,0x2a,0x5f,0x74,0xbe,0xe3,0xe7,0x1a,0x71,0x4f,
		0xc4,0x5d,0xc8,0xc2,0x43,0x58,0xe7,0x09,0xb4,0xf3,0x50,0xfe,0x6b,0xf0,0xc5,0x32,0xad,0x56,0xf9,0x7e,
		0x06,0x0a,0x24,0xc6,0x50,0x96,0xc9,0x60,0x56,0x16,0xc8,0x39,0x87,0xf3,0xe5,0x7c,0x9e,0x77,0x5a,0x6c,
		0x37,0xb7,0x76,0x2d,0xa2,0x74,0x6f,0x3a,0x7e,0x76,0xbb,0x94,0xe5,0x4e,0x23,0x9d,0x6c,0xcc))

M_14_48 = (
	(0x35,0x47,0xc2,0xf2,0xec,0xd9,0xb1,0x4c,0x34,0xd1,0x12,0x79,0x34,0xab,0x17,0x76,0x39,0x6a,0x37,0x7b,0x4d,
		0xfe,0xb6,0x97,0xee,0xe9,0x71,0x1d,0xf6,0x99,0xf7,0x8e,0x9a,0x1f,0x05,0x13,0x6f,0xcc,0xb9,0xce,0xcf,0x60,
		0xb9,0x66,0x35,0xa2,0xfc,0x8e,0x9a,0x40,0xdc,0x24,0xf6,0x6b,0xd9,0x96,0xfa,0xa1,0xfb,0x5f,0xc1,0xc2,0x6a,
		0x84,0x88,0x13,0x48,0x43,0xcb,0xcb,0x77,0x63,0xc1,0xfa,0xf9,0x16,0xd4,0x69,0xd8,0x98,0x96,0x38,0x8f,0xae,0x01),
	(0x6a,0x8e,0x84,0xe5,0xd9,0xb3,0x63,0x99,0x68,0xa2,0x25,0xf2,0x68,0x56,0x2f,0xec,0x72,0xd4,0x6e,0xf6,0x9a,
		0xfc,0x6d,0x2f,0xdd,0xd3,0xe3,0x3a,0xec,0x33,0xef,0x1d,0x35,0x3f,0x0a,0x26,0xde,0x98,0x73,0x9d,0x9f,0xc1,
		0x72,0xcd,0x6a,0x44,0xf9,0x1d,0x35,0x81,0xb8,0x49,0xec,0xd7,0xb2,0x2d,0xf5,0x43,0xf7,0xbf,0x82,0x85,0xd5,
		0x08,0x11,0x27,0x90,0x86,0x96,0x97,0xef,0xc6,0x82,0xf5,0xf3,0x2d,0xa8,0xd3,0xb0,0x31,0x2d,0x71,0x1e,0x5d,0x03),
	(0xd4,0x1c,0x09,0xcb,0xb3,0x67,0xc7,0x32,0xd1,0x44,0x4b,0xe4,0xd1,0xac,0x5e,0xd8,0xe5,0xa8,0xdd,0xec,0x35,
		0xf9,0xdb,0x5e,0xba,0xa7,0xc7,0x75,0xd8,0x67,0xde,0x3b,0x6a,0x7e,0x14,0x4c,0xbc,0x31,0xe7,0x3a,0x3f,0x83,
		0xe5,0x9a,0xd5,0x88,0xf2,0x3b,0x6a,0x02,0x71,0x93,0xd8,0xaf,0x65,0x5b,0xea,0x87,0xee,0x7f,0x05,0x0b,0xab,
		0x11,0x22,0x4e,0x20,0x0d,0x2d,0x2f,0xdf,0x8d,0x05,0xeb,0xe7,0x5b,0x50,0xa7,0x61,0x63,0x5a,0xe2,0x3c,0xba,0x06),
	(0xa8,0x39,0x12,0x96,0x67,0xcf,0x8e,0x65,0xa2,0x89,0x96,0xc8,0xa3,0x59,0xbd,0xb0,0xcb,0x51,0xbb,0xd9,0x6b,
		0xf2,0xb7,0xbd,0x74,0x4f,0x8f,0xeb,0xb0,0xcf,0xbc,0x77,0xd4,0xfc,0x28,0x98,0x78,0x63,0xce,0x75,0x7e,0x06,
		0xcb,0x35,0xab,0x11,0xe5,0x77,0xd4,0x04,0xe2,0x26,0xb1,0x5f,0xcb,0xb6,0xd4,0x0f,0xdd,0xff,0x0a,0x16,0x56,
		0x23,0x44,0x9c,0x40,0x1a,0x5a,0x5e,0xbe,0x1b,0x0b,0xd6,0xcf,0xb7,0xa0,0x4e,0xc3,0xc6,0xb4,0xc4,0x79,0x74,0x0d),
	(0x50,0x73,0x24,0x2c,0xcf,0x9e,0x1d,0xcb,0x44,0x13,0x2d,0x91,0x47,0xb3,0x7a,0x61,0x97,0xa3,0x76,0xb3,0xd7,
		0xe4,0x6f,0x7b,0xe9,0x9e,0x1e,0xd7,0x61,0x9f,0x79,0xef,0xa8,0xf9,0x51,0x30,0xf1,0xc6,0x9c,0xeb,0xfc,0x0c,
		0x96,0x6b,0x56,0x23,0xca,0xef,0xa8,0x09,0xc4,0x4d,0x62,0xbf,0x96,0x6d,0xa9,0x1f,0xba,0xff,0x15,0x2c,0xac,
		0x46,0x88,0x38,0x81,0x34,0xb4,0xbc,0x7c,0x37,0x16,0xac,0x9f,0x6f,0x41,0x9d,0x86,0x8d,0x69,0x89,0xf3,0xe8,0x1a),
	(0xa0,0xe6,0x48,0x58,0x9e,0x3d,0x3b,0x96,0x89,0x26,0x5a,0x22,0x8f,0x66,0xf5,0xc2,0x2e,0x47,0xed,0x66,0xaf,
		0xc9,0xdf,0xf6,0xd2,0x3d,0x3d,0xae,0xc3,0x3e,0xf3,0xde,0x51,0xf3,0xa3,0x60,0xe2,0x8d,0x39,0xd7,0xf9,0x19,
		0x2c,0xd7,0xac,0x46,0x94,0xdf,0x51,0x13,0x88,0x9b,0xc4,0x7e,0x2d,0xdb,0x52,0x3f,0x74,0xff,0x2b,0x58,0x58,
		0x8d,0x10,0x71,0x02,0x69,0x68,0x79,0xf9,0x6e,0x2c,0x58,0x3f,0xdf,0x82,0x3a,0x0d,0x1b,0xd3,0x12,0xe7,0xd1,0x35),
	(0x40,0xcd,0x91,0xb0,0x3c,0x7b,0x76,0x2c,0x13,0x4d,0xb4,0x44,0x1e,0xcd,0xea,0x85,0x5d,0x8e,0xda,0xcd,0x5e,
		0x93,0xbf,0xed,0xa5,0x7b,0x7a,0x5c,0x87,0x7d,0xe6,0xbd,0xa3,0xe6,0x47,0xc1,0xc4,0x1b,0x73,0xae,0xf3,0x33,
		0x58,0xae,0x59,0x8d,0x28,0xbf,0xa3,0x26,0x10,0x37,0x89,0xfd,0x5a,0xb6,0xa5,0x7e,0xe8,0xfe,0x57,0xb0,0xb0,
		0x1a,0x21,0xe2,0x04,0xd2,0xd0,0xf2,0xf2,0xdd,0x58,0xb0,0x7e,0xbe,0x05,0x75,0x1a,0x36,0xa6,0x25,0xce,0xa3,0x6b),
	(0x80,0x9a,0x23,0x61,0x79,0xf6,0xec,0x58,0x26,0x9a,0x68,0x89,0x3c,0x9a,0xd5,0x0b,0xbb,0x1c,0xb5,0x9b,0xbd,
		0x26,0x7f,0xdb,0x4b,0xf7,0xf4,0xb8,0x0e,0xfb,0xcc,0x7b,0x47,0xcd,0x8f,0x82,0x89,0x37,0xe6,0x5c,0xe7,0x67,
		0xb0,0x5c,0xb3,0x1a,0x51,0x7e,0x47,0x4d,0x20,0x6e,0x12,0xfb,0xb5,0x6c,0x4b,0xfd,0xd0,0xfd,0xaf,0x60,0x61,
		0x35,0x42,0xc4,0x09,0xa4,0xa1,0xe5,0xe5,0xbb,0xb1,0x60,0xfd,0x7c,0x0b,0xea,0x34,0x6c,0x4c,0x4b,0x9c,0x47,0xd7))

M_14_52 = (
	(0x59,0x1e,0x2c,0xdc,0xd7,0x83,0xf5,0xe2,0x0b,0x8f,0x38,0xb3,0x18,0xaf,0x4d,0xc3,0xec,0x44,0x65,0xad,0xbf,
		0x7a,0xd7,0xd9,0x60,0x25,0x18,0x74,0xa4,0x00,0x48,0xce,0x0d,0xb8,0x77,0x76,0x2a,0x13,0xe3,0x63,0x93,0xd3,
		0xa4,0x17,0x9b,0x05,0x74,0x05,0x3d,0xad,0xa6,0xe6,0xcc,0x03,0xdf,0x2e,0xce,0xf5,0x32,0xd8,0x6f,0x76,0x16,
		0x4f,0x9c,0xbf,0x61,0x7e,0x04,0x1f,0x57,0xf6,0x68,0x01,0xff,0x7c,0x10,0xb1,0x7a,0x5e,0xb5,0xdd,0xae,0xef,
		0xe3,0xf7,0xa7,0x23,0xda,0xec,0xbd,0x01),
	(0xb2,0x3c,0x58,0xb8,0xaf,0x07,0xeb,0xc5,0x17,0x1e,0x71,0x66,0x31,0x5e,0x9b,0x86,0xd9,0x89,0xca,0x5a,0x7f,
		0xf5,0xae,0xb3,0xc1,0x4a,0x30,0xe8,0x48,0x01,0x90,0x9c,0x1b,0x70,0xef,0xec,0x54,0x26,0xc6,0xc7,0x26,0xa7,
		0x49,0x2f,0x36,0x0b,0xe8,0x0a,0x7a,0x5a,0x4d,0xcd,0x99,0x07,0xbe,0x5d,0x9c,0xeb,0x65,0xb0,0xdf,0xec,0x2c,
		0x9e,0x38,0x7f,0xc3,0xfc,0x08,0x3e,0xae,0xec,0xd1,0x02,0xfe,0xf9,0x20,0x62,0xf5,0xbc,0x6a,0xbb,0x5d,0xdf,
		0xc7,0xef,0x4f,0x47,0xb4,0xd9,0x7b,0x03),
	(0x64,0x79,0xb0,0x70,0x5f,0x0f,0xd6,0x8b,0x2f,0x3c,0xe2,0xcc,0x62,0xbc,0x36,0x0d,0xb3,0x13,0x95,0xb5,0xfe,
		0xea,0x5d,0x67,0x83,0x95,0x60,0xd0,0x91,0x02,0x20,0x39,0x37,0xe0,0xde,0xd9,0xa9,0x4c,0x8c,0x8f,0x4d,0x4e,
		0x93,0x5e,0x6c,0x16,0xd0,0x15,0xf4,0xb4,0x9a,0x9a,0x33,0x0f,0x7c,0xbb,0x38,0xd7,0xcb,0x60,0xbf,0xd9,0x59,
		0x3c,0x71,0xfe,0x86,0xf9,0x11,0x7c,0x5c,0xd9,0xa3,0x05,0xfc,0xf3,0x41,0xc4,0xea,0x79,0xd5,0x76,0xbb,0xbe,
		0x8f,0xdf,0x9f,0x8e,0x68,0xb3,0xf7,0x06),
	(0xc8,0xf2,0x60,0xe1,0xbe,0x1e,0xac,0x17,0x5f,0x78,0xc4,0x99,0xc5,0x78,0x6d,0x1a,0x66,0x27,0x2a,0x6b,0xfd,
		0xd5,0xbb,0xce,0x06,0x2b,0xc1,0xa0,0x23,0x05,0x40,0x72,0x6e,0xc0,0xbd,0xb3,0x53,0x99,0x18,0x1f,0x9b,0x9c,
		0x26,0xbd,0xd8,0x2c,0xa0,0x2b,0xe8,0x69,0x35,0x35,0x67,0x1e,0xf8,0x76,0x71,0xae,0x97,0xc1,0x7e,0xb3,0xb3,
		0x78,0xe2,0xfc,0x0d,0xf3,0x23,0xf8,0xb8,0xb2,0x47,0x0b,0xf8,0xe7,0x83,0x88,0xd5,0xf3,0xaa,0xed,0x76,0x7d,
		0x1f,0xbf,0x3f,0x1d,0xd1,0x66,0xef,0x0d),
	(0x90,0xe5,0xc1,0xc2,0x7d,0x3d,0x58,0x2f,0xbe,0xf0,0x88,0x33,0x8b,0xf1,0xda,0x34,0xcc,0x4e,0x54,0xd6,0xfa,
		0xab,0x77,0x9d,0x0d,0x56,0x82,0x41,0x47,0x0a,0x80,0xe4,0xdc,0x80,0x7b,0x67,0xa7,0x32,0x31,0x3e,0x36,0x39,
		0x4d,0x7a,0xb1,0x59,0x40,0x57,0xd0,0xd3,0x6a,0x6a,0xce,0x3c,0xf0,0xed,0xe2,0x5c,0x2f,0x83,0xfd,0x66,0x67,
		0xf1,0xc4,0xf9,0x1b,0xe6,0x47,0xf0,0x71,0x65,0x8f,0x16,0xf0,0xcf,0x07,0x11,0xab,0xe7,0x55,0xdb,0xed,0xfa,
		0x3e,0x7e,0x7f,0x3a,0xa2,0xcd,0xde,0x1b),
	(0x20,0xcb,0x83,0x85,0xfb,0x7a,0xb0,0x5e,0x7c,0xe1,0x11,0x67,0x16,0xe3,0xb5,0x69,0x98,0x9d,0xa8,0xac,0xf5,
		0x57,0xef,0x3a,0x1b,0xac,0x04,0x83,0x8e,0x14,0x00,0xc9,0xb9,0x01,0xf7,0xce,0x4e,0x65,0x62,0x7c,0x6c,0x72,
		0x9a,0xf4,0x62,0xb3,0x80,0xae,0xa0,0xa7,0xd5,0xd4,0x9c,0x79,0xe0,0xdb,0xc5,0xb9,0x5e,0x06,0xfb,0xcd,0xce,
		0xe2,0x89,0xf3,0x37,0xcc,0x8f,0xe0,0xe3,0xca,0x1e,0x2d,0xe0,0x9f,0x0f,0x22,0x56,0xcf,0xab,0xb6,0xdb,0xf5,
		0x7d,0xfc,0xfe,0x74,0x44,0x9b,0xbd,0x37),
	(0x40,0x96,0x07,0x0b,0xf7,0xf5,0x60,0xbd,0xf8,0xc2,0x23,0xce,0x2c,0xc6,0x6b,0xd3,0x30,0x3b,0x51,0x59,0xeb,
		0xaf,0xde,0x75,0x36,0x58,0x09,0x06,0x1d,0x29,0x00,0x92,0x73,0x03,0xee,0x9d,0x9d,0xca,0xc4,0xf8,0xd8,0xe4,
		0x34,0xe9,0xc5,0x66,0x01,0x5d,0x41,0x4f,0xab,0xa9,0x39,0xf3,0xc0,0xb7,0x8b,0x73,0xbd,0x0c,0xf6,0x9b,0x9d,
		0xc5,0x13,0xe7,0x6f,0x98,0x1f,0xc1,0xc7,0x95,0x3d,0x5a,0xc0,0x3f,0x1f,0x44,0xac,0x9e,0x57,0x6d,0xb7,0xeb,
		0xfb,0xf8,0xfd,0xe9,0x88,0x36,0x7b,0x6f),
	(0x80,0x2c,0x0f,0x16,0xee,0xeb,0xc1,0x7a,0xf1,0x85,0x47,0x9c,0x59,0x8c,0xd7,0xa6,0x61,0x76,0xa2,0xb2,0xd6,
		0x5f,0xbd,0xeb,0x6c,0xb0,0x12,0x0c,0x3a,0x52,0x00,0x24,0xe7,0x06,0xdc,0x3b,0x3b,0x95,0x89,0xf1,0xb1,0xc9,
		0x69,0xd2,0x8b,0xcd,0x02,0xba,0x82,0x9e,0x56,0x53,0x73,0xe6,0x81,0x6f,0x17,0xe7,0x7a,0x19,0xec,0x37,0x3b,
		0x8b,0x27,0xce,0xdf,0x30,0x3f,0x82,0x8f,0x2b,0x7b,0xb4,0x80,0x7f,0x3e,0x88,0x58,0x3d,0xaf,0xda,0x6e,0xd7,
		0xf7,0xf1,0xfb,0xd3,0x11,0x6d,0xf6,0xde))

M_14_56 = (
	(0x09,0x0c,0xd9,0xd0,0xcb,0xbe,0x78,0x3e,0x36,0xc1,0x98,0xbd,0x12,0x71,0x0c,0x3f,0x74,0x83,0x2f,0x15,0x56,
		0xbf,0xd7,0xb9,0x1d,0x07,0x43,0xe8,0x19,0x60,0x3e,0xe4,0x9c,0x9e,0xfd,0xad,0x6e,0x9e,0xda,0x69,0xc9,0x52,
		0x2d,0xf5,0xe3,0x8e,0xe4,0x45,0x4a,0x34,0x7b,0x2d,0xce,0x27,0x8d,0x97,0x4a,0xa9,0xfc,0xd0,0xe0,0x99,0x90,
		0xb0,0x8e,0x7a,0xcf,0x2a,0xa1,0x9c,0xcb,0x1f,0x96,0x32,0xa3,0x19,0xd8,0x42,0x67,0x08,0x6e,0xf3,0xb0,0xd1,
		0x38,0xf3,0x05,0x88,0x34,0x5a,0x46,0x68,0x83,0x7d,0xa2,0xf9,0xf7,0x1d,0x01),
	(0x12,0x18,0xb2,0xa1,0x97,0x7d,0xf1,0x7c,0x6c,0x82,0x31,0x7b,0x25,0xe2,0x18,0x7e,0xe8,0x06,0x5f,0x2a,0xac,
		0x7e,0xaf,0x73,0x3b,0x0e,0x86,0xd0,0x33,0xc0,0x7c,0xc8,0x39,0x3d,0xfb,0x5b,0xdd,0x3c,0xb5,0xd3,0x92,0xa5,
		0x5a,0xea,0xc7,0x1d,0xc9,0x8b,0x94,0x68,0xf6,0x5a,0x9c,0x4f,0x1a,0x2f,0x95,0x52,0xf9,0xa1,0xc1,0x33,0x21,
		0x61,0x1d,0xf5,0x9e,0x55,0x42,0x39,0x97,0x3f,0x2c,0x65,0x46,0x33,0xb0,0x85,0xce,0x10,0xdc,0xe6,0x61,0xa3,
		0x71,0xe6,0x0b,0x10,0x69,0xb4,0x8c,0xd0,0x06,0xfb,0x44,0xf3,0xef,0x3b,0x02),
	(0x24,0x30,0x64,0x43,0x2f,0xfb,0xe2,0xf9,0xd8,0x04,0x63,0xf6,0x4a,0xc4,0x31,0xfc,0xd0,0x0d,0xbe,0x54,0x58,
		0xfd,0x5e,0xe7,0x76,0x1c,0x0c,0xa1,0x67,0x80,0xf9,0x90,0x73,0x7a,0xf6,0xb7,0xba,0x79,0x6a,0xa7,0x25,0x4b,
		0xb5,0xd4,0x8f,0x3b,0x92,0x17,0x29,0xd1,0xec,0xb5,0x38,0x9f,0x34,0x5e,0x2a,0xa5,0xf2,0x43,0x83,0x67,0x42,
		0xc2,0x3a,0xea,0x3d,0xab,0x84,0x72,0x2e,0x7f,0x58,0xca,0x8c,0x66,0x60,0x0b,0x9d,0x21,0xb8,0xcd,0xc3,0x46,
		0xe3,0xcc,0x17,0x20,0xd2,0x68,0x19,0xa1,0x0d,0xf6,0x89,0xe6,0xdf,0x77,0x04),
	(0x48,0x60,0xc8,0x86,0x5e,0xf6,0xc5,0xf3,0xb1,0x09,0xc6,0xec,0x95,0x88,0x63,0xf8,0xa1,0x1b,0x7c,0xa9,0xb0,
		0xfa,0xbd,0xce,0xed,0x38,0x18,0x42,0xcf,0x00,0xf3,0x21,0xe7,0xf4,0xec,0x6f,0x75,0xf3,0xd4,0x4e,0x4b,0x96,
		0x6a,0xa9,0x1f,0x77,0x24,0x2f,0x52,0xa2,0xd9,0x6b,0x71,0x3e,0x69,0xbc,0x54,0x4a,0xe5,0x87,0x06,0xcf,0x84,
		0x84,0x75,0xd4,0x7b,0x56,0x09,0xe5,0x5c,0xfe,0xb0,0x94,0x19,0xcd,0xc0,0x16,0x3a,0x43,0x70,0x9b,0x87,0x8d,
		0xc6,0x99,0x2f,0x40,0xa4,0xd1,0x32,0x42,0x1b,0xec,0x13,0xcd,0xbf,0xef,0x08),
	(0x90,0xc0,0x90,0x0d,0xbd,0xec,0x8b,0xe7,0x63,0x13,0x8c,0xd9,0x2b,0x11,0xc7,0xf0,0x43,0x37,0xf8,0x52,0x61,
		0xf5,0x7b,0x9d,0xdb,0x71,0x30,0x84,0x9e,0x01,0xe6,0x43,0xce,0xe9,0xd9,0xdf,0xea,0xe6,0xa9,0x9d,0x96,0x2c,
		0xd5,0x52,0x3f,0xee,0x48,0x5e,0xa4,0x44,0xb3,0xd7,0xe2,0x7c,0xd2,0x78,0xa9,0x94,0xca,0x0f,0x0d,0x9e,0x09,
		0x09,0xeb,0xa8,0xf7,0xac,0x12,0xca,0xb9,0xfc,0x61,0x29,0x33,0x9a,0x81,0x2d,0x74,0x86,0xe0,0x36,0x0f,0x1b,
		0x8d,0x33,0x5f,0x80,0x48,0xa3,0x65,0x84,0x36,0xd8,0x27,0x9a,0x7f,0xdf,0x11),
	(0x20,0x81,0x21,0x1b,0x7a,0xd9,0x17,0xcf,0xc7,0x26,0x18,0xb3,0x57,0x22,0x8e,0xe1,0x87,0x6e,0xf0,0xa5,0xc2,
		0xea,0xf7,0x3a,0xb7,0xe3,0x60,0x08,0x3d,0x03,0xcc,0x87,0x9c,0xd3,0xb3,0xbf,0xd5,0xcd,0x53,0x3b,0x2d,0x59,
		0xaa,0xa5,0x7e,0xdc,0x91,0xbc,0x48,0x89,0x66,0xaf,0xc5,0xf9,0xa4,0xf1,0x52,0x29,0x95,0x1f,0x1a,0x3c,0x13,
		0x12,0xd6,0x51,0xef,0x59,0x25,0x94,0x73,0xf9,0xc3,0x52,0x66,0x34,0x03,0x5b,0xe8,0x0c,0xc1,0x6d,0x1e,0x36,
		0x1a,0x67,0xbe,0x00,0x91,0x46,0xcb,0x08,0x6d,0xb0,0x4f,0x34,0xff,0xbe,0x23),
	(0x40,0x02,0x43,0x36,0xf4,0xb2,0x2f,0x9e,0x8f,0x4d,0x30,0x66,0xaf,0x44,0x1c,0xc3,0x0f,0xdd,0xe0,0x4b,0x85,
		0xd5,0xef,0x75,0x6e,0xc7,0xc1,0x10,0x7a,0x06,0x98,0x0f,0x39,0xa7,0x67,0x7f,0xab,0x9b,0xa7,0x76,0x5a,0xb2,
		0x54,0x4b,0xfd,0xb8,0x23,0x79,0x91,0x12,0xcd,0x5e,0x8b,0xf3,0x49,0xe3,0xa5,0x52,0x2a,0x3f,0x34,0x78,0x26,
		0x24,0xac,0xa3,0xde,0xb3,0x4a,0x28,0xe7,0xf2,0x87,0xa5,0xcc,0x68,0x06,0xb6,0xd0,0x19,0x82,0xdb,0x3c,0x6c,
		0x34,0xce,0x7c,0x01,0x22,0x8d,0x96,0x11,0xda,0x60,0x9f,0x68,0xfe,0x7d,0x47),
	(0x80,0x04,0x86,0x6c,0xe8,0x65,0x5f,0x3c,0x1f,0x9b,0x60,0xcc,0x5e,0x89,0x38,0x86,0x1f,0xba,0xc1,0x97,0x0a,
		0xab,0xdf,0xeb,0xdc,0x8e,0x83,0x21,0xf4,0x0c,0x30,0x1f,0x72,0x4e,0xcf,0xfe,0x56,0x37,0x4f,0xed,0xb4,0x64,
		0xa9,0x96,0xfa,0x71,0x47,0xf2,0x22,0x25,0x9a,0xbd,0x16,0xe7,0x93,0xc6,0x4b,0xa5,0x54,0x7e,0x68,0xf0,0x4c,
		0x48,0x58,0x47,0xbd,0x67,0x95,0x50,0xce,0xe5,0x0f,0x4b,0x99,0xd1,0x0c,0x6c,0xa1,0x33,0x04,0xb7,0x79,0xd8,
		0x68,0x9c,0xf9,0x02,0x44,0x1a,0x2d,0x23,0xb4,0xc1,0x3e,0xd1,0xfc,0xfb,0x8e))

M_14_60 = (
	(0xb3,0xf4,0x1b,0x06,0x78,0x68,0xf9,0xe5,0xe9,0x1f,0xc1,0xce,0x37,0x6f,0x39,0xbd,0x28,0xc4,0xd3,0x49,0xd6,
		0x9f,0x34,0x0b,0x67,0xb7,0x6d,0x3c,0xb6,0x8c,0xcc,0xa2,0xfd,0x37,0x17,0xd9,0x85,0x02,0x1e,0x86,0x7d,0xc0,
		0xcc,0x64,0x92,0xc2,0x66,0x9a,0x36,0x77,0xb1,0xa8,0xa5,0xb9,0x47,0x22,0x75,0xde,0x09,0xe9,0x63,0xd6,0xf5,
		0x1b,0xd0,0xfd,0xfb,0x8f,0x3a,0xcd,0x4c,0xac,0xaa,0xe6,0xda,0x43,0xf5,0x2d,0xd3,0x1e,0xd8,0x78,0x21,0x8d,
		0x00,0xdf,0x88,0xd5,0x7b,0xaf,0xb3,0xd6,0x1c,0x80,0x5f,0x7c,0x37,0x9d,0xd7,0xea,0x4c,0x4f,0x8b,0xa1,0xc8,0x01),
	(0x66,0xe9,0x37,0x0c,0xf0,0xd0,0xf2,0xcb,0xd3,0x3f,0x82,0x9d,0x6f,0xde,0x72,0x7a,0x51,0x88,0xa7,0x93,0xac,
		0x3f,0x69,0x16,0xce,0x6e,0xdb,0x78,0x6c,0x19,0x99,0x45,0xfb,0x6f,0x2e,0xb2,0x0b,0x05,0x3c,0x0c,0xfb,0x80,
		0x99,0xc9,0x24,0x85,0xcd,0x34,0x6d,0xee,0x62,0x51,0x4b,0x73,0x8f,0x44,0xea,0xbc,0x13,0xd2,0xc7,0xac,0xeb,
		0x37,0xa0,0xfb,0xf7,0x1f,0x75,0x9a,0x99,0x58,0x55,0xcd,0xb5,0x87,0xea,0x5b,0xa6,0x3d,0xb0,0xf1,0x42,0x1a,
		0x01,0xbe,0x11,0xab,0xf7,0x5e,0x67,0xad,0x39,0x00,0xbf,0xf8,0x6e,0x3a,0xaf,0xd5,0x99,0x9e,0x16,0x43,0x91,0x03),
	(0xcc,0xd2,0x6f,0x18,0xe0,0xa1,0xe5,0x97,0xa7,0x7f,0x04,0x3b,0xdf,0xbc,0xe5,0xf4,0xa2,0x10,0x4f,0x27,0x59,
		0x7f,0xd2,0x2c,0x9c,0xdd,0xb6,0xf1,0xd8,0x32,0x32,0x8b,0xf6,0xdf,0x5c,0x64,0x17,0x0a,0x78,0x18,0xf6,0x01,
		0x33,0x93,0x49,0x0a,0x9b,0x69,0xda,0xdc,0xc5,0xa2,0x96,0xe6,0x1e,0x89,0xd4,0x79,0x27,0xa4,0x8f,0x59,0xd7,
		0x6f,0x40,0xf7,0xef,0x3f,0xea,0x34,0x33,0xb1,0xaa,0x9a,0x6b,0x0f,0xd5,0xb7,0x4c,0x7b,0x60,0xe3,0x85,0x34,
		0x02,0x7c,0x23,0x56,0xef,0xbd,0xce,0x5a,0x73,0x00,0x7e,0xf1,0xdd,0x74,0x5e,0xab,0x33,0x3d,0x2d,0x86,0x22,0x07),
	(0x98,0xa5,0xdf,0x30,0xc0,0x43,0xcb,0x2f,0x4f,0xff,0x08,0x76,0xbe,0x79,0xcb,0xe9,0x45,0x21,0x9e,0x4e,0xb2,
		0xfe,0xa4,0x59,0x38,0xbb,0x6d,0xe3,0xb1,0x65,0x64,0x16,0xed,0xbf,0xb9,0xc8,0x2e,0x14,0xf0,0x30,0xec,0x03,
		0x66,0x26,0x93,0x14,0x36,0xd3,0xb4,0xb9,0x8b,0x45,0x2d,0xcd,0x3d,0x12,0xa9,0xf3,0x4e,0x48,0x1f,0xb3,0xae,
		0xdf,0x80,0xee,0xdf,0x7f,0xd4,0x69,0x66,0x62,0x55,0x35,0xd7,0x1e,0xaa,0x6f,0x99,0xf6,0xc0,0xc6,0x0b,0x69,
		0x04,0xf8,0x46,0xac,0xde,0x7b,0x9d,0xb5,0xe6,0x00,0xfc,0xe2,0xbb,0xe9,0xbc,0x56,0x67,0x7a,0x5a,0x0c,0x45,0x0e),
	(0x30,0x4b,0xbf,0x61,0x80,0x87,0x96,0x5f,0x9e,0xfe,0x11,0xec,0x7c,0xf3,0x96,0xd3,0x8b,0x42,0x3c,0x9d,0x64,
		0xfd,0x49,0xb3,0x70,0x76,0xdb,0xc6,0x63,0xcb,0xc8,0x2c,0xda,0x7f,0x73,0x91,0x5d,0x28,0xe0,0x61,0xd8,0x07,
		0xcc,0x4c,0x26,0x29,0x6c,0xa6,0x69,0x73,0x17,0x8b,0x5a,0x9a,0x7b,0x24,0x52,0xe7,0x9d,0x90,0x3e,0x66,0x5d,
		0xbf,0x01,0xdd,0xbf,0xff,0xa8,0xd3,0xcc,0xc4,0xaa,0x6a,0xae,0x3d,0x54,0xdf,0x32,0xed,0x81,0x8d,0x17,0xd2,
		0x08,0xf0,0x8d,0x58,0xbd,0xf7,0x3a,0x6b,0xcd,0x01,0xf8,0xc5,0x77,0xd3,0x79,0xad,0xce,0xf4,0xb4,0x18,0x8a,0x1c),
	(0x60,0x96,0x7e,0xc3,0x00,0x0f,0x2d,0xbf,0x3c,0xfd,0x23,0xd8,0xf9,0xe6,0x2d,0xa7,0x17,0x85,0x78,0x3a,0xc9,
		0xfa,0x93,0x66,0xe1,0xec,0xb6,0x8d,0xc7,0x96,0x91,0x59,0xb4,0xff,0xe6,0x22,0xbb,0x50,0xc0,0xc3,0xb0,0x0f,
		0x98,0x99,0x4c,0x52,0xd8,0x4c,0xd3,0xe6,0x2e,0x16,0xb5,0x34,0xf7,0x48,0xa4,0xce,0x3b,0x21,0x7d,0xcc,0xba,
		0x7e,0x03,0xba,0x7f,0xff,0x51,0xa7,0x99,0x89,0x55,0xd5,0x5c,0x7b,0xa8,0xbe,0x65,0xda,0x03,0x1b,0x2f,0xa4,
		0x11,0xe0,0x1b,0xb1,0x7a,0xef,0x75,0xd6,0x9a,0x03,0xf0,0x8b,0xef,0xa6,0xf3,0x5a,0x9d,0xe9,0x69,0x31,0x14,0x39),
	(0xc0,0x2c,0xfd,0x86,0x01,0x1e,0x5a,0x7e,0x79,0xfa,0x47,0xb0,0xf3,0xcd,0x5b,0x4e,0x2f,0x0a,0xf1,0x74,0x92,
		0xf5,0x27,0xcd,0xc2,0xd9,0x6d,0x1b,0x8f,0x2d,0x23,0xb3,0x68,0xff,0xcd,0x45,0x76,0xa1,0x80,0x87,0x61,0x1f,
		0x30,0x33,0x99,0xa4,0xb0,0x99,0xa6,0xcd,0x5d,0x2c,0x6a,0x69,0xee,0x91,0x48,0x9d,0x77,0x42,0xfa,0x98,0x75,
		0xfd,0x06,0x74,0xff,0xfe,0xa3,0x4e,0x33,0x13,0xab,0xaa,0xb9,0xf6,0x50,0x7d,0xcb,0xb4,0x07,0x36,0x5e,0x48,
		0x23,0xc0,0x37,0x62,0xf5,0xde,0xeb,0xac,0x35,0x07,0xe0,0x17,0xdf,0x4d,0xe7,0xb5,0x3a,0xd3,0xd3,0x62,0x28,0x72),
	(0x80,0x59,0xfa,0x0d,0x03,0x3c,0xb4,0xfc,0xf2,0xf4,0x8f,0x60,0xe7,0x9b,0xb7,0x9c,0x5e,0x14,0xe2,0xe9,0x24,
		0xeb,0x4f,0x9a,0x85,0xb3,0xdb,0x36,0x1e,0x5b,0x46,0x66,0xd1,0xfe,0x9b,0x8b,0xec,0x42,0x01,0x0f,0xc3,0x3e,
		0x60,0x66,0x32,0x49,0x61,0x33,0x4d,0x9b,0xbb,0x58,0xd4,0xd2,0xdc,0x23,0x91,0x3a,0xef,0x84,0xf4,0x31,0xeb,
		0xfa,0x0d,0xe8,0xfe,0xfd,0x47,0x9d,0x66,0x26,0x56,0x55,0x73,0xed,0xa1,0xfa,0x96,0x69,0x0f,0x6c,0xbc,0x90,
		0x46,0x80,0x6f,0xc4,0xea,0xbd,0xd7,0x59,0x6b,0x0e,0xc0,0x2f,0xbe,0x9b,0xce,0x6b,0x75,0xa6,0xa7,0xc5,0x50,0xe4))

M_14_68 = (
	(0x69,0xca,0x0b,0xcf,0x38,0x48,0x00,0xd2,0xb9,0x9f,0x98,0x8a,0xe6,0x14,0xb2,0x89,0x11,0x91,0xa9,0xb8,0x25,
		0x5e,0xfa,0xc6,0x5b,0x19,0x78,0xe6,0x47,0x46,0x13,0x3e,0xb8,0x62,0x2f,0xaa,0xcf,0x9c,0x80,0x2a,0xe2,0x8c,
		0x9a,0x48,0x0a,0xa7,0x09,0xf6,0x7a,0x9f,0x91,0x1e,0xbf,0xa1,0x2f,0xa7,0x4e,0xaf,0x9f,0x83,0xc3,0xbe,0x7c,
		0x1e,0x71,0x64,0xf0,0x68,0x20,0x66,0x35,0xb6,0xf7,0x82,0x44,0xde,0xf5,0xc3,0x50,0xfe,0xc7,0x51,0xf1,0x06,
		0xd9,0xad,0xfc,0xd3,0x2c,0x3a,0x57,0x0a,0xf3,0x0d,0xe5,0x2a,0x88,0xbf,0x5c,0xa6,0xa9,0x53,0xeb,0xa7,0x94,
		0xf2,0x81,0x2a,0xbb,0xaa,0x43,0x4e,0x47,0x40,0xe1,0x5d,0x0f,0x1a,0x02,0x00),
	(0xd2,0x94,0x17,0x9e,0x71,0x90,0x00,0xa4,0x73,0x3f,0x31,0x15,0xcd,0x29,0x64,0x13,0x23,0x22,0x53,0x71,0x4b,
		0xbc,0xf4,0x8d,0xb7,0x32,0xf0,0xcc,0x8f,0x8c,0x26,0x7c,0x70,0xc5,0x5e,0x54,0x9f,0x39,0x01,0x55,0xc4,0x19,
		0x35,0x91,0x14,0x4e,0x13,0xec,0xf5,0x3e,0x23,0x3d,0x7e,0x43,0x5f,0x4e,0x9d,0x5e,0x3f,0x07,0x87,0x7d,0xf9,
		0x3c,0xe2,0xc8,0xe0,0xd1,0x40,0xcc,0x6a,0x6c,0xef,0x05,0x89,0xbc,0xeb,0x87,0xa1,0xfc,0x8f,0xa3,0xe2,0x0d,
		0xb2,0x5b,0xf9,0xa7,0x59,0x74,0xae,0x14,0xe6,0x1b,0xca,0x55,0x10,0x7f,0xb9,0x4c,0x53,0xa7,0xd6,0x4f,0x29,
		0xe5,0x03,0x55,0x76,0x55,0x87,0x9c,0x8e,0x80,0xc2,0xbb,0x1e,0x34,0x04,0x00),
	(0xa4,0x29,0x2f,0x3c,0xe3,0x20,0x01,0x48,0xe7,0x7e,0x62,0x2a,0x9a,0x53,0xc8,0x26,0x46,0x44,0xa6,0xe2,0x96,
		0x78,0xe9,0x1b,0x6f,0x65,0xe0,0x99,0x1f,0x19,0x4d,0xf8,0xe0,0x8a,0xbd,0xa8,0x3e,0x73,0x02,0xaa,0x88,0x33,
		0x6a,0x22,0x29,0x9c,0x26,0xd8,0xeb,0x7d,0x46,0x7a,0xfc,0x86,0xbe,0x9c,0x3a,0xbd,0x7e,0x0e,0x0e,0xfb,0xf2,
		0x79,0xc4,0x91,0xc1,0xa3,0x81,0x98,0xd5,0xd8,0xde,0x0b,0x12,0x79,0xd7,0x0f,0x43,0xf9,0x1f,0x47,0xc5,0x1b,
		0x64,0xb7,0xf2,0x4f,0xb3,0xe8,0x5c,0x29,0xcc,0x37,0x94,0xab,0x20,0xfe,0x72,0x99,0xa6,0x4e,0xad,0x9f,0x52,
		0xca,0x07,0xaa,0xec,0xaa,0x0e,0x39,0x1d,0x01,0x85,0x77,0x3d,0x68,0x08,0x00),
	(0x48,0x53,0x5e,0x78,0xc6,0x41,0x02,0x90,0xce,0xfd,0xc4,0x54,0x34,0xa7,0x90,0x4d,0x8c,0x88,0x4c,0xc5,0x2d,
		0xf1,0xd2,0x37,0xde,0xca,0xc0,0x33,0x3f,0x32,0x9a,0xf0,0xc1,0x15,0x7b,0x51,0x7d,0xe6,0x04,0x54,0x11,0x67,
		0xd4,0x44,0x52,0x38,0x4d,0xb0,0xd7,0xfb,0x8c,0xf4,0xf8,0x0d,0x7d,0x39,0x75,0x7a,0xfd,0x1c,0x1c,0xf6,0xe5,
		0xf3,0x88,0x23,0x83,0x47,0x03,0x31,0xab,0xb1,0xbd,0x17,0x24,0xf2,0xae,0x1f,0x86,0xf2,0x3f,0x8e,0x8a,0x37,
		0xc8,0x6e,0xe5,0x9f,0x66,0xd1,0xb9,0x52,0x98,0x6f,0x28,0x57,0x41,0xfc,0xe5,0x32,0x4d,0x9d,0x5a,0x3f,0xa5,
		0x94,0x0f,0x54,0xd9,0x55,0x1d,0x72,0x3a,0x02,0x0a,0xef,0x7a,0xd0,0x10,0x00),
	(0x90,0xa6,0xbc,0xf0,0x8c,0x83,0x04,0x20,0x9d,0xfb,0x89,0xa9,0x68,0x4e,0x21,0x9b,0x18,0x11,0x99,0x8a,0x5b,
		0xe2,0xa5,0x6f,0xbc,0x95,0x81,0x67,0x7e,0x64,0x34,0xe1,0x83,0x2b,0xf6,0xa2,0xfa,0xcc,0x09,0xa8,0x22,0xce,
		0xa8,0x89,0xa4,0x70,0x9a,0x60,0xaf,0xf7,0x19,0xe9,0xf1,0x1b,0xfa,0x72,0xea,0xf4,0xfa,0x39,0x38,0xec,0xcb,
		0xe7,0x11,0x47,0x06,0x8f,0x06,0x62,0x56,0x63,0x7b,0x2f,0x48,0xe4,0x5d,0x3f,0x0c,0xe5,0x7f,0x1c,0x15,0x6f,
		0x90,0xdd,0xca,0x3f,0xcd,0xa2,0x73,0xa5,0x30,0xdf,0x50,0xae,0x82,0xf8,0xcb,0x65,0x9a,0x3a,0xb5,0x7e,0x4a,
		0x29,0x1f,0xa8,0xb2,0xab,0x3a,0xe4,0x74,0x04,0x14,0xde,0xf5,0xa0,0x21,0x00),
	(0x20,0x4d,0x79,0xe1,0x19,0x07,0x09,0x40,0x3a,0xf7,0x13,0x53,0xd1,0x9c,0x42,0x36,0x31,0x22,0x32,0x15,0xb7,
		0xc4,0x4b,0xdf,0x78,0x2b,0x03,0xcf,0xfc,0xc8,0x68,0xc2,0x07,0x57,0xec,0x45,0xf5,0x99,0x13,0x50,0x45,0x9c,
		0x51,0x13,0x49,0xe1,0x34,0xc1,0x5e,0xef,0x33,0xd2,0xe3,0x37,0xf4,0xe5,0xd4,0xe9,0xf5,0x73,0x70,0xd8,0x97,
		0xcf,0x23,0x8e,0x0c,0x1e,0x0d,0xc4,0xac,0xc6,0xf6,0x5e,0x90,0xc8,0xbb,0x7e,0x18,0xca,0xff,0x38,0x2a,0xde,
		0x20,0xbb,0x95,0x7f,0x9a,0x45,0xe7,0x4a,0x61,0xbe,0xa1,0x5c,0x05,0xf1,0x97,0xcb,0x34,0x75,0x6a,0xfd,0x94,
		0x52,0x3e,0x50,0x65,0x57,0x75,0xc8,0xe9,0x08,0x28,0xbc,0xeb,0x41,0x43,0x00),
	(0x40,0x9a,0xf2,0xc2,0x33,0x0e,0x12,0x80,0x74,0xee,0x27,0xa6,0xa2,0x39,0x85,0x6c,0x62,0x44,0x64,0x2a,0x6e,
		0x89,0x97,0xbe,0xf1,0x56,0x06,0x9e,0xf9,0x91,0xd1,0x84,0x0f,0xae,0xd8,0x8b,0xea,0x33,0x27,0xa0,0x8a,0x38,
		0xa3,0x26,0x92,0xc2,0x69,0x82,0xbd,0xde,0x67,0xa4,0xc7,0x6f,0xe8,0xcb,0xa9,0xd3,0xeb,0xe7,0xe0,0xb0,0x2f,
		0x9f,0x47,0x1c,0x19,0x3c,0x1a,0x88,0x59,0x8d,0xed,0xbd,0x20,0x91,0x77,0xfd,0x30,0x94,0xff,0x71,0x54,0xbc,
		0x41,0x76,0x2b,0xff,0x34,0x8b,0xce,0x95,0xc2,0x7c,0x43,0xb9,0x0a,0xe2,0x2f,0x97,0x69,0xea,0xd4,0xfa,0x29,
		0xa5,0x7c,0xa0,0xca,0xae,0xea,0x90,0xd3,0x11,0x50,0x78,0xd7,0x83,0x86,0x00),
	(0x80,0x34,0xe5,0x85,0x67,0x1c,0x24,0x00,0xe9,0xdc,0x4f,0x4c,0x45,0x73,0x0a,0xd9,0xc4,0x88,0xc8,0x54,0xdc,
		0x12,0x2f,0x7d,0xe3,0xad,0x0c,0x3c,0xf3,0x23,0xa3,0x09,0x1f,0x5c,0xb1,0x17,0xd5,0x67,0x4e,0x40,0x15,0x71,
		0x46,0x4d,0x24,0x85,0xd3,0x04,0x7b,0xbd,0xcf,0x48,0x8f,0xdf,0xd0,0x97,0x53,0xa7,0xd7,0xcf,0xc1,0x61,0x5f,
		0x3e,0x8f,0x38,0x32,0x78,0x34,0x10,0xb3,0x1a,0xdb,0x7b,0x41,0x22,0xef,0xfa,0x61,0x28,0xff,0xe3,0xa8,0x78,
		0x83,0xec,0x56,0xfe,0x69,0x16,0x9d,0x2b,0x85,0xf9,0x86,0x72,0x15,0xc4,0x5f,0x2e,0xd3,0xd4,0xa9,0xf5,0x53,
		0x4a,0xf9,0x40,0x95,0x5d,0xd5,0x21,0xa7,0x23,0xa0,0xf0,0xae,0x07,0x0d,0x01))

M_14_72 = (
	(0x2d,0xdb,0xaa,0xfd,0x80,0xd2,0xff,0x17,0x22,0xad,0xb3,0x0d,0xbe,0x69,0x1c,0xe6,0xbc,0x6e,0x4a,0x07,0x64,
		0x01,0xd4,0x0a,0x01,0x7f,0xfc,0x49,0x87,0xdc,0xed,0x3d,0xe7,0x4f,0x48,0x0a,0xef,0x1e,0xbf,0xfd,0x6b,0x2b,
		0x6c,0x66,0x8c,0x5f,0xd1,0xe9,0x09,0xb3,0x75,0x13,0x80,0x24,0xd6,0xc9,0xcb,0xe7,0x91,0xad,0xc2,0x88,0xbe,
		0x84,0x25,0x42,0x40,0xd6,0xdc,0x89,0x0f,0xa5,0xeb,0x8b,0x84,0x34,0xd6,0x47,0xc7,0x0c,0xc9,0xe4,0xbb,0xfa,
		0x00,0xde,0x97,0x72,0x6f,0xf3,0xec,0x8e,0x26,0xf5,0x3a,0x44,0x21,0xea,0xb3,0xb0,0x40,0xab,0x2c,0xfc,0xd7,
		0x45,0x88,0x90,0x6d,0x4d,0x74,0x2a,0x8a,0xc2,0xbb,0x1d,0x98,0x70,0xcf,0x43,0x63,0x18,0x02,0x6f,0x5c,0x02,0x00),
	(0x5a,0xb6,0x55,0xfb,0x01,0xa5,0xff,0x2f,0x44,0x5a,0x67,0x1b,0x7c,0xd3,0x38,0xcc,0x79,0xdd,0x94,0x0e,0xc8,
		0x02,0xa8,0x15,0x02,0xfe,0xf8,0x93,0x0e,0xb9,0xdb,0x7b,0xce,0x9f,0x90,0x14,0xde,0x3d,0x7e,0xfb,0xd7,0x56,
		0xd8,0xcc,0x18,0xbf,0xa2,0xd3,0x13,0x66,0xeb,0x26,0x00,0x49,0xac,0x93,0x97,0xcf,0x23,0x5b,0x85,0x11,0x7d,
		0x09,0x4b,0x84,0x80,0xac,0xb9,0x13,0x1f,0x4a,0xd7,0x17,0x09,0x69,0xac,0x8f,0x8e,0x19,0x92,0xc9,0x77,0xf5,
		0x01,0xbc,0x2f,0xe5,0xde,0xe6,0xd9,0x1d,0x4d,0xea,0x75,0x88,0x42,0xd4,0x67,0x61,0x81,0x56,0x59,0xf8,0xaf,
		0x8b,0x10,0x21,0xdb,0x9a,0xe8,0x54,0x14,0x85,0x77,0x3b,0x30,0xe1,0x9e,0x87,0xc6,0x30,0x04,0xde,0xb8,0x04,0x00),
	(0xb4,0x6c,0xab,0xf6,0x03,0x4a,0xff,0x5f,0x88,0xb4,0xce,0x36,0xf8,0xa6,0x71,0x98,0xf3,0xba,0x29,0x1d,0x90,
		0x05,0x50,0x2b,0x04,0xfc,0xf1,0x27,0x1d,0x72,0xb7,0xf7,0x9c,0x3f,0x21,0x29,0xbc,0x7b,0xfc,0xf6,0xaf,0xad,
		0xb0,0x99,0x31,0x7e,0x45,0xa7,0x27,0xcc,0xd6,0x4d,0x00,0x92,0x58,0x27,0x2f,0x9f,0x47,0xb6,0x0a,0x23,0xfa,
		0x12,0x96,0x08,0x01,0x59,0x73,0x27,0x3e,0x94,0xae,0x2f,0x12,0xd2,0x58,0x1f,0x1d,0x33,0x24,0x93,0xef,0xea,
		0x03,0x78,0x5f,0xca,0xbd,0xcd,0xb3,0x3b,0x9a,0xd4,0xeb,0x10,0x85,0xa8,0xcf,0xc2,0x02,0xad,0xb2,0xf0,0x5f,
		0x17,0x21,0x42,0xb6,0x35,0xd1,0xa9,0x28,0x0a,0xef,0x76,0x60,0xc2,0x3d,0x0f,0x8d,0x61,0x08,0xbc,0x71,0x09,0x00),
	(0x68,0xd9,0x56,0xed,0x07,0x94,0xfe,0xbf,0x10,0x69,0x9d,0x6d,0xf0,0x4d,0xe3,0x30,0xe7,0x75,0x53,0x3a,0x20,
		0x0b,0xa0,0x56,0x08,0xf8,0xe3,0x4f,0x3a,0xe4,0x6e,0xef,0x39,0x7f,0x42,0x52,0x78,0xf7,0xf8,0xed,0x5f,0x5b,
		0x61,0x33,0x63,0xfc,0x8a,0x4e,0x4f,0x98,0xad,0x9b,0x00,0x24,0xb1,0x4e,0x5e,0x3e,0x8f,0x6c,0x15,0x46,0xf4,
		0x25,0x2c,0x11,0x02,0xb2,0xe6,0x4e,0x7c,0x28,0x5d,0x5f,0x24,0xa4,0xb1,0x3e,0x3a,0x66,0x48,0x26,0xdf,0xd5,
		0x07,0xf0,0xbe,0x94,0x7b,0x9b,0x67,0x77,0x34,0xa9,0xd7,0x21,0x0a,0x51,0x9f,0x85,0x05,0x5a,0x65,0xe1,0xbf,
		0x2e,0x42,0x84,0x6c,0x6b,0xa2,0x53,0x51,0x14,0xde,0xed,0xc0,0x84,0x7b,0x1e,0x1a,0xc3,0x10,0x78,0xe3,0x12,0x00),
	(0xd0,0xb2,0xad,0xda,0x0f,0x28,0xfd,0x7f,0x21,0xd2,0x3a,0xdb,0xe0,0x9b,0xc6,0x61,0xce,0xeb,0xa6,0x74,0x40,
		0x16,0x40,0xad,0x10,0xf0,0xc7,0x9f,0x74,0xc8,0xdd,0xde,0x73,0xfe,0x84,0xa4,0xf0,0xee,0xf1,0xdb,0xbf,0xb6,
		0xc2,0x66,0xc6,0xf8,0x15,0x9d,0x9e,0x30,0x5b,0x37,0x01,0x48,0x62,0x9d,0xbc,0x7c,0x1e,0xd9,0x2a,0x8c,0xe8,
		0x4b,0x58,0x22,0x04,0x64,0xcd,0x9d,0xf8,0x50,0xba,0xbe,0x48,0x48,0x63,0x7d,0x74,0xcc,0x90,0x4c,0xbe,0xab,
		0x0f,0xe0,0x7d,0x29,0xf7,0x36,0xcf,0xee,0x68,0x52,0xaf,0x43,0x14,0xa2,0x3e,0x0b,0x0b,0xb4,0xca,0xc2,0x7f,
		0x5d,0x84,0x08,0xd9,0xd6,0x44,0xa7,0xa2,0x28,0xbc,0xdb,0x81,0x09,0xf7,0x3c,0x34,0x86,0x21,0xf0,0xc6,0x25,0x00),
	(0xa0,0x65,0x5b,0xb5,0x1f,0x50,0xfa,0xff,0x42,0xa4,0x75,0xb6,0xc1,0x37,0x8d,0xc3,0x9c,0xd7,0x4d,0xe9,0x80,
		0x2c,0x80,0x5a,0x21,0xe0,0x8f,0x3f,0xe9,0x90,0xbb,0xbd,0xe7,0xfc,0x09,0x49,0xe1,0xdd,0xe3,0xb7,0x7f,0x6d,
		0x85,0xcd,0x8c,0xf1,0x2b,0x3a,0x3d,0x61,0xb6,0x6e,0x02,0x90,0xc4,0x3a,0x79,0xf9,0x3c,0xb2,0x55,0x18,0xd1,
		0x97,0xb0,0x44,0x08,0xc8,0x9a,0x3b,0xf1,0xa1,0x74,0x7d,0x91,0x90,0xc6,0xfa,0xe8,0x98,0x21,0x99,0x7c,0x57,
		0x1f,0xc0,0xfb,0x52,0xee,0x6d,0x9e,0xdd,0xd1,0xa4,0x5e,0x87,0x28,0x44,0x7d,0x16,0x16,0x68,0x95,0x85,0xff,
		0xba,0x08,0x11,0xb2,0xad,0x89,0x4e,0x45,0x51,0x78,0xb7,0x03,0x13,0xee,0x79,0x68,0x0c,0x43,0xe0,0x8d,0x4b,0x00),
	(0x40,0xcb,0xb6,0x6a,0x3f,0xa0,0xf4,0xff,0x85,0x48,0xeb,0x6c,0x83,0x6f,0x1a,0x87,0x39,0xaf,0x9b,0xd2,0x01,
		0x59,0x00,0xb5,0x42,0xc0,0x1f,0x7f,0xd2,0x21,0x77,0x7b,0xcf,0xf9,0x13,0x92,0xc2,0xbb,0xc7,0x6f,0xff,0xda,
		0x0a,0x9b,0x19,0xe3,0x57,0x74,0x7a,0xc2,0x6c,0xdd,0x04,0x20,0x89,0x75,0xf2,0xf2,0x79,0x64,0xab,0x30,0xa2,
		0x2f,0x61,0x89,0x10,0x90,0x35,0x77,0xe2,0x43,0xe9,0xfa,0x22,0x21,0x8d,0xf5,0xd1,0x31,0x43,0x32,0xf9,0xae,
		0x3e,0x80,0xf7,0xa5,0xdc,0xdb,0x3c,0xbb,0xa3,0x49,0xbd,0x0e,0x51,0x88,0xfa,0x2c,0x2c,0xd0,0x2a,0x0b,0xff,
		0x75,0x11,0x22,0x64,0x5b,0x13,0x9d,0x8a,0xa2,0xf0,0x6e,0x07,0x26,0xdc,0xf3,0xd0,0x18,0x86,0xc0,0x1b,0x97,0x00),
	(0x80,0x96,0x6d,0xd5,0x7e,0x40,0xe9,0xff,0x0b,0x91,0xd6,0xd9,0x06,0xdf,0x34,0x0e,0x73,0x5e,0x37,0xa5,0x03,
		0xb2,0x00,0x6a,0x85,0x80,0x3f,0xfe,0xa4,0x43,0xee,0xf6,0x9e,0xf3,0x27,0x24,0x85,0x77,0x8f,0xdf,0xfe,0xb5,
		0x15,0x36,0x33,0xc6,0xaf,0xe8,0xf4,0x84,0xd9,0xba,0x09,0x40,0x12,0xeb,0xe4,0xe5,0xf3,0xc8,0x56,0x61,0x44,
		0x5f,0xc2,0x12,0x21,0x20,0x6b,0xee,0xc4,0x87,0xd2,0xf5,0x45,0x42,0x1a,0xeb,0xa3,0x63,0x86,0x64,0xf2,0x5d,
		0x7d,0x00,0xef,0x4b,0xb9,0xb7,0x79,0x76,0x47,0x93,0x7a,0x1d,0xa2,0x10,0xf5,0x59,0x58,0xa0,0x55,0x16,0xfe,
		0xeb,0x22,0x44,0xc8,0xb6,0x26,0x3a,0x15,0x45,0xe1,0xdd,0x0e,0x4c,0xb8,0xe7,0xa1,0x31,0x0c,0x81,0x37,0x2e,0x01))

M_14_80 = (
	(0x15,0x5e,0x86,0xe5,0xe1,0xb8,0x22,0x20,0x32,0xf5,0xca,0x86,0x4b,0x13,0xa3,0x49,0x5c,0x5a,0x83,0x37,0xfa,
		0x23,0x9e,0xd3,0x30,0x7b,0xae,0xfa,0x43,0x2c,0xfa,0x61,0xf0,0x67,0x71,0xb4,0x6f,0x54,0x73,0x8d,0x2a,0x77,
		0x78,0x38,0x7e,0x3c,0xe9,0x0b,0x79,0xd7,0x48,0xbf,0x4c,0xd8,0x21,0x77,0x26,0x23,0x51,0x23,0x85,0x89,0x97,
		0xa9,0xd2,0xe2,0xe1,0x0a,0x9c,0x3e,0xc7,0x51,0xa9,0x6d,0x73,0x88,0x69,0xb6,0xb3,0x1a,0xf1,0xa2,0x62,0xb7,
		0x4e,0x92,0xc0,0x21,0x31,0x93,0xbd,0xd6,0xe0,0x04,0x47,0x58,0xaf,0x70,0xc1,0x20,0x08,0xc3,0xd4,0x58,0x99,
		0x77,0x23,0xc5,0xd0,0x2e,0x1e,0x70,0xa7,0xbc,0xfb,0x25,0x3a,0x27,0x96,0x7b,0x44,0x44,0x1e,0xf5,0xb1,0x5e,
		0x2a,0x8e,0x30,0xe7,0x72,0x04,0x82,0xa4,0x73,0xf7,0xa0,0x9a,0xd7,0x02,0x00),
	(0x2a,0xbc,0x0c,0xcb,0xc3,0x71,0x45,0x40,0x64,0xea,0x95,0x0d,0x97,0x26,0x46,0x93,0xb8,0xb4,0x06,0x6f,0xf4,
		0x47,0x3c,0xa7,0x61,0xf6,0x5c,0xf5,0x87,0x58,0xf4,0xc3,0xe0,0xcf,0xe2,0x68,0xdf,0xa8,0xe6,0x1a,0x55,0xee,
		0xf0,0x70,0xfc,0x78,0xd2,0x17,0xf2,0xae,0x91,0x7e,0x99,0xb0,0x43,0xee,0x4c,0x46,0xa2,0x46,0x0a,0x13,0x2f,
		0x53,0xa5,0xc5,0xc3,0x15,0x38,0x7d,0x8e,0xa3,0x52,0xdb,0xe6,0x10,0xd3,0x6c,0x67,0x35,0xe2,0x45,0xc5,0x6e,
		0x9d,0x24,0x81,0x43,0x62,0x26,0x7b,0xad,0xc1,0x09,0x8e,0xb0,0x5e,0xe1,0x82,0x41,0x10,0x86,0xa9,0xb1,0x32,
		0xef,0x46,0x8a,0xa1,0x5d,0x3c,0xe0,0x4e,0x79,0xf7,0x4b,0x74,0x4e,0x2c,0xf7,0x88,0x88,0x3c,0xea,0x63,0xbd,
		0x54,0x1c,0x61,0xce,0xe5,0x08,0x04,0x49,0xe7,0xee,0x41,0x35,0xaf,0x05,0x00),
	(0x54,0x78,0x19,0x96,0x87,0xe3,0x8a,0x80,0xc8,0xd4,0x2b,0x1b,0x2e,0x4d,0x8c,0x26,0x71,0x69,0x0d,0xde,0xe8,
		0x8f,0x78,0x4e,0xc3,0xec,0xb9,0xea,0x0f,0xb1,0xe8,0x87,0xc1,0x9f,0xc5,0xd1,0xbe,0x51,0xcd,0x35,0xaa,0xdc,
		0xe1,0xe1,0xf8,0xf1,0xa4,0x2f,0xe4,0x5d,0x23,0xfd,0x32,0x61,0x87,0xdc,0x99,0x8c,0x44,0x8d,0x14,0x26,0x5e,
		0xa6,0x4a,0x8b,0x87,0x2b,0x70,0xfa,0x1c,0x47,0xa5,0xb6,0xcd,0x21,0xa6,0xd9,0xce,0x6a,0xc4,0x8b,0x8a,0xdd,
		0x3a,0x49,0x02,0x87,0xc4,0x4c,0xf6,0x5a,0x83,0x13,0x1c,0x61,0xbd,0xc2,0x05,0x83,0x20,0x0c,0x53,0x63,0x65,
		0xde,0x8d,0x14,0x43,0xbb,0x78,0xc0,0x9d,0xf2,0xee,0x97,0xe8,0x9c,0x58,0xee,0x11,0x11,0x79,0xd4,0xc7,0x7a,
		0xa9,0x38,0xc2,0x9c,0xcb,0x11,0x08,0x92,0xce,0xdd,0x83,0x6a,0x5e,0x0b,0x00),
	(0xa8,0xf0,0x32,0x2c,0x0f,0xc7,0x15,0x01,0x91,0xa9,0x57,0x36,0x5c,0x9a,0x18,0x4d,0xe2,0xd2,0x1a,0xbc,0xd1,
		0x1f,0xf1,0x9c,0x86,0xd9,0x73,0xd5,0x1f,0x62,0xd1,0x0f,0x83,0x3f,0x8b,0xa3,0x7d,0xa3,0x9a,0x6b,0x54,0xb9,
		0xc3,0xc3,0xf1,0xe3,0x49,0x5f,0xc8,0xbb,0x46,0xfa,0x65,0xc2,0x0e,0xb9,0x33,0x19,0x89,0x1a,0x29,0x4c,0xbc,
		0x4c,0x95,0x16,0x0f,0x57,0xe0,0xf4,0x39,0x8e,0x4a,0x6d,0x9b,0x43,0x4c,0xb3,0x9d,0xd5,0x88,0x17,0x15,0xbb,
		0x75,0x92,0x04,0x0e,0x89,0x99,0xec,0xb5,0x06,0x27,0x38,0xc2,0x7a,0x85,0x0b,0x06,0x41,0x18,0xa6,0xc6,0xca,
		0xbc,0x1b,0x29,0x86,0x76,0xf1,0x80,0x3b,0xe5,0xdd,0x2f,0xd1,0x39,0xb1,0xdc,0x23,0x22,0xf2,0xa8,0x8f,0xf5,
		0x52,0x71,0x84,0x39,0x97,0x23,0x10,0x24,0x9d,0xbb,0x07,0xd5,0xbc,0x16,0x00),
	(0x50,0xe1,0x65,0x58,0x1e,0x8e,0x2b,0x02,0x22,0x53,0xaf,0x6c,0xb8,0x34,0x31,0x9a,0xc4,0xa5,0x35,0x78,0xa3,
		0x3f,0xe2,0x39,0x0d,0xb3,0xe7,0xaa,0x3f,0xc4,0xa2,0x1f,0x06,0x7f,0x16,0x47,0xfb,0x46,0x35,0xd7,0xa8,0x72,
		0x87,0x87,0xe3,0xc7,0x93,0xbe,0x90,0x77,0x8d,0xf4,0xcb,0x84,0x1d,0x72,0x67,0x32,0x12,0x35,0x52,0x98,0x78,
		0x99,0x2a,0x2d,0x1e,0xae,0xc0,0xe9,0x73,0x1c,0x95,0xda,0x36,0x87,0x98,0x66,0x3b,0xab,0x11,0x2f,0x2a,0x76,
		0xeb,0x24,0x09,0x1c,0x12,0x33,0xd9,0x6b,0x0d,0x4e,0x70,0x84,0xf5,0x0a,0x17,0x0c,0x82,0x30,0x4c,0x8d,0x95,
		0x79,0x37,0x52,0x0c,0xed,0xe2,0x01,0x77,0xca,0xbb,0x5f,0xa2,0x73,0x62,0xb9,0x47,0x44,0xe4,0x51,0x1f,0xeb,
		0xa5,0xe2,0x08,0x73,0x2e,0x47,0x20,0x48,0x3a,0x77,0x0f,0xaa,0x79,0x2d,0x00),
	(0xa0,0xc2,0xcb,0xb0,0x3c,0x1c,0x57,0x04,0x44,0xa6,0x5e,0xd9,0x70,0x69,0x62,0x34,0x89,0x4b,0x6b,0xf0,0x46,
		0x7f,0xc4,0x73,0x1a,0x66,0xcf,0x55,0x7f,0x88,0x45,0x3f,0x0c,0xfe,0x2c,0x8e,0xf6,0x8d,0x6a,0xae,0x51,0xe5,
		0x0e,0x0f,0xc7,0x8f,0x27,0x7d,0x21,0xef,0x1a,0xe9,0x97,0x09,0x3b,0xe4,0xce,0x64,0x24,0x6a,0xa4,0x30,0xf1,
		0x32,0x55,0x5a,0x3c,0x5c,0x81,0xd3,0xe7,0x38,0x2a,0xb5,0x6d,0x0e,0x31,0xcd,0x76,0x56,0x23,0x5e,0x54,0xec,
		0xd6,0x49,0x12,0x38,0x24,0x66,0xb2,0xd7,0x1a,0x9c,0xe0,0x08,0xeb,0x15,0x2e,0x18,0x04,0x61,0x98,0x1a,0x2b,
		0xf3,0x6e,0xa4,0x18,0xda,0xc5,0x03,0xee,0x94,0x77,0xbf,0x44,0xe7,0xc4,0x72,0x8f,0x88,0xc8,0xa3,0x3e,0xd6,
		0x4b,0xc5,0x11,0xe6,0x5c,0x8e,0x40,0x90,0x74,0xee,0x1e,0x54,0xf3,0x5a,0x00),
	(0x40,0x85,0x97,0x61,0x79,0x38,0xae,0x08,0x88,0x4c,0xbd,0xb2,0xe1,0xd2,0xc4,0x68,0x12,0x97,0xd6,0xe0,0x8d,
		0xfe,0x88,0xe7,0x34,0xcc,0x9e,0xab,0xfe,0x10,0x8b,0x7e,0x18,0xfc,0x59,0x1c,0xed,0x1b,0xd5,0x5c,0xa3,0xca,
		0x1d,0x1e,0x8e,0x1f,0x4f,0xfa,0x42,0xde,0x35,0xd2,0x2f,0x13,0x76,0xc8,0x9d,0xc9,0x48,0xd4,0x48,0x61,0xe2,
		0x65,0xaa,0xb4,0x78,0xb8,0x02,0xa7,0xcf,0x71,0x54,0x6a,0xdb,0x1c,0x62,0x9a,0xed,0xac,0x46,0xbc,0xa8,0xd8,
		0xad,0x93,0x24,0x70,0x48,0xcc,0x64,0xaf,0x35,0x38,0xc1,0x11,0xd6,0x2b,0x5c,0x30,0x08,0xc2,0x30,0x35,0x56,
		0xe6,0xdd,0x48,0x31,0xb4,0x8b,0x07,0xdc,0x29,0xef,0x7e,0x89,0xce,0x89,0xe5,0x1e,0x11,0x91,0x47,0x7d,0xac,
		0x97,0x8a,0x23,0xcc,0xb9,0x1c,0x81,0x20,0xe9,0xdc,0x3d,0xa8,0xe6,0xb5,0x00),
	(0x80,0x0a,0x2f,0xc3,0xf2,0x70,0x5c,0x11,0x10,0x99,0x7a,0x65,0xc3,0xa5,0x89,0xd1,0x24,0x2e,0xad,0xc1,0x1b,
		0xfd,0x11,0xcf,0x69,0x98,0x3d,0x57,0xfd,0x21,0x16,0xfd,0x30,0xf8,0xb3,0x38,0xda,0x37,0xaa,0xb9,0x46,0x95,
		0x3b,0x3c,0x1c,0x3f,0x9e,0xf4,0x85,0xbc,0x6b,0xa4,0x5f,0x26,0xec,0x90,0x3b,0x93,0x91,0xa8,0x91,0xc2,0xc4,
		0xcb,0x54,0x69,0xf1,0x70,0x05,0x4e,0x9f,0xe3,0xa8,0xd4,0xb6,0x39,0xc4,0x34,0xdb,0x59,0x8d,0x78,0x51,0xb1,
		0x5b,0x27,0x49,0xe0,0x90,0x98,0xc9,0x5e,0x6b,0x70,0x82,0x23,0xac,0x57,0xb8,0x60,0x10,0x84,0x61,0x6a,0xac,
		0xcc,0xbb,0x91,0x62,0x68,0x17,0x0f,0xb8,0x53,0xde,0xfd,0x12,0x9d,0x13,0xcb,0x3d,0x22,0x22,0x8f,0xfa,0x58,
		0x2f,0x15,0x47,0x98,0x73,0x39,0x02,0x41,0xd2,0xb9,0x7b,0x50,0xcd,0x6b,0x01))

def bch_enc_14(data, enc_len, level):
	""" bch ecc encode function, parity bits is 14.
	data is the source buffer
	enc_len is the encode length
	level is the ecc level used """

	#print "bch encode length is %d, " % enc_len,
	#print "ecc level is %d " % level

	# select proper matrix for the ecc level assigned #
	parity_byte = int(math.ceil(float(level) * 14 / 8))
	#temp = 'matrix = M_14_' + str(level)
	#exec(temp)
	if str(level) == "4":
		matrix = M_14_4
	elif str(level) == "6":
		matrix = M_14_6
	elif str(level) == "8":
		matrix = M_14_8
	elif str(level) == "10":
		matrix = M_14_10
	elif str(level) == "12":
		matrix = M_14_12
	elif str(level) == "14":
		matrix = M_14_14
	elif str(level) == "16":
		matrix = M_14_16
	elif str(level) == "18":
		matrix = M_14_18
	elif str(level) == "20":
		matrix = M_14_20
	elif str(level) == "22":
		matrix = M_14_22
	elif str(level) == "24":
		matrix = M_14_24
	elif str(level) == "28":
		matrix = M_14_28
	elif str(level) == "32":
		matrix = M_14_32
	elif str(level) == "36":
		matrix = M_14_36
	elif str(level) == "40":
		matrix = M_14_40
	elif str(level) == "44":
		matrix = M_14_44
	elif str(level) == "48":
		matrix = M_14_48
	elif str(level) == "52":
		matrix = M_14_52
	elif str(level) == "56":
		matrix = M_14_56
	elif str(level) == "60":
		matrix = M_14_60
	elif str(level) == "68":
		matrix = M_14_68
	elif str(level) == "72":
		matrix = M_14_72
	elif str(level) == "80":
		matrix = M_14_80

	# fetch raw data #
	raw = data + (b'\0' * parity_byte)
	raw = bytearray(raw)

	for i in range(enc_len):
		for j in range(8):
			if (raw[i] & (1 << j)) != 0:
				for k in range(parity_byte + 1):
					raw[i + k] ^= matrix[j][k]
	
	# feedback parity data generated #
	#raw = raw.decode()#str(raw)
	parity_data = raw[enc_len:]
	return parity_data

if __name__ == "__main__":
	""" this is bch encode function. """
	print("this is bch encode function.")