#!/usr/bin/env python3

import ecc_bch
import sys
import os
import struct
import argparse

def gen_header(nand_name, out_image):
	""" device info:
	name interface pagesize cycle sparesize pageperblock total_blocks nand_cfg accon fdmecc_size ecc_fdm plane_sel_poi
	"""
	with open(os.getcwd() + "/tools/nand-utils/nand_device_list_v14.txt", "r") as f:
		found = 0
		for l in f:
			s = l.split()
			if s[0] == nand_name:
				found = 1
				interface = eval(s[1])
				page_size = int(s[2])
				address_cycle = int(s[3])
				spare_size = int(s[4])
				page_per_block = int(s[5])
				total_blocks = int(s[6])
				nand_cfg = int(s[7], 16)
				accon = int(s[8])
				fdmecc_size = int(s[9])
				ecc_fdm = int(s[10])
				plane_sel_poi = int(s[11])

		if not found:
			raise KeyError("not support " + nand_name)

	# step1: generate nand header info #
	header = b"BOOTLOADER!" + b'\0'
	header += b"V006"
	header += struct.pack("H", interface)
	header += struct.pack("H", page_size)
	header += struct.pack("H", address_cycle)
	header += struct.pack("H", spare_size)
	header += struct.pack("H", page_per_block)
	header += struct.pack("H", total_blocks)
	header += struct.pack("I", nand_cfg)
	header += b'\0' * 8
	header += struct.pack("I", accon)
	header += b'\0' * 8

	bl_start = 4
	bl_end = 511
	header += struct.pack("BBHII", fdmecc_size, ecc_fdm, plane_sel_poi, bl_start,\
			bl_end)
	#16 dummy bytes
	header += b'\0' * 16
	# calculate header ecc parity #
	ecc_level = 24
	header_size = len(header)
	ecc = ecc_bch.bch_enc_14(header, header_size, ecc_level)
	header += ecc
	header += b'\0' * (128 - len(header))
	# double nfb header #
	header += header

	with open(out_image, "wb+") as f:
		f.write(header)

def main(argv):
	parser = argparse.ArgumentParser()
	parser.add_argument('nand_name', help = 'nand device name')
	parser.add_argument('out_image', help = 'the output header file')
	args = parser.parse_args()

	# generate nand device header #
	gen_header(args.nand_name, args.out_image)

if __name__ == "__main__":
	sys.exit(main(sys.argv))
