#!/usr/bin/env python

import math

M_13_4 = ((0x45,0x89,0x41,0xb8,0x3a,0xac,0x1a,0x00),
		(0x8a,0x12,0x83,0x70,0x75,0x58,0x35,0x00),
		(0x14,0x25,0x06,0xe1,0xea,0xb0,0x6a,0x00),
		(0x28,0x4a,0x0c,0xc2,0xd5,0x61,0xd5,0x00),
		(0x50,0x94,0x18,0x84,0xab,0xc3,0xaa,0x01),
		(0xa0,0x28,0x31,0x08,0x57,0x87,0x55,0x03),
		(0x40,0x51,0x62,0x10,0xae,0x0e,0xab,0x06),
		(0x80,0xa2,0xc4,0x20,0x5c,0x1d,0x56,0x0d))

M_13_6 = ((0x7f,0x9e,0x49,0x86,0x93,0x87,0x9d,0xce,0x46,0x5f,0x00),
		(0xfe,0x3c,0x93,0x0c,0x27,0x0f,0x3b,0x9d,0x8d,0xbe,0x00),
		(0xfc,0x79,0x26,0x19,0x4e,0x1e,0x76,0x3a,0x1b,0x7d,0x01),
		(0xf8,0xf3,0x4c,0x32,0x9c,0x3c,0xec,0x74,0x36,0xfa,0x02),
		(0xf0,0xe7,0x99,0x64,0x38,0x79,0xd8,0xe9,0x6c,0xf4,0x05),
		(0xe0,0xcf,0x33,0xc9,0x70,0xf2,0xb0,0xd3,0xd9,0xe8,0x0b),
		(0xc0,0x9f,0x67,0x92,0xe1,0xe4,0x61,0xa7,0xb3,0xd1,0x17),
		(0x80,0x3f,0xcf,0x24,0xc3,0xc9,0xc3,0x4e,0x67,0xa3,0x2f))

M_13_8 = ((0x51,0x3f,0x51,0x0e,0xbc,0x61,0x90,0xc3,0x05,0x47,0x47,0xbe,0x89,0x01),
		(0xa2,0x7e,0xa2,0x1c,0x78,0xc3,0x20,0x87,0x0b,0x8e,0x8e,0x7c,0x13,0x03),
		(0x44,0xfd,0x44,0x39,0xf0,0x86,0x41,0x0e,0x17,0x1c,0x1d,0xf9,0x26,0x06),
		(0x88,0xfa,0x89,0x72,0xe0,0x0d,0x83,0x1c,0x2e,0x38,0x3a,0xf2,0x4d,0x0c),
		(0x10,0xf5,0x13,0xe5,0xc0,0x1b,0x06,0x39,0x5c,0x70,0x74,0xe4,0x9b,0x18),
		(0x20,0xea,0x27,0xca,0x81,0x37,0x0c,0x72,0xb8,0xe0,0xe8,0xc8,0x37,0x31),
		(0x40,0xd4,0x4f,0x94,0x03,0x6f,0x18,0xe4,0x70,0xc1,0xd1,0x91,0x6f,0x62),
		(0x80,0xa8,0x9f,0x28,0x07,0xde,0x30,0xc8,0xe1,0x82,0xa3,0x23,0xdf,0xc4))

M_13_10 = ((0xd3,0x92,0x7b,0x58,0x0a,0x9f,0x2c,0x92,0xdb,0x83,0x6a,0x40,0xf5,0x83,0x66,0x9f,0x04,0x00),
		(0xa6,0x25,0xf7,0xb0,0x14,0x3e,0x59,0x24,0xb7,0x07,0xd5,0x80,0xea,0x07,0xcd,0x3e,0x09,0x00),
		(0x4c,0x4b,0xee,0x61,0x29,0x7c,0xb2,0x48,0x6e,0x0f,0xaa,0x01,0xd5,0x0f,0x9a,0x7d,0x12,0x00),
		(0x98,0x96,0xdc,0xc3,0x52,0xf8,0x64,0x91,0xdc,0x1e,0x54,0x03,0xaa,0x1f,0x34,0xfb,0x24,0x00),
		(0x30,0x2d,0xb9,0x87,0xa5,0xf0,0xc9,0x22,0xb9,0x3d,0xa8,0x06,0x54,0x3f,0x68,0xf6,0x49,0x00),
		(0x60,0x5a,0x72,0x0f,0x4b,0xe1,0x93,0x45,0x72,0x7b,0x50,0x0d,0xa8,0x7e,0xd0,0xec,0x93,0x00),
		(0xc0,0xb4,0xe4,0x1e,0x96,0xc2,0x27,0x8b,0xe4,0xf6,0xa0,0x1a,0x50,0xfd,0xa0,0xd9,0x27,0x01),
		(0x80,0x69,0xc9,0x3d,0x2c,0x85,0x4f,0x16,0xc9,0xed,0x41,0x35,0xa0,0xfa,0x41,0xb3,0x4f,0x02))

M_13_12 = ((0x4f,0xc2,0x99,0xd4,0x10,0xb5,0xd4,0x3c,0xa4,0x2c,0x05,0x4a,0xc6,0xce,0xd6,0x0f,0x09,0xf4,0x40,0x11,0x00),
		(0x9e,0x84,0x33,0xa9,0x21,0x6a,0xa9,0x79,0x48,0x59,0x0a,0x94,0x8c,0x9d,0xad,0x1f,0x12,0xe8,0x81,0x22,0x00),
		(0x3c,0x09,0x67,0x52,0x43,0xd4,0x52,0xf3,0x90,0xb2,0x14,0x28,0x19,0x3b,0x5b,0x3f,0x24,0xd0,0x03,0x45,0x00),
		(0x78,0x12,0xce,0xa4,0x86,0xa8,0xa5,0xe6,0x21,0x65,0x29,0x50,0x32,0x76,0xb6,0x7e,0x48,0xa0,0x07,0x8a,0x00),
		(0xf0,0x24,0x9c,0x49,0x0d,0x51,0x4b,0xcd,0x43,0xca,0x52,0xa0,0x64,0xec,0x6c,0xfd,0x90,0x40,0x0f,0x14,0x01),
		(0xe0,0x49,0x38,0x93,0x1a,0xa2,0x96,0x9a,0x87,0x94,0xa5,0x40,0xc9,0xd8,0xd9,0xfa,0x21,0x81,0x1e,0x28,0x02),
		(0xc0,0x93,0x70,0x26,0x35,0x44,0x2d,0x35,0x0f,0x29,0x4b,0x81,0x92,0xb1,0xb3,0xf5,0x43,0x02,0x3d,0x50,0x04),
		(0x80,0x27,0xe1,0x4c,0x6a,0x88,0x5a,0x6a,0x1e,0x52,0x96,0x02,0x25,0x63,0x67,0xeb,0x87,0x04,0x7a,0xa0,0x08))

M_13_14 = ((0xeb,0xee,0x73,0xc9,0x34,0x8a,0xc0,0x32,0x03,0x65,0x1f,0x54,0x4b,0xad,0x2b,0xd4,0xe0,0x15,0x23,0xc2,0x08,0x65,0x4a,0x00),
		(0xd6,0xdd,0xe7,0x92,0x69,0x14,0x81,0x65,0x06,0xca,0x3e,0xa8,0x96,0x5a,0x57,0xa8,0xc1,0x2b,0x46,0x84,0x11,0xca,0x94,0x00),
		(0xac,0xbb,0xcf,0x25,0xd3,0x28,0x02,0xcb,0x0c,0x94,0x7d,0x50,0x2d,0xb5,0xae,0x50,0x83,0x57,0x8c,0x08,0x23,0x94,0x29,0x01),
		(0x58,0x77,0x9f,0x4b,0xa6,0x51,0x04,0x96,0x19,0x28,0xfb,0xa0,0x5a,0x6a,0x5d,0xa1,0x06,0xaf,0x18,0x11,0x46,0x28,0x53,0x02),
		(0xb0,0xee,0x3e,0x97,0x4c,0xa3,0x08,0x2c,0x33,0x50,0xf6,0x41,0xb5,0xd4,0xba,0x42,0x0d,0x5e,0x31,0x22,0x8c,0x50,0xa6,0x04),
		(0x60,0xdd,0x7d,0x2e,0x99,0x46,0x11,0x58,0x66,0xa0,0xec,0x83,0x6a,0xa9,0x75,0x85,0x1a,0xbc,0x62,0x44,0x18,0xa1,0x4c,0x09),
		(0xc0,0xba,0xfb,0x5c,0x32,0x8d,0x22,0xb0,0xcc,0x40,0xd9,0x07,0xd5,0x52,0xeb,0x0a,0x35,0x78,0xc5,0x88,0x30,0x42,0x99,0x12),
		(0x80,0x75,0xf7,0xb9,0x64,0x1a,0x45,0x60,0x99,0x81,0xb2,0x0f,0xaa,0xa5,0xd6,0x15,0x6a,0xf0,0x8a,0x11,0x61,0x84,0x32,0x25))

M_13_16 = ((0xa7,0xfb,0xf8,0x61,0xfb,0x46,0x8d,0x5b,0xbf,0x09,0xfe,0xc1,0xdf,0xab,0x44,0xff,0x81,0xec,0x9b,0x3d,0xca,0x00,0x67,0x17,0x7e,0x17,0x01),
		(0x4e,0xf7,0xf1,0xc3,0xf6,0x8d,0x1a,0xb7,0x7e,0x13,0xfc,0x83,0xbf,0x57,0x89,0xfe,0x03,0xd9,0x37,0x7b,0x94,0x01,0xce,0x2e,0xfc,0x2e,0x02),
		(0x9c,0xee,0xe3,0x87,0xed,0x1b,0x35,0x6e,0xfd,0x26,0xf8,0x07,0x7f,0xaf,0x12,0xfd,0x07,0xb2,0x6f,0xf6,0x28,0x03,0x9c,0x5d,0xf8,0x5d,0x04),
		(0x38,0xdd,0xc7,0x0f,0xdb,0x37,0x6a,0xdc,0xfa,0x4d,0xf0,0x0f,0xfe,0x5e,0x25,0xfa,0x0f,0x64,0xdf,0xec,0x51,0x06,0x38,0xbb,0xf0,0xbb,0x08),
		(0x70,0xba,0x8f,0x1f,0xb6,0x6f,0xd4,0xb8,0xf5,0x9b,0xe0,0x1f,0xfc,0xbd,0x4a,0xf4,0x1f,0xc8,0xbe,0xd9,0xa3,0x0c,0x70,0x76,0xe1,0x77,0x11),
		(0xe0,0x74,0x1f,0x3f,0x6c,0xdf,0xa8,0x71,0xeb,0x37,0xc1,0x3f,0xf8,0x7b,0x95,0xe8,0x3f,0x90,0x7d,0xb3,0x47,0x19,0xe0,0xec,0xc2,0xef,0x22),
		(0xc0,0xe9,0x3e,0x7e,0xd8,0xbe,0x51,0xe3,0xd6,0x6f,0x82,0x7f,0xf0,0xf7,0x2a,0xd1,0x7f,0x20,0xfb,0x66,0x8f,0x32,0xc0,0xd9,0x85,0xdf,0x45),
		(0x80,0xd3,0x7d,0xfc,0xb0,0x7d,0xa3,0xc6,0xad,0xdf,0x04,0xff,0xe0,0xef,0x55,0xa2,0xff,0x40,0xf6,0xcd,0x1e,0x65,0x80,0xb3,0x0b,0xbf,0x8b))

def bch_enc_13(data, enc_len, level):
	""" bch ecc encode function, parity bits is 13.
	data is the source buffer
	enc_len is the encode length
	level is the ecc level used """

	#print "bch encode length is %d, " % enc_len,
	#print "ecc level is %d " % level

	# select proper matrix for the ecc level assigned #
	parity_byte = int(math.ceil(float(level) * 13 / 8))
	temp = 'matrix = M_13_' + str(level)
	exec(temp)

	# fetch raw data #
	raw = data + ('\0' * parity_byte)
	raw = bytearray(raw)

	for i in range(enc_len):
		for j in range(8):
			if (raw[i] & (1 << j)) != 0:
				for k in range(parity_byte + 1):
					raw[i + k] ^= matrix[j][k]

	# feedback parity data generated #
	raw = str(raw)
	parity_data = raw[enc_len:]
	return parity_data

if __name__ == "__main__":
	""" this is bch encode function. """
	print "this is bch encode function."
