/* SPDX-License-Identifier: BSD-2-Clause */
/*
 * Copyright (C) 2015 Freescale Semiconductor, Inc.
 * Copyright (c) 2016, Wind River Systems.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef PLAT_IMX_IMX_REGS_H
#define PLAT_IMX_IMX_REGS_H

#ifdef CFG_MX6
#define UART1_BASE			0x2020000
#define IOMUXC_BASE			0x020E0000
#define IOMUXC_SIZE			0x4000
#define IOMUXC_GPR_BASE			0x020E4000
#define SRC_BASE			0x020D8000
#define SRC_SIZE			0x4000
#define CCM_BASE			0x020C4000
#define CCM_SIZE			0x4000
#define ANATOP_BASE			0x020C8000
#define ANATOP_SIZE			0x1000
#define SNVS_BASE			0x020CC000
#define GPC_BASE			0x020DC000
#define GPC_SIZE			0x4000
#define WDOG_BASE			0x020BC000
#define SEMA4_BASE			0x02290000
#define SEMA4_SIZE			0x4000
#define MMDC_P0_BASE			0x021B0000
#define MMDC_P0_SIZE			0x4000
#define MMDC_P1_BASE			0x021B4000
#define MMDC_P1_SIZE			0x4000
#define TZASC_BASE			0x21D0000
#define TZASC2_BASE			0x21D4000
#define UART2_BASE			0x021E8000
#define UART3_BASE			0x021EC000
#define UART4_BASE			0x021F0000
#define UART5_BASE			0x021F4000
#define AIPS1_BASE			0x02000000
#define AIPS1_SIZE			0x100000
#define AIPS2_BASE			0x02100000
#define AIPS2_SIZE			0x100000
#define AIPS3_BASE			0x02200000
#define AIPS3_SIZE			0x100000

#define SCU_BASE			0x00A00000
#define PL310_BASE			0x00A02000
#define SRC_BASE			0x020D8000
#define IRAM_BASE			0x00900000

#define OCOTP_BASE			0x021BC000

#define GIC_BASE			0x00A00000
#define GICD_OFFSET			0x1000

#if defined(CFG_MX6UL) || defined(CFG_MX6ULL)
#define GICC_OFFSET			0x2000
/* No CAAM on i.MX6ULL */
#define CAAM_BASE			0x02140000
#else
#define GICC_OFFSET			0x100
#define CAAM_BASE			0x02100000
#endif

#define GIC_CPU_BASE			(GIC_BASE + GICC_OFFSET)
#define GIC_DIST_BASE			(GIC_BASE + GICD_OFFSET)

/* Central Security Unit register values */
#define CSU_BASE			0x021C0000
#define CSU_CSL_START			0x0
#define CSU_CSL_END			0xA0
#define CSU_CSL5			0x14
#define CSU_CSL15			0x3C
#define CSU_CSL16			0x40
#define	CSU_ACCESS_ALL			0x00FF00FF
#define CSU_SETTING_LOCK		0x01000100

/* Used in suspend/resume and low power idle */
#define MX6Q_SRC_GPR1			0x20
#define MX6Q_SRC_GPR2			0x24
#define MX6Q_MMDC_MISC			0x18
#define MX6Q_MMDC_MAPSR			0x404
#define MX6Q_MMDC_MPDGCTRL0		0x83c
#define MX6Q_GPC_IMR1			0x08
#define MX6Q_GPC_IMR2			0x0c
#define MX6Q_GPC_IMR3			0x10
#define MX6Q_GPC_IMR4			0x14
#define MX6Q_CCM_CCR			0x0
#define MX6Q_ANATOP_CORE		0x140

#define IOMUXC_GPR9_OFFSET		0x24
#define IOMUXC_GPR10_OFFSET		0x28

#define IOMUXC_GPR10_OCRAM_TZ_ADDR_OFFSET	5
#define IOMUXC_GPR10_OCRAM_TZ_ADDR_MASK		GENMASK_32(10, 5)

#define IOMUXC_GPR10_OCRAM_TZ_EN_OFFSET		4
#define IOMUXC_GPR10_OCRAM_TZ_EN_MASK		GENMASK_32(4, 4)

#define IOMUXC_GPR10_OCRAM_TZ_EN_LOCK_OFFSET	20
#define IOMUXC_GPR10_OCRAM_TZ_EN_LOCK_MASK	GENMASK_32(20, 20)
#define IOMUXC_GPR10_OCRAM_TZ_ADDR_LOCK_OFFSET	21
#define IOMUXC_GPR10_OCRAM_TZ_ADDR_LOCK_MASK	GENMASK_32(26, 21)

#define IOMUXC_GPR10_OCRAM_TZ_ADDR_OFFSET_6UL	11
#define IOMUXC_GPR10_OCRAM_TZ_ADDR_MASK_6UL	GENMASK_32(15, 11)
#define IOMUXC_GPR10_OCRAM_TZ_EN_OFFSET_6UL	10
#define IOMUXC_GPR10_OCRAM_TZ_EN_MASK_6UL	GENMASK_32(10, 10)

#define IOMUXC_GPR10_OCRAM_TZ_EN_LOCK_OFFSET_6UL	26
#define IOMUXC_GPR10_OCRAM_TZ_EN_LOCK_MASK_6UL		GENMASK_32(26, 26)
#define IOMUXC_GPR10_OCRAM_TZ_ADDR_LOCK_OFFSET_6UL	(27)
#define IOMUXC_GPR10_OCRAM_TZ_ADDR_LOCK_MASK_6UL	GENMASK_32(31, 27)

#if defined(CFG_MX6UL) || defined(CFG_MX6ULL) || defined(CFG_MX6SX)
#define DRAM0_BASE			0x80000000
#else
#define DRAM0_BASE			0x10000000
#endif

#elif defined(CFG_MX7)
#define GIC_BASE		0x31000000
#define GIC_SIZE		0x8000
#define GICC_OFFSET		0x2000
#define GICD_OFFSET		0x1000

#define CAAM_BASE		0x30900000
#define UART1_BASE		0x30860000
#define UART2_BASE		0x30890000
#define UART3_BASE		0x30880000

#define AIPS1_BASE		0x30000000
#define AIPS1_SIZE		0x400000
#define AIPS2_BASE		0x30400000
#define AIPS2_SIZE		0x400000
#define AIPS3_BASE		0x30800000
#define AIPS3_SIZE		0x400000

#define WDOG_BASE		0x30280000
#define LPSR_BASE		0x30270000
#define IOMUXC_BASE		0x30330000
#define IOMUXC_GPR_BASE		0x30340000
#define OCOTP_BASE		0x30350000
#define ANATOP_BASE		0x30360000
#define SNVS_BASE		0x30370000
#define CCM_BASE		0x30380000
#define SRC_BASE		0x30390000
#define GPC_BASE		0x303A0000
#define TZASC_BASE		0x30780000
#define DDRC_PHY_BASE		0x30790000
#define MMDC_P0_BASE		0x307A0000
#define DDRC_BASE		0x307A0000
#define IRAM_BASE		0x00900000
#define IRAM_S_BASE		0x00180000

#define CSU_CSL_START		0x303E0000
#define CSU_CSL_END		0x303E0100
#define CSU_CSL_59		(0x303E0000 + 59 * 4)
#define CSU_CSL_28		(0x303E0000 + 28 * 4)
#define CSU_CSL_15		(0x303E0000 + 15 * 4)
#define CSU_CSL_12		(0x303E0000 + 12 * 4)
#define	CSU_ACCESS_ALL		0x00FF00FF
#define CSU_SETTING_LOCK	0x01000100

#define TRUSTZONE_OCRAM_START	0x180000

#define IOMUXC_GPR9_OFFSET				0x24
#define IOMUXC_GPR9_TZASC1_MUX_CONTROL_OFFSET		0

#define IOMUXC_GPR11_OFFSET				0x2C
#define IOMUXC_GPR11_OCRAM_S_TZ_ADDR_OFFSET		11
#define IOMUXC_GPR11_OCRAM_S_TZ_ADDR_MASK		GENMASK_32(13, 11)

#define IOMUXC_GPR11_OCRAM_S_TZ_EN_OFFSET		10
#define IOMUXC_GPR11_OCRAM_S_TZ_EN_MASK			GENMASK_32(10, 10)

#define IOMUXC_GPR11_OCRAM_S_TZ_EN_LOCK_OFFSET		26
#define IOMUXC_GPR11_OCRAM_S_TZ_EN_LOCK_MASK		GENMASK_32(26, 26)
#define IOMUXC_GPR11_OCRAM_S_TZ_ADDR_LOCK_OFFSET	GENMASK_32(29, 27)
#else
#error "CFG_MX6/7 not defined"
#endif

#define IOMUXC_GPR4_OFFSET	0x10
#define IOMUXC_GPR5_OFFSET	0x14
#define ARM_WFI_STAT_MASK(n)	BIT(n)

#define ARM_WFI_STAT_MASK_7D(n)	BIT(25 + ((n) & 1))

#define SRC_SCR				0x000
#define SRC_GPR1			0x020
#define SRC_GPR2			0x024
#define SRC_SCR_CORE1_RST_OFFSET	14
#define SRC_SCR_CORE1_ENABLE_OFFSET	22
#define SRC_SCR_CPU_ENABLE_ALL		SHIFT_U32(0x7, 22)

#define SRC_GPR1_MX7			0x074
#define SRC_A7RCR0			0x004
#define SRC_A7RCR1			0x008
#define SRC_A7RCR0_A7_CORE_RESET0_OFFSET	0
#define SRC_A7RCR1_A7_CORE1_ENABLE_OFFSET	1

#define SNVS_LPCR_OFF			0x38
#define SNVS_LPCR_TOP_MASK		BIT(6)
#define SNVS_LPCR_DP_EN_MASK		BIT(5)
#define SNVS_LPCR_SRTC_ENV_MASK		1

#define WCR_OFF				0

#define OFFSET_DIGPROG			0x260
#define OFFSET_DIGPROG_IMX6SL		0x280
#define OFFSET_DIGPROG_IMX7D		0x800

/* GPC V2 */
#define GPC_PGC_C1			0x840
#define GPC_PGC_C1_PUPSCR		0x844

#define GPC_PGC_PCG_MASK		BIT(0)

#define GPC_CPU_PGC_SW_PUP_REQ		0xf0
#define GPC_PU_PGC_SW_PUP_REQ		0xf8
#define GPC_CPU_PGC_SW_PDN_REQ		0xfc
#define GPC_PU_PGC_SW_PDN_REQ		0x104
#define GPC_PGC_SW_PDN_PUP_REQ_CORE1_MASK BIT(1)
#endif
