

include core/arch/arm/cpu/cortex-armv8-0.mk

CFG_TZDRAM_START ?= 0x45000000
CFG_TZDRAM_SIZE ?= 0x01000000
CFG_SHMEM_START ?= 0x46000000
CFG_SHMEM_SIZE ?= 0x01000000
$(call force,CFG_8250_UART,y)
$(call force,CFG_GENERIC_BOOT,y)
$(call force,CFG_PM_STUBS,y)
$(call force,CFG_SECURE_TIME_SOURCE_CNTPCT,y)
$(call force,CFG_WITH_ARM_TRUSTED_FW,y)
$(call force,CFG_GIC,y)
CFG_CRYPTO_WITH_CE := y

ta-targets = ta_arm32

ifeq ($(CFG_ARM64_core),y)
$(call force,CFG_WITH_LPAE,y)
ta-targets += ta_arm64
else
$(call force,CFG_ARM32_core,y)
endif

CFG_WITH_STACK_CANARIES ?= y
CFG_CONSOLE_UART ?= 0

ifeq ($(PLATFORM_FLAVOR),mt8173)
$(call force,CFG_TEE_CORE_NB_CORE,4)
# 2**1 = 2 cores per cluster
$(call force,CFG_CORE_CLUSTER_SHIFT,1)
endif

ifeq ($(PLATFORM_FLAVOR),mt8518)
$(call force,CFG_TEE_CORE_NB_CORE,4)
endif

ifeq ($(PLATFORM_FLAVOR),mt2712)
$(call force,CFG_TEE_CORE_NB_CORE,6)
$(call force,CFG_CORE_CLUSTER_SHIFT,1)
CFG_NUM_THREADS ?= $(CFG_TEE_CORE_NB_CORE)
CFG_WITH_SOFTWARE_PRNG := n
$(call force,CFG_RPMB_FS,y)
$(call force,CFG_MTK_RPMB_KEY_GEN,y)
$(call force,CFG_REE_FS_NO_DIRH_ON_RPMB,y)
CFG_DYN_SDP = y
ifeq ($(CFG_DYN_SDP),y)
$(call force,CFG_MAX_PA,0x13FFFFFFF)
endif
endif

ifeq ($(PLATFORM_FLAVOR),mt2731)
$(call force,CFG_TEE_CORE_NB_CORE,3)
$(call force,CFG_CORE_CLUSTER_SHIFT,1)
CFG_NUM_THREADS ?= $(CFG_TEE_CORE_NB_CORE)
CFG_WITH_SOFTWARE_PRNG := n
endif

