/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2017 All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef TZ_EMI_MPU_H
#define TZ_EMI_MPU_H

#define EMI_MPU_SA(region)		((volatile unsigned int)(EMI_MPU_SA0 + (region*4)))
#define EMI_MPU_EA(region)		((volatile unsigned int)(EMI_MPU_EA0 + (region*4)))
#define EMI_MPU_APC(region,dgroup)	((volatile unsigned int)(EMI_MPU_APC0 + (region*4) +(dgroup*0x100)))
#define EMI_MPU_CTRL_D(domain)		((volatile unsigned int)(EMI_MPU_CTRL_D0 + (domain*4)))
#define EMI_RG_MASK_D(domain)		((volatile unsigned int)(EMI_MPU_MASK_D0 + (domain*4)))

#define EMI_PHY_OFFSET      (0x40000000UL)
#define EMI_MPU_ALIGNMENT   (0x10000UL)
#define PERICFG_BASE_ADDR   (0x10003000UL)

#define PERIAXI_CTL3_OFF    (0x208)
#define PERISYS_4G_SUPPORT  (0x1 << 11)

#define EMI_MPU_DOMAIN_NUM	8
#define EMI_MPU_REGION_NUM	8
#define EMI_MPU_ALIGN_BITS	16
#define EMI_MPU_DGROUP_NUM	(EMI_MPU_DOMAIN_NUM/8)
#define DRAM_OFFSET		(0x40000000 >> EMI_MPU_ALIGN_BITS)
#define EMI_4GB_CLR_BIT32	(~(0x100000000 >> EMI_MPU_ALIGN_BITS))
#define EMI_4GB_SET_BIT32	(0x100000000 >> EMI_MPU_ALIGN_BITS)

#define DYN_MPU_REGION_START  5
#define DYN_MPU_NUM           3

#define EMI_MPU_LOCK		1
#define EMI_MPU_UNLOCK		0

#define TO_DYN_REGION_NUM(num) (num+DYN_MPU_REGION_START)
typedef enum
{
    EMI_MPU_NO_PROTECTION = 0,      /* read and write for both secure and non-secure access */
    EMI_MPU_SEC_RW = 1,    /* read and write for secure access */
    EMI_MPU_SEC_RW_NSEC_R = 2,      /* read and write for secure access and read only for non-secure access */
    EMI_MPU_SEC_RW_NSEC_W = 3,      /* read and write for secure access and write only for non-secure access */
    EMI_MPU_SEC_R_NSEC_R = 4,      /* read only for both secure access and non-secure access */
    EMI_MPU_FORBIDDEN = 5,  /* Any access is prohibited */
    EMI_MPU_SEC_R_NSEC_RW = 6       /* read and write for non-secure access and read only for secure access */
} tz_mpu_permission;

/*SET_ACCESS_PERMISSON is used to merge domain permission into one setting*/
#define SET_ACCESS_PERMISSON(d3, d2, d1, d0) (((d3) << 9) | ((d2) << 6) | ((d1) << 3) | (d0))

struct emi_region_info_t {
	paddr_t start;
	paddr_t end;
	unsigned int region;
	unsigned int apc;
};

struct emi_mpu_record_t {
	struct emi_region_info_t mpu_info;
	int    is_used;
};

#endif /* TZ_EMI_MPU_H */
