/*
 * Copyright (c) 2015 Google Inc. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "platform_smc.h"
#include <types_ext.h>

#ifdef ARM64
#define SMC_ARG0		"x0"
#define SMC_ARG1		"x1"
#define SMC_ARG2		"x2"
#define SMC_ARG3		"x3"
#define SMC_ARCH_EXTENSION	""
#define SMC_REGISTERS_TRASHED	"x4","x5","x6","x7","x8","x9","x10","x11", \
				"x12","x13","x14","x15","x16","x17"
#else
#define SMC_ARG0		"r0"
#define SMC_ARG1		"r1"
#define SMC_ARG2		"r2"
#define SMC_ARG3		"r3"
#define SMC_ARCH_EXTENSION	".arch_extension sec\n"
#define SMC_REGISTERS_TRASHED	"ip"
#endif

int generic_arm_smc(unsigned int r0, unsigned int r1, unsigned int r2, unsigned int r3)
{
	register unsigned int _r0 __asm__(SMC_ARG0) = r0;
	register unsigned int _r1 __asm__(SMC_ARG1) = r1;
	register unsigned int _r2 __asm__(SMC_ARG2) = r2;
	register unsigned int _r3 __asm__(SMC_ARG3) = r3;

	__asm__ volatile(
		SMC_ARCH_EXTENSION
		"smc	#0"	/* switch to secure world */
		: "=r" (_r0), "=r" (_r1), "=r" (_r2), "=r" (_r3)
		: "r" (_r0), "r" (_r1), "r" (_r2), "r" (_r3)
		: SMC_REGISTERS_TRASHED);
	return _r0;
}

int get_input_data_smc(unsigned int r0, unsigned int* r1, unsigned int* r2, unsigned int* r3, unsigned int* r4)
{
	register unsigned int _r0 __asm__(SMC_ARG0) = r0;
	register unsigned int _r1 __asm__(SMC_ARG1) = 0;
	register unsigned int _r2 __asm__(SMC_ARG2) = 0;
	register unsigned int _r3 __asm__(SMC_ARG3) = 0;

	__asm__ volatile(
		SMC_ARCH_EXTENSION
		"smc	#0"	/* switch to secure world */
		: "=r" (_r0), "=r" (_r1), "=r" (_r2), "=r" (_r3)
		: "r" (_r0), "r" (_r1), "r" (_r2), "r" (_r3)
		: SMC_REGISTERS_TRASHED);
	if (r1 != NULL){
		*r1 = _r0;
	}
	if (r2 != NULL){
		*r2 = _r1;
	}
	if (r3 != NULL){
		*r3 = _r2;
	}
	if (r4 != NULL){
		*r4 = _r3;
	}
	return _r0;
}