/*
 * Copyright (c) 2015 Google Inc. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <sm/optee_smc.h>

#define OPTEE_SMC_OEM_FAST_CALL_VAL(func_num) \
         OPTEE_SMC_CALL_VAL(OPTEE_SMC_32, OPTEE_SMC_FAST_CALL, \
                            OPTEE_SMC_OWNER_OEM, (func_num))

#define OPTEE_SMC_FUNCID_GET_HWID		1
#define OPTEE_SMC_GET_HWID \
	OPTEE_SMC_OEM_FAST_CALL_VAL(OPTEE_SMC_FUNCID_GET_HWID)

#define OPTEE_SMC_FUNCID_GET_HWKEY		2
#define OPTEE_SMC_GET_HWKEY \
	OPTEE_SMC_OEM_FAST_CALL_VAL(OPTEE_SMC_FUNCID_GET_HWKEY)

#define TEESMC_OPTEED_FUNCID_GET_RPMBKEY_FIRST	3
#define TEESMC_OPTEED_OEM_GET_RPMBKEY_FIRST \
	OPTEE_SMC_OEM_FAST_CALL_VAL(TEESMC_OPTEED_FUNCID_GET_RPMBKEY_FIRST)

#define TEESMC_OPTEED_FUNCID_GET_RPMBKEY_SECOND	4
#define TEESMC_OPTEED_OEM_GET_RPMBKEY_SECOND \
	OPTEE_SMC_OEM_FAST_CALL_VAL(TEESMC_OPTEED_FUNCID_GET_RPMBKEY_SECOND)

int generic_arm_smc(unsigned int r0, unsigned int r1, unsigned int r2, unsigned int r3);
int get_input_data_smc(unsigned int r0, unsigned int* r1, unsigned int* r2, unsigned int* r3, unsigned int* r4);
