#include "platform_smc.h"
#include <trace.h>
#include <string.h>
#include <kernel/tee_common_otp.h>

TEE_Result get_hrid(unsigned int hrid[4])
{
	int ret = get_input_data_smc(OPTEE_SMC_GET_HWKEY, &hrid[0], &hrid[1], &hrid[2], &hrid[3]);
	if (-1 == ret) {
		EMSG("Read hrid failed!");
		return TEE_ERROR_GENERIC;
	}
	// DMSG("hrid:0x%x 0x%x", hrid[0], hrid[1]);
	return TEE_SUCCESS;
}

TEE_Result get_hwid(unsigned int hwid[4])
{
	int ret = get_input_data_smc(OPTEE_SMC_GET_HWID, &hwid[0], &hwid[1],  &hwid[2], &hwid[3]);
	if (-1 == ret) {
		EMSG("Read hwid failed!");
		return TEE_ERROR_GENERIC;
	}
	// DMSG("hwid:0x%x 0x%x 0x%x 0x%x", hwid[0], hwid[1], hwid[2], hwid[3]);
	return TEE_SUCCESS;
}

void tee_otp_get_hw_unique_key(struct tee_hw_unique_key *hwkey)
{
    unsigned int hrid[4];
	get_hrid(hrid);
	size_t clen = sizeof(hrid)<sizeof(hwkey->data) ? sizeof(hrid) : sizeof(hwkey->data);
	memcpy((void *)(&hwkey->data[0]), (const void *)(&hrid[0]), clen);
	DMSG("tee_otp_get_hw_unique_key finished!\n");
}

int tee_otp_get_die_id(uint8_t *buffer, size_t len)
{
	size_t i;
	unsigned int hwid[4];
	get_hwid(hwid);
	uint8_t *bptr = (uint8_t *)(&hwid[0]);
    for (i = 0; i < len; i++)
	{
        buffer[i] = bptr[i % sizeof(hwid)];
		// DMSG("buffer[]:%d 0x%x", i, buffer[i]);
	}
	DMSG("tee_otp_get_die_id finished!\n");
    return 0;
}

#ifdef CFG_MTK_RPMB_KEY_GEN
int tee_otp_get_rpmb_key(uint32_t *rpmb_key)
{
	int ret;

	ret = get_input_data_smc(TEESMC_OPTEED_OEM_GET_RPMBKEY_FIRST, &rpmb_key[0], &rpmb_key[1], &rpmb_key[2], &rpmb_key[3]);
	if (-1 == ret) {
		EMSG("Read rpmb key first failed!");
		return TEE_ERROR_GENERIC;
	}

	ret = get_input_data_smc(TEESMC_OPTEED_OEM_GET_RPMBKEY_SECOND, &rpmb_key[4], &rpmb_key[5], &rpmb_key[6], &rpmb_key[7]);
	if (-1 == ret) {
		EMSG("Read rpmb key second failed!");
		return TEE_ERROR_GENERIC;
	}

	DMSG("tee_otp_get_rpmb_key finished!\n");

	return 0;
}
#endif
