#include <kernel/misc.h>
#include <kernel/mutex.h>
#include <kernel/panic.h>
#include <mm/core_memprot.h>
#include <initcall.h>
#include <io.h>
#include "platform_config.h"

#define INFRACFG_AO_SIZE        (0x1000UL)
register_phys_mem(MEM_AREA_IO_NSEC, TRNG_BASE_ADDR, TRNG_BASE_SIZE);
register_phys_mem(MEM_AREA_IO_NSEC, INFRACFG_AO_BASE, INFRACFG_AO_SIZE);

vaddr_t trng_base=0;
vaddr_t infracfg_base=0;

static struct mutex trng_mutex = MUTEX_INITIALIZER;

static uint32_t get_hw_random(void)
{
    uint32_t value = 0;
    uint32_t random_value = 0;

    /* turn on TRNG clk */
    value = read32(infracfg_base+TRNG_PDN_CLR);
    value |= TRNG_PDN_VALUE;
    write32(value, (infracfg_base+TRNG_PDN_CLR));
    value = read32(trng_base+TRNG_CTRL);
    value |= TRNG_CTRL_START;
    write32(value, (trng_base+TRNG_CTRL));

    while (0 == (read32(trng_base+TRNG_CTRL) & TRNG_CTRL_RDY));
    random_value = read32(trng_base+TRNG_DATA);
    value = read32(trng_base+TRNG_CTRL);
    value &= ~TRNG_CTRL_START;
    write32(value, (trng_base+TRNG_CTRL));
    /* turn off TRNG clk */
    value = read32(infracfg_base+TRNG_PDN_SET);
    value |= TRNG_PDN_VALUE;
    write32(value, (infracfg_base+TRNG_PDN_SET));
    return random_value;
}

uint8_t hw_get_random_byte(void)
{
    static int pos;
    static union {
        uint32_t val;
        uint8_t byte[4];
    } random;
    uint8_t ret;
    mutex_lock(&trng_mutex);
    if (!pos)
        random.val = get_hw_random();
    ret = random.byte[pos++];
    if (pos == 4)
        pos = 0;
    mutex_unlock(&trng_mutex);
    return ret;
    
}

TEE_Result trng_init(void)
{

    trng_base = (vaddr_t)phys_to_virt_io(TRNG_BASE);
	infracfg_base = (vaddr_t)phys_to_virt_io(INFRACFG_AO_BASE);

	if (!trng_base || !infracfg_base)
		panic();

    DMSG("Get trng test: %x", get_hw_random());
    DMSG("Get trng test: %x", get_hw_random());
    return TEE_SUCCESS;
}

driver_init(trng_init);