include core/arch/arm/cpu/cortex-armv8-0.mk

$(call force,CFG_8250_UART,y)
$(call force,CFG_GENERIC_BOOT,y)
$(call force,CFG_PM_STUBS,y)
$(call force,CFG_SECURE_TIME_SOURCE_CNTPCT,y)
$(call force,CFG_WITH_ARM_TRUSTED_FW,y)
$(call force,CFG_GIC,y)
CFG_CRYPTO_WITH_CE := y
CFG_WITH_STACK_CANARIES ?= y
CFG_CONSOLE_UART ?= 0

ifeq ($(CFG_ARM64_core),y)
$(call force,CFG_WITH_LPAE,y)
ta-targets += ta_arm64
else
$(call force,CFG_ARM32_core,y)
endif

ifeq ($(PLATFORM_FLAVOR),mt2735)
$(call force,CFG_ARM_GICV3,y)
$(call force,CFG_TEE_CORE_NB_CORE,4)
$(call force,CFG_CORE_CLUSTER_SHIFT,0)
CFG_NUM_THREADS ?= $(CFG_TEE_CORE_NB_CORE)
CFG_WITH_SOFTWARE_PRNG := n
ifeq ($(SUPPORT_RPMB),yes)
$(call force,CFG_RPMB_FS,y)
$(call force,CFG_MTK_RPMB_KEY_GEN,y)
$(call force,CFG_REE_FS_NO_DIRH_ON_RPMB,y)
endif
endif
