/*
 * Copyright (c) 2014-2015, ARM Limited and Contributors. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of ARM nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __PLAT_DEF_H__
#define __PLAT_DEF_H__

#define MT2735_PRIMARY_CPU	0x0

#define IO_PHYS			(0x10000000)
#define TOPCKGEN_BASE		(IO_PHYS)
#define INFRACFG_AO_BASE	(IO_PHYS + 0x1000)
#define GPIO_BASE		(IO_PHYS + 0x5000)
#define SPM_BASE		(IO_PHYS + 0x6000)
#define RGU_BASE		(IO_PHYS + 0x7000)
#define PMIC_WRAP_BASE		(IO_PHYS + 0xD000)
#define TRNG_BASE		(IO_PHYS + 0x20f000)
#define PLAT_MT_CCI_BASE	(IO_PHYS + 0x390000)
#define GCE_BASE		(IO_PHYS + 0x228000)
#define DEBUGSYS_BASE		(IO_PHYS + 0x4a0000)
#define AUDIOSYS_BASE		(IO_PHYS + 0x1210000)
#define MMSYS_BASE		(IO_PHYS + 0x4116000)
#define MT_GIC_BASE		(0x0C000000)
#define MCUCFG_BASE		(0x0C530000)
/* Aggregate of all devices in the first GB */
#define MTK_DEV_RNG0_BASE	IO_PHYS
#define MTK_DEV_RNG0_SIZE	0x600000
#define MTK_DEV_RNG1_BASE	(IO_PHYS + 0x1000000)
#define MTK_DEV_RNG1_SIZE	0x7003000

/*******************************************************************************
 * UART related constants
 ******************************************************************************/
#define MT2735_UART0_BASE	(IO_PHYS + 0x01002000)
#define MT2735_UART1_BASE	(IO_PHYS + 0x01003000)
#if CONFIG_MACH_FPGA
#define MT2735_UART_CLOCK	(10000000)  /* FOR FPGA, 10Mhz sys clock */
#else
#define MT2735_UART_CLOCK	(26000000)
#endif
#define MT2735_BAUDRATE		(921600)
#define MT2735_NS_GICD_BASE (0xC000000)
#define MT2735_NS_GICD_SIZE (0x1000000)

/*******************************************************************************
 * System counter frequency related constants
 ******************************************************************************/
#define SYS_COUNTER_FREQ_IN_TICKS	13000000
#define SYS_COUNTER_FREQ_IN_MHZ		13

/*******************************************************************************
 * GIC-400 & interrupt handling related constants
 ******************************************************************************/

/* Base MTK_platform compatible GIC memory map */
#define BASE_GICD_BASE		(MT_GIC_BASE + 0x0)
#define BASE_GICC_BASE		(MT_GIC_BASE + 0x400000)
#define BASE_GICR_BASE		0  /* No GICR for GIC-400 */
#define BASE_GICH_BASE		(MT_GIC_BASE + 0x30000)
#define BASE_GICV_BASE		(MT_GIC_BASE + 0x50000)
#define INT_POL_CTL0		(MCUCFG_BASE + 0xA80)
#define INT_POL_SECCTL0		(MCUCFG_BASE + 0xA00)
#define INT_POL_SECCTL_NUM	20
#define MT_GIC_RDIST_BASE	(MT_GIC_BASE + 0x80000)

#define GIC_PRIVATE_SIGNALS	(32)

/*******************************************************************************
 * CCI-400 related constants
 ******************************************************************************/
#define PLAT_MT_CCI_CLUSTER0_SL_IFACE_IX	4
#define PLAT_MT_CCI_CLUSTER1_SL_IFACE_IX	5

/*******************************************************************************
 * WDT related constants
 ******************************************************************************/
#define MTK_WDT_BASE		(RGU_BASE)
#define MTK_WDT_RESTART		(MTK_WDT_BASE + 0x0008)
#define MTK_WDT_RESTART_KEY	0x1971

/* FIQ platform related define */
#define MT_IRQ_SEC_SGI_0	8
#define MT_IRQ_SEC_SGI_1	9
#define MT_IRQ_SEC_SGI_2	10
#define MT_IRQ_SEC_SGI_3	11
#define MT_IRQ_SEC_SGI_4	12
#define MT_IRQ_SEC_SGI_5	13
#define MT_IRQ_SEC_SGI_6	14
#define MT_IRQ_SEC_SGI_7	15
#define MT_IRQ_WDT

/*******************************************************************************
 * TRNG related constants
 ******************************************************************************/
#define TRNG_BASE_ADDR		TRNG_BASE
#define TRNG_BASE_SIZE		(0x20UL)
#define TRNG_CTRL		(0x0000UL)
#define TRNG_TIME		(0x0004UL)
#define TRNG_DATA		(0x0008UL)
#define TRNG_CONF		(0x000CUL)
#define TRNG_CTRL_RDY		(0x80000000UL)
#define TRNG_CTRL_START		(0x00000001UL)
#define TRNG_PDN_SET		(0x0088UL)
#define TRNG_PDN_CLR		(0x008cUL)
#define TRNG_PDN_STA		(0x0094UL)
#define TRNG_PDN_VALUE		(0x10UL)

/*******************************************************************************
 * internal sram related constants
 ******************************************************************************/
#define SRAM_BASE_PHYS (0x100000)
#define SRAM_BASE_SIZE (0x30000UL)
#define MRDUMP_CB_SIZE 0x2000
#define MRDUMP_CB_ADDR (SRAM_BASE_PHYS + SRAM_BASE_SIZE - MRDUMP_CB_SIZE) //end -8K

#endif /* __PLAT_DEF_H__ */
