// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2014, STMicroelectronics International N.V.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef XML_DATASTORAGE_API_H_
#define XML_DATASTORAGE_API_H_

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#include "tee_client_api.h"
#undef TA_UUID
#include "TTA_DS_protocol.h"
#include "xml_common_api.h"

#define Invoke_FreeTransientObjectPanic Invoke_Simple_Function
#define Invoke_RenamePersistentObject_Success Invoke_Simple_Function
#define Invoke_CloseObjectPanic Invoke_Simple_Function
#define Invoke_CreatePersistentObject_AccessConflict Invoke_Simple_Function
#define Invoke_CloseFreeAndResetObjectSuccessHandleNull Invoke_Simple_Function
#define Invoke_GetObjectInfoPanic Invoke_Simple_Function
#define Invoke_OpenPersistentObject_Conflict Invoke_Simple_Function
#define Invoke_FreeCloseAndDeletePersistentObjectSuccessHandleNull \
	Invoke_Simple_Function
#define Invoke_ResetPersistentObjectEnumeratorPanic Invoke_Simple_Function
#define Invoke_GetNextPersistentObjectPanic Invoke_Simple_Function
#define Invoke_RestrictObjectUsagePanic Invoke_Simple_Function
#define Invoke_GetObjectValueAttributePanic Invoke_Simple_Function
#define Invoke_FreePersistentObjectEnumeratorPanic Invoke_Simple_Function
#define Invoke_StartPersistentObjectEnumeratorPanic Invoke_Simple_Function
#define Invoke_ResetTransientObjectPanic Invoke_Simple_Function
#define Invoke_RenamePersistentObject_AccessConflict Invoke_Simple_Function
#define Invoke_OpenPersistentObjectPanic Invoke_Simple_Function
#define Invoke_CreatePersistentObject_ItemNotFound Invoke_Simple_Function

#define Invoke_CreatePersistentObject_Success Invoke_Simple_Function_SubTestCase
#define Invoke_CreatePersistentObjectPanic Invoke_Simple_Function_SubTestCase
#define Invoke_OpenPersistentObject_ItemNotFound \
	Invoke_Simple_Function_SubTestCase
#define Invoke_ReadObjectDataPanic Invoke_Simple_Function_SubTestCase
#define Invoke_OpenPersistentObject_Success Invoke_Simple_Function_SubTestCase
#define Invoke_RenamePersistentObjectPanic Invoke_Simple_Function_SubTestCase
#define Invoke_TruncateObjectDataPanic Invoke_Simple_Function_SubTestCase
#define Invoke_CloseAndDeletePersistentObjectPanic \
	Invoke_Simple_Function_SubTestCase
#define Invoke_SeekObjectDataPanic Invoke_Simple_Function_SubTestCase
#define Invoke_WriteObjectDataPanic Invoke_Simple_Function_SubTestCase

#define Invoke_AllocateTransientChain Invoke_Simple_Function_Object
#define Invoke_GetBufferAttribute_object_uninitialized \
	Invoke_Simple_Function_Object

#define CLIENT_APP01                    NULL

#define TEEC_UNDEFINED_ERROR 0xDEADDEAD

#define TEEC_ORIGIN_ANY_NOT_TRUSTED_APP  0x00000005

#define OFFSET_0 0
#define OFFSET_HIGH 900
#define OFFSET_LOW 300

#define INITIAL_DATA_SIZE 1024
#define LARGER_THAN_INITIAL 1500
#define SHORTER_THAN_INITIAL 500

#define KEY_SIZE_TOO_LARGE 4096
#define SIZE_AES_256 256
#define SIZE_DES3_192 168
#define SIZE_DES_64 56
#define SIZE_DH_KEYPAIR_1024 1024
#define SIZE_DSA_KEYPAIR_768 768
#define SIZE_DSA_PUBLIC_KEY_768 768
#define SIZE_GENERIC_SECRET_2048 2048
#define SIZE_HMAC_MD5_256 256
#define SIZE_HMAC_SHA1_256 256
#define SIZE_HMAC_SHA224_256 256
#define SIZE_HMAC_SHA256_512 512
#define SIZE_HMAC_SHA384_512 512
#define SIZE_HMAC_SHA512_512 512
#define SIZE_RSA_KEYPAIR_2048 2048
/* #define SIZE_RSA_PUBLIC_KEY_2048 2048 */
#define SIZE_ZERO 0
#define WRONG_SIZE 5

#define TEE_ERROR_TOO_SHORT_BUFFER TEE_ERROR_SHORT_BUFFER

#define TEE_ATTR_NONE (uint32_t)0

#define NOMINAL_CASE 0

#define BUFFER_ATTRIBUTE 0
#define VALUE_ATTRIBUTE 1

/* Test data defines */
static pthread_t THREAD01_DEFAULT;

/* Return ORIGIN */
static uint32_t ret_orig;

static TEEC_SharedMemory *SHARE_MEM01;
static TEEC_SharedMemory *SHARE_MEM02;
static TEEC_SharedMemory *SHARE_MEM03;
static TEEC_SharedMemory *SHARE_MEM04;
static TEEC_Session *SESSION01;
static TEEC_Session *SESSION02;
static TEEC_Context *CONTEXT01;
static TEEC_Context *CONTEXT02;
static TEEC_Operation *OPERATION01;
static TEEC_Operation *OPERATION02;

static uint32_t BIG_SIZE = 1024;
static uint32_t DS_BIG_SIZE = 16384;

static uint8_t BUFFER01[] = {
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB,
	0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB
};

static uint8_t INITIAL_DATA[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
	0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
	0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B,
	0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B,
	0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B,
	0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B,
	0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B,
	0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B,
	0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B,
	0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B,
	0x9C, 0x9D, 0x9E, 0x9F,
	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB,
	0xAC, 0xAD, 0xAE, 0xAF,
	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB,
	0xBC, 0xBD, 0xBE, 0xBF,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB,
	0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB,
	0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB,
	0xEC, 0xED, 0xEE, 0xEF,
	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB,
	0xFC, 0xFD, 0xFE, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
	0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
	0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B,
	0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B,
	0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B,
	0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B,
	0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B,
	0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B,
	0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B,
	0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B,
	0x9C, 0x9D, 0x9E, 0x9F,
	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB,
	0xAC, 0xAD, 0xAE, 0xAF,
	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB,
	0xBC, 0xBD, 0xBE, 0xBF,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB,
	0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB,
	0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB,
	0xEC, 0xED, 0xEE, 0xEF,
	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB,
	0xFC, 0xFD, 0xFE, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
	0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
	0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B,
	0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B,
	0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B,
	0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B,
	0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B,
	0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B,
	0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B,
	0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B,
	0x9C, 0x9D, 0x9E, 0x9F,
	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB,
	0xAC, 0xAD, 0xAE, 0xAF,
	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB,
	0xBC, 0xBD, 0xBE, 0xBF,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB,
	0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB,
	0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB,
	0xEC, 0xED, 0xEE, 0xEF,
	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB,
	0xFC, 0xFD, 0xFE, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
	0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
	0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B,
	0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B,
	0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B,
	0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B,
	0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B,
	0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B,
	0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B,
	0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B,
	0x9C, 0x9D, 0x9E, 0x9F,
	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB,
	0xAC, 0xAD, 0xAE, 0xAF,
	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB,
	0xBC, 0xBD, 0xBE, 0xBF,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB,
	0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB,
	0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB,
	0xEC, 0xED, 0xEE, 0xEF,
	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB,
	0xFC, 0xFD, 0xFE, 0xFF,
};

static uint8_t TEE_ATTR_AES_256_VALUE01[] = {
	0x60, 0x3d, 0xeb, 0x10, 0x15, 0xca, 0x71, 0xbe, 0x2b, 0x73, 0xae, 0xf0,
	0x85, 0x7d, 0x77, 0x81,
	0x1f, 0x35, 0x2c, 0x07, 0x3b, 0x61, 0x08, 0xd7, 0x2d, 0x98, 0x10, 0xa3,
	0x09, 0x14, 0xdf, 0xf4,
};

static const uint8_t TEE_ATTR_DES3_192_VALUE01[] = {
	0xCD, 0xFE, 0x57, 0xB6, 0xB6, 0x2F, 0xAE, 0x6B, 0x04, 0x73, 0x40, 0xF1,
	0x02, 0xD6, 0xA4, 0x8C,
	0x89, 0x5D, 0xAD, 0xF2, 0x9D, 0x62, 0xEF, 0x25,
};

static uint8_t TEE_ATTR_DES_64_VALUE01[] = {
	0xCD, 0xFE, 0x57, 0xB6, 0xB6, 0x2F, 0xAE, 0x6B,
};

static uint8_t TEE_ATTR_DH_BASE_VALUE01[] = {
	0x1c, 0xe0, 0xf6, 0x69, 0x26, 0x46, 0x11, 0x97, 0xef, 0x45, 0xc4, 0x65,
	0x8b, 0x83, 0xb8, 0xab,
	0x04, 0xa9, 0x22, 0x42, 0x68, 0x50, 0x4d, 0x05, 0xb8, 0x19, 0x83, 0x99,
	0xdd, 0x71, 0x37, 0x18,
	0xcc, 0x1f, 0x24, 0x5d, 0x47, 0x6c, 0xcf, 0x61, 0xa2, 0xf9, 0x34, 0x93,
	0xf4, 0x1f, 0x55, 0x52,
	0x48, 0x65, 0x57, 0xe6, 0xd4, 0xca, 0xa8, 0x00, 0xd6, 0xd0, 0xdb, 0x3c,
	0xbf, 0x5a, 0x95, 0x4b,
	0x20, 0x8a, 0x4e, 0xba, 0xf7, 0xe6, 0x49, 0xfb, 0x61, 0x24, 0xd8, 0xa2,
	0x1e, 0xf2, 0xf2, 0x2b,
	0xaa, 0xae, 0x29, 0x21, 0x10, 0x19, 0x10, 0x51, 0x46, 0x47, 0x31, 0xb6,
	0xcc, 0x3c, 0x93, 0xdc,
	0x6e, 0x80, 0xba, 0x16, 0x0b, 0x66, 0x64, 0xa5, 0x6c, 0xfa, 0x96, 0xea,
	0xf1, 0xb2, 0x83, 0x39,
	0x8e, 0xb4, 0x61, 0x64, 0xe5, 0xe9, 0x43, 0x84, 0xee, 0x02, 0x24, 0xe7,
	0x1f, 0x03, 0x7c, 0x23,
};

static uint8_t TEE_ATTR_DH_PRIME_VALUE01[] = {
	0xe0, 0x01, 0xe8, 0x96, 0x7d, 0xb4, 0x93, 0x53, 0xe1, 0x6f, 0x8e, 0x89,
	0x22, 0x0c, 0xce, 0xfc,
	0x5c, 0x5f, 0x12, 0xe3, 0xdf, 0xf8, 0xf1, 0xd1, 0x49, 0x90, 0x12, 0xe6,
	0xef, 0x53, 0xe3, 0x1f,
	0x02, 0xea, 0xcc, 0x5a, 0xdd, 0xf3, 0x37, 0x89, 0x35, 0xc9, 0x5b, 0x21,
	0xea, 0x3d, 0x6f, 0x1c,
	0xd7, 0xce, 0x63, 0x75, 0x52, 0xec, 0x38, 0x6c, 0x0e, 0x34, 0xf7, 0x36,
	0xad, 0x95, 0x17, 0xef,
	0xfe, 0x5e, 0x4d, 0xa7, 0xa8, 0x6a, 0xf9, 0x0e, 0x2c, 0x22, 0x8f, 0xe4,
	0xb9, 0xe6, 0xd8, 0xf8,
	0xf0, 0x2d, 0x20, 0xaf, 0x78, 0xab, 0xb6, 0x92, 0xac, 0xbc, 0x4b, 0x23,
	0xfa, 0xf2, 0xc5, 0xcc,
	0xd4, 0x9a, 0x0c, 0x9a, 0x8b, 0xcd, 0x91, 0xac, 0x0c, 0x55, 0x92, 0x01,
	0xe6, 0xc2, 0xfd, 0x1f,
	0x47, 0xc2, 0xcb, 0x2a, 0x88, 0xa8, 0x3c, 0x21, 0x0f, 0xc0, 0x54, 0xdb,
	0x29, 0x2d, 0xbc, 0x45,
};

static uint8_t TEE_ATTR_DH_PRIME_VALUE_WRONG01[] = {
	0xe0, 0x01, 0xe8, 0x96, 0x7d, 0xb4, 0x93, 0x53, 0xe1, 0x6f, 0x8e, 0x89,
	0x22, 0x0c, 0xce, 0xfc,
	0x5c, 0x5f, 0x12, 0xe3, 0xdf, 0xf8, 0xf1, 0xd1, 0x49, 0x90, 0x12, 0xe6,
	0xef, 0x53, 0xe3, 0x1f,
	0x02, 0xea, 0xcc, 0x5a, 0xdd, 0xf3, 0x37, 0x89, 0x35, 0xc9, 0x5b, 0x21,
	0xea, 0x3d, 0x6f, 0x1c,
	0xd7, 0xce, 0x63, 0x75, 0x52, 0xec, 0x38, 0x6c, 0x0e, 0x34, 0xf7, 0x36,
	0xad, 0x95, 0x17, 0xef,
	0xfe, 0x5e, 0x4d, 0xa7, 0xa8, 0x6a, 0xf9, 0x0e, 0x2c, 0x22, 0x8f, 0xe4,
	0xb9, 0xe6, 0xff, 0xff,
	0xff, 0x2d, 0x20, 0xaf, 0x78, 0xab, 0xb6, 0x92, 0xac, 0xbc, 0x4b, 0x23,
	0xfa, 0xf2, 0xc5, 0xcc,
	0xd4, 0x9a, 0x0c, 0x9a, 0x8b, 0xcd, 0x91, 0xac, 0x0c, 0x55, 0x92, 0x01,
	0xe6, 0xc2, 0xfd, 0x1f,
	0x47, 0xc2, 0xcb, 0x2a, 0x88, 0xa8, 0x3c, 0x21, 0x0f, 0xc0, 0x54, 0xdb,
	0x29, 0x2d, 0xbc, 0x45,
};

static uint8_t TEE_ATTR_DH_PRIVATE_VALUE_VALUE01[] = {
	0x53, 0x8d, 0x3d, 0x64, 0x27, 0x4a, 0x40, 0x05, 0x9b, 0x9c, 0x26, 0xe9,
	0x13, 0xe6, 0x91, 0x53,
	0x23, 0x7b, 0x55, 0x83,
};

static uint8_t TEE_ATTR_DH_PUBLIC_VALUE_VALUE01[] = {
	0xbb, 0xe9, 0x18, 0xdd, 0x4b, 0x2b, 0x94, 0x1b, 0x10, 0x0e, 0x88, 0x35,
	0x28, 0x68, 0xfc, 0x62,
	0x04, 0x38, 0xa6, 0xdb, 0x32, 0xa6, 0x9e, 0xee, 0x6c, 0x6f, 0x45, 0x1c,
	0xa3, 0xa6, 0xd5, 0x37,
	0x77, 0x75, 0x5b, 0xc1, 0x37, 0x0a, 0xce, 0xfe, 0x2b, 0x8f, 0x13, 0xa9,
	0x14, 0x2c, 0x5b, 0x44,
	0x15, 0x78, 0x86, 0x30, 0xd6, 0x95, 0xb1, 0x92, 0x20, 0x63, 0xa3, 0xcf,
	0x9d, 0xef, 0x65, 0x61,
	0x27, 0x4d, 0x24, 0x01, 0xe7, 0xa1, 0x45, 0xf2, 0xd8, 0xb9, 0x3a, 0x45,
	0x17, 0xf4, 0x19, 0xd0,
	0x5e, 0xf8, 0xcb, 0x35, 0x59, 0x37, 0x9d, 0x04, 0x20, 0xa3, 0xbf, 0x02,
	0xad, 0xfe, 0xa8, 0x60,
	0xb2, 0xc3, 0xee, 0x85, 0x58, 0x90, 0xf3, 0xb5, 0x57, 0x2b, 0xb4, 0xef,
	0xd7, 0x8f, 0x37, 0x68,
	0x78, 0x7c, 0x71, 0x52, 0x9d, 0x5e, 0x0a, 0x61, 0x4f, 0x09, 0x89, 0x92,
	0x39, 0xf7, 0x4b, 0x01,
};

static uint8_t TEE_ATTR_DH_SUBPRIME_VALUE01[] = { };
/* static uint8_t *TEE_ATTR_DH_SUBPRIME_VALUE01=NULL; */

static uint8_t TEE_ATTR_HMAC_MD5_256_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
};

static uint8_t TEE_ATTR_HMAC_SHA1_256_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
};

static uint8_t TEE_ATTR_HMAC_SHA224_256_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
};

static uint8_t TEE_ATTR_HMAC_SHA256_512_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
	0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f,
};

static uint8_t TEE_ATTR_HMAC_SHA384_512_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
	0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f,
};

static uint8_t TEE_ATTR_HMAC_SHA512_512_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
	0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f,
};

static uint8_t TEE_ATTR_RSA_MODULUS_VALUE01[] = {
	0xf0, 0x1a, 0x95, 0xcd, 0x5f, 0x9f, 0x1c, 0xbc, 0x5c, 0x2e, 0xc8, 0x00,
	0x3b, 0xfa, 0xe0, 0xd5,
	0x72, 0xea, 0xfc, 0x9e, 0x74, 0xe1, 0x02, 0x66, 0xa8, 0x13, 0x3f, 0x0c,
	0xe6, 0x24, 0xcb, 0x1c,
	0xa5, 0xdf, 0x64, 0xfb, 0x06, 0xd7, 0x13, 0xce, 0xaa, 0x6c, 0xee, 0x16,
	0x7b, 0xf8, 0x92, 0xaf,
	0xc4, 0x5b, 0x46, 0x18, 0xc6, 0x30, 0xb6, 0x04, 0x1c, 0x3a, 0x2e, 0xd7,
	0xca, 0xb8, 0xb5, 0x00,
	0x78, 0x89, 0xa0, 0x69, 0x37, 0x84, 0x59, 0x99, 0x0c, 0x2f, 0x00, 0xe5,
	0x3b, 0xe1, 0x18, 0xe0,
	0xb9, 0x2e, 0x77, 0x1d, 0x32, 0x7e, 0x5f, 0xf4, 0x18, 0xf3, 0x9f, 0x58,
	0xc6, 0x83, 0xe2, 0x7a,
	0xcb, 0x89, 0x18, 0xc2, 0x09, 0x84, 0x7e, 0x9d, 0x96, 0xe0, 0xb9, 0x49,
	0x75, 0xef, 0xcf, 0xff,
	0xf0, 0xb6, 0x18, 0xd3, 0x7a, 0xc1, 0x6f, 0x0c, 0x55, 0x33, 0xbe, 0x9d,
	0x63, 0x06, 0xd6, 0x9f,
	0xc1, 0xa5, 0xe9, 0xbd, 0xb1, 0xb2, 0x5d, 0x5c, 0xf9, 0xab, 0xa9, 0xb5,
	0x6a, 0x4e, 0xa4, 0xfa,
	0x44, 0x32, 0xd6, 0x71, 0x2e, 0x5f, 0xa6, 0x25, 0xf8, 0x40, 0x24, 0xc4,
	0x5b, 0x61, 0x55, 0x1b,
	0xac, 0xa3, 0x0a, 0x11, 0x8e, 0x65, 0x20, 0xda, 0x2c, 0x0d, 0xdf, 0xdb,
	0x47, 0x6b, 0x61, 0x18,
	0x4d, 0xfe, 0xfd, 0x2a, 0x7e, 0x77, 0x40, 0x44, 0x43, 0xc6, 0x33, 0x6c,
	0xe5, 0x1b, 0x8d, 0x80,
	0xf9, 0x97, 0xa2, 0xe4, 0xb9, 0x34, 0x3e, 0x28, 0x94, 0x9f, 0xbd, 0xa8,
	0x2b, 0x0a, 0x4d, 0x1a,
	0xa8, 0x06, 0xe5, 0x99, 0x4e, 0xb9, 0x13, 0x45, 0xc8, 0xf6, 0x0f, 0xd0,
	0x4d, 0xbf, 0xe7, 0x8f,
	0xed, 0xca, 0x8e, 0xf8, 0x8d, 0x87, 0x5f, 0xd4, 0xb4, 0x1a, 0x2c, 0xc9,
	0xa7, 0x67, 0x7e, 0xb2,
	0x1b, 0xc1, 0xce, 0xb6, 0x83, 0x7c, 0xce, 0xb4, 0x3d, 0x85, 0xc7, 0x53,
	0x30, 0x7c, 0xfe, 0x85,
};

static uint8_t TEE_ATTR_RSA_PRIVATE_EXPONENT_VALUE01[] = {
	0xa5, 0x0d, 0xe1, 0x84, 0xf9, 0x02, 0xec, 0x42, 0x20, 0x2c, 0x98, 0x98,
	0x70, 0xa3, 0x1a, 0x04,
	0x21, 0xa7, 0xa0, 0x59, 0x5d, 0x87, 0x80, 0x9b, 0x09, 0x57, 0x91, 0xb4,
	0x50, 0x51, 0x62, 0xbf,
	0x22, 0xd7, 0xdb, 0x17, 0x25, 0xb0, 0x9c, 0x91, 0x29, 0x5f, 0x10, 0x9c,
	0xac, 0x44, 0x48, 0xb2,
	0x43, 0x8d, 0x6b, 0x36, 0x84, 0xa7, 0xdf, 0xb8, 0x1b, 0x9f, 0x73, 0xac,
	0x2c, 0x53, 0xa5, 0x39,
	0xd9, 0xa2, 0xe2, 0x7e, 0xf2, 0x07, 0x2d, 0x80, 0xa4, 0x7b, 0x7b, 0x66,
	0x1a, 0x2f, 0xb7, 0x66,
	0x64, 0x66, 0xa8, 0xc3, 0x8d, 0x7e, 0x8a, 0x7f, 0xc6, 0xd7, 0x52, 0xe7,
	0x38, 0x30, 0x59, 0x74,
	0x88, 0x8e, 0x8a, 0x52, 0x79, 0x30, 0x77, 0xc9, 0xe5, 0x7a, 0x3e, 0x65,
	0x5d, 0x89, 0xa9, 0xb7,
	0x0b, 0xc6, 0x62, 0x72, 0x9e, 0xa4, 0x72, 0xae, 0x4b, 0xb3, 0xf2, 0x89,
	0x47, 0x15, 0xe0, 0x5b,
	0x45, 0x4d, 0x99, 0x5b, 0x13, 0x6c, 0x90, 0xbe, 0xe5, 0xb5, 0x98, 0xad,
	0x87, 0x99, 0x1a, 0x57,
	0xd4, 0x1f, 0xf1, 0x52, 0x71, 0x5b, 0x51, 0x40, 0xdc, 0x51, 0x35, 0xf6,
	0x6c, 0xae, 0xa3, 0xf9,
	0x0f, 0x3a, 0xed, 0x28, 0xfc, 0xa5, 0x60, 0x2f, 0x4b, 0x4f, 0x31, 0xac,
	0x48, 0x3e, 0x5b, 0xba,
	0xe4, 0x2b, 0x58, 0x79, 0xe6, 0xb4, 0x6b, 0x5e, 0x56, 0x0a, 0xb2, 0xdb,
	0x68, 0xed, 0x24, 0xd8,
	0x5e, 0x6f, 0x30, 0x59, 0x8d, 0x8c, 0xa3, 0x00, 0x68, 0xf5, 0x42, 0x95,
	0x1a, 0x0b, 0xa8, 0x1c,
	0xfb, 0xdf, 0x29, 0x81, 0x10, 0x32, 0x02, 0xcc, 0x51, 0xa4, 0x17, 0x14,
	0x3e, 0xef, 0x89, 0x41,
	0xde, 0xf8, 0x2d, 0x64, 0x69, 0x30, 0xe8, 0x8a, 0xad, 0x96, 0xf6, 0xf4,
	0x82, 0x83, 0x9a, 0x77,
	0xe7, 0xde, 0x12, 0x31, 0xf7, 0x15, 0xec, 0xce, 0xed, 0x83, 0x68, 0x88,
	0x84, 0xe5, 0x64, 0x81,
};

static uint8_t TEE_ATTR_DSA_PRIME_VALUE01[] = {
	0xf6, 0xad, 0x20, 0x71, 0xe1, 0x5a, 0x4b, 0x9c, 0x2b, 0x7e, 0x53, 0x26,
	0xda, 0x43, 0x9d, 0xc1,
	0x47, 0x4c, 0x1a, 0xd1, 0x6f, 0x2f, 0x85, 0xe9, 0x2c, 0xea, 0x89, 0xfc,
	0xdc, 0x74, 0x66, 0x11,
	0xcf, 0x30, 0xdd, 0xc8, 0x5e, 0x33, 0xf5, 0x83, 0xc1, 0x9d, 0x10, 0xbc,
	0x1a, 0xc3, 0x93, 0x22,
	0x26, 0x24, 0x6f, 0xa7, 0xb9, 0xe0, 0xdd, 0x25, 0x77, 0xb5, 0xf4, 0x27,
	0x59, 0x4c, 0x39, 0xfa,
	0xeb, 0xfc, 0x59, 0x8a, 0x32, 0xe1, 0x74, 0xcb, 0x8a, 0x68, 0x03, 0x57,
	0xf8, 0x62, 0xf2, 0x0b,
	0x6e, 0x84, 0x32, 0xa5, 0x30, 0x65, 0x2f, 0x1c, 0x21, 0x39, 0xae, 0x1f,
	0xaf, 0x76, 0x8b, 0x83,
};

static uint8_t TEE_ATTR_DSA_PRIME_VALUE_WRONG01[] = {
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x2b, 0x7e, 0x53, 0x26,
	0xda, 0x43, 0x9d, 0xc1,
	0x47, 0x4c, 0x1a, 0xd1, 0x6f, 0x2f, 0x85, 0xe9, 0x2c, 0xea, 0x89, 0xfc,
	0xdc, 0x74, 0x66, 0x11,
	0xcf, 0x30, 0xdd, 0xc8, 0x5e, 0x33, 0xf5, 0x83, 0xc1, 0x9d, 0x10, 0xbc,
	0x1a, 0xc3, 0x93, 0x22,
	0x26, 0x24, 0x6f, 0xa7, 0xb9, 0xe0, 0xdd, 0x25, 0x77, 0xb5, 0xf4, 0x27,
	0x59, 0x4c, 0x39, 0xfa,
	0xeb, 0xfc, 0x59, 0x8a, 0x32, 0xe1, 0x74, 0xcb, 0x8a, 0x68, 0x03, 0x57,
	0xf8, 0x62, 0xf2, 0x0b,
	0x6e, 0x84, 0x32, 0xa5, 0x30, 0x65, 0x2f, 0x1c, 0x21, 0x39, 0xae, 0x1f,
	0xaf, 0x76, 0x8b, 0x83,
};

static uint8_t TEE_ATTR_DSA_SUBPRIME_VALUE01[] = {
	0x87, 0x44, 0xe4, 0xdd, 0xc6, 0xd0, 0x19, 0xa5, 0xea, 0xc2, 0xb1, 0x5a,
	0x15, 0xd7, 0xe1, 0xc7,
	0xf6, 0x63, 0x35, 0xf7,
};

static uint8_t TEE_ATTR_GENERIC_SECRET_2048_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
	0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b,
	0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b,
	0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
	0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b,
	0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b,
	0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
	0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f,
};

static uint8_t TEE_ATTR_DSA_BASE_VALUE01[] = {
	0x9a, 0x09, 0x32, 0xb3, 0x8c, 0xb2, 0x10, 0x5b, 0x93, 0x00, 0xdc, 0xb8,
	0x66, 0xc0, 0x66, 0xd9,
	0xce, 0xc6, 0x43, 0x19, 0x2f, 0xcb, 0x28, 0x34, 0xa1, 0x23, 0x9d, 0xba,
	0x28, 0xbd, 0x09, 0xfe,
	0x01, 0x00, 0x1e, 0x04, 0x51, 0xf9, 0xd6, 0x35, 0x1f, 0x6e, 0x56, 0x4a,
	0xfb, 0xc8, 0xf8, 0xc3,
	0x9b, 0x10, 0x59, 0x86, 0x3e, 0xbd, 0x09, 0x85, 0x09, 0x0b, 0xd5, 0x5c,
	0x82, 0x8e, 0x9f, 0xc1,
	0x57, 0xac, 0x7d, 0xa3, 0xcf, 0xc2, 0x89, 0x2a, 0x0e, 0xd9, 0xb9, 0x32,
	0x39, 0x05, 0x82, 0xf2,
	0x97, 0x1e, 0x4a, 0x0c, 0x48, 0x3e, 0x06, 0x22, 0xd7, 0x31, 0x66, 0xbf,
	0x62, 0xa5, 0x9f, 0x26,
};

static uint8_t TEE_ATTR_DSA_PRIVATE_VALUE_VALUE01[] = {
	0x70, 0x4a, 0x46, 0xc6, 0x25, 0x2a, 0x95, 0xa3, 0x9b, 0x40, 0xe0, 0x43,
	0x5a, 0x69, 0x1b, 0xad,
	0xae, 0x52, 0xa5, 0xc0,
};

static uint8_t TEE_ATTR_DSA_PUBLIC_VALUE_VALUE01[] = {
	0x52, 0x9d, 0xed, 0x98, 0xa2, 0x32, 0x09, 0x85, 0xfc, 0x84, 0xb6, 0x5a,
	0x9d, 0xc8, 0xd4, 0xfe,
	0x41, 0xad, 0xa6, 0xe3, 0x59, 0x3d, 0x70, 0x4f, 0x08, 0x98, 0xc1, 0x4e,
	0xc2, 0x46, 0x34, 0xdd,
	0xf5, 0xf1, 0xdb, 0x47, 0xcc, 0x49, 0x15, 0xfc, 0xe1, 0xe2, 0x67, 0x4d,
	0x2e, 0xcd, 0x98, 0xd5,
	0x8b, 0x59, 0x8e, 0x8d, 0xdf, 0xaf, 0xf3, 0x0e, 0x88, 0x26, 0xf5, 0x0a,
	0xab, 0x40, 0x27, 0xb5,
	0xaa, 0xb8, 0x87, 0xc1, 0x9a, 0xd9, 0x6d, 0x7e, 0x57, 0xde, 0x53, 0x90,
	0xad, 0x8e, 0x55, 0x57,
	0xb4, 0x1a, 0x80, 0x19, 0xc9, 0x0d, 0x80, 0x60, 0x71, 0x79, 0xb5, 0x4e,
	0xb0, 0xad, 0x4d, 0x23,
};

static const uint8_t *TEE_ATTR_VALUE_NONE;

static uint32_t TEE_ATTR_RSA_PUBLIC_EXPONENT_VALUE01[] = { 0x10001 };

/** ALL_TEEC_UUID
 *
 * These constants are the UUID of existing
 * Trusted Applications
 */
/* "SMARTCSLTDATAST1" */
static TEEC_UUID UUID_TTA_testingInternalAPI_dataStorage = {
	0x534D4152, 0x5443, 0x534C,
	{ 0x54, 0x44, 0x41, 0x54, 0x41, 0x53, 0x54, 0x31 }
};

/* XML_VERIFY macro define.
 *
 * Use ADBG_EXPECT or ADBG_EXPECT_NOT depending on the
 * expected return value.
 *
 * ADBG_EXPECT() -> IF(EXP == GOT) RETURN TRUE
 * ADBG_EXPECT() -> IF(EXP != GOT) RETURN TRUE
 */
#define XML_VERIFY(c, exp, got) \
	do { \
		if (exp == TEEC_UNDEFINED_ERROR) \
			ADBG_EXPECT_NOT(c, exp, got); \
		else \
			ADBG_EXPECT(c, exp, got); \
	} while (0)

/* Initialize context using TEEC_InitializeContext and
	check the returned value. */
#define XML_InitializeContext(c, name, context, expected) \
	XML_VERIFY(c, expected, TEEC_InitializeContext(name, context))

/* Open session using TEEC_OpenSession and
	check the returned value and/or returned origin. */
#define XML_OpenSession(c, context, session, destination, connectionMethod, \
			connectionData, operation, returnOrigin, expected) \
	do { \
		XML_VERIFY(c, expected, \
			   TEEC_OpenSession(context, session, destination, \
					    connectionMethod, connectionData, \
					    operation, &ret_orig)); \
		if ((returnOrigin != 0) && \
		    ((int)returnOrigin != TEEC_ORIGIN_ANY_NOT_TRUSTED_APP)) \
			ADBG_EXPECT(c, (int)returnOrigin, ret_orig); \
		else \
			ADBG_EXPECT_NOT(c, (int)returnOrigin, ret_orig); \
	} while (0)

/*dummy functions*/
#define TEEC_SelectApp(a, b) /*do nothing for now*/

/*Allocates TEEC_SharedMemory inside of the TEE*/
static TEEC_Result AllocateSharedMemory(TEEC_Context *ctx,
					TEEC_SharedMemory *shm, uint32_t size,
					uint32_t flags)
{
	shm->flags = flags;
	shm->size = size;
	return TEEC_AllocateSharedMemory(ctx, shm);
}

/**
 * Writes 4 byte to @p *data_pp and increases
 * @p *data_pp by 4 byte. The bytes are written
 * in Big Endian Order.
 */
static void put_uint32_be(void **data_pp, uint32_t v)
{
	uint8_t *d = *(uint8_t **)data_pp;
	uint8_t *v_p = (uint8_t *)&v;

	d[3] = v_p[0];
	d[2] = v_p[1];
	d[1] = v_p[2];
	d[0] = v_p[3];
	*(uint8_t **)data_pp += sizeof(uint32_t);
}

/**
 * Reads 4 byte from the @p *data_pp
 * as they are written in Big Endian Order.
 */
static uint32_t get_uint32_be(void **data_pp)
{
	const uint8_t *d = *(const uint8_t **)data_pp;

	*(const uint8_t **)data_pp += sizeof(uint32_t);
	return ((d[0] << 8 | d[1]) << 8 | d[2]) << 8 | d[3];
}

static TEEC_Result Invoke_Simple_Function(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_NONE, TEEC_NONE, TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	return res;
}

static TEEC_Result Invoke_Simple_Function_SubTestCase(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t subTestCase)
{
	TEEC_Result res = TEEC_SUCCESS;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	op.params[0].value.a = subTestCase;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	return res;
}

static TEEC_Result Invoke_Simple_Function_Object(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t objectType, uint32_t objectSize)
{
	TEEC_Result res = TEEC_SUCCESS;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	op.params[0].value.a = objectType;
	op.params[0].value.b = objectSize;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	return res;
}

static TEEC_Result Invoke_SeekWriteReadObjectData(
	ADBG_Case_t *c, uint32_t cmdId, TEEC_Session *sess, TEE_Whence seekMode,
	uint32_t offset, uint32_t initOffset)
{
	TEEC_Result res;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;
	uint8_t *buf0 = NULL, *tmp = NULL;

	ALLOCATE_AND_FILL_SHARED_MEMORY(CONTEXT01, SHARE_MEM01, BIG_SIZE,
					TEEC_MEM_INPUT,
					sizeof(BUFFER01), BUFFER01, mem01_exit)
	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM02, DS_BIG_SIZE,
			       TEEC_MEM_OUTPUT, mem02_exit)

	op.params[0].value.a = seekMode;
	op.params[0].value.b = offset;
	op.params[1].value.a = initOffset;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, SHARE_MEM01,
					      SHARE_MEM01->size)
	SET_SHARED_MEMORY_OPERATION_PARAMETER(3, 0, SHARE_MEM02,
					      SHARE_MEM02->size)

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_VALUE_INPUT, TEEC_MEMREF_PARTIAL_INPUT,
		TEEC_MEMREF_PARTIAL_OUTPUT);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	if (res != TEEC_SUCCESS)
		goto exit;

	if (op.params[3].memref.size != op.params[2].memref.size) {
		if (op.params[3].memref.size < op.params[2].memref.size) {
			res = TEE_ERROR_SHORT_BUFFER;
			goto exit;
		}

		tmp = (uint8_t *)op.params[3].memref.parent->buffer +
		      op.params[3].memref.size - sizeof(BUFFER01);
		buf0 =
			(uint8_t *)malloc(op.params[3].memref.size -
					  sizeof(BUFFER01));
		memset(buf0, 0, op.params[3].memref.size - sizeof(BUFFER01));

		(void)ADBG_EXPECT_COMPARE_SIGNED(c,
						 0, ==,
						 memcmp(tmp, BUFFER01,
							sizeof(BUFFER01)));

		(void)ADBG_EXPECT_COMPARE_SIGNED(c,
						 0, ==,
						 memcmp(buf0,
							op.params[3].memref.
							parent->buffer,
							(op.params[3].memref.
							 size -
							 sizeof(BUFFER01))));
	}

	free(buf0);
exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM02);
mem02_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

static TEEC_Result Invoke_InitObjectAndAttributes(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t subTestCase, uint32_t objectType, uint32_t objectSize,
	uint32_t attributeId_1, const void *attribValue_1,
	uint32_t attribSize_1,
	uint32_t attributeId_2, const void *attribValue_2,
	uint32_t attribSize_2,
	uint32_t attributeId_3, const void *attribValue_3,
	uint32_t attribSize_3,
	uint32_t attributeId_4, const void *attribValue_4,
	uint32_t attribSize_4,
	uint32_t attributeId_5, const void *attribValue_5,
	uint32_t attribSize_5)
{
	TEEC_Result res = TEEC_SUCCESS;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;
	void *tmp_buf1 = NULL;
	uint8_t *tmp_buf2 = NULL;
	uint32_t tmp_offset = 0;

	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM01, BIG_SIZE,
			       TEEC_MEM_INPUT, mem01_exit)
	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM02, DS_BIG_SIZE,
			       TEEC_MEM_INPUT, mem02_exit)

	tmp_buf1 = SHARE_MEM01->buffer;
	tmp_buf2 = (uint8_t *)SHARE_MEM02->buffer;
	put_uint32_be(&tmp_buf1, attributeId_1);

	if (TEE_ATTR_NONE != attributeId_1) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_1);
		memcpy(tmp_buf2, attribValue_1, (size_t)attribSize_1);
		tmp_buf2 += attribSize_1;
		tmp_offset += attribSize_1;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	put_uint32_be(&tmp_buf1, attributeId_2);

	if (TEE_ATTR_NONE != attributeId_2) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_2);
		memcpy(tmp_buf2, attribValue_2, (size_t)attribSize_2);
		tmp_buf2 += attribSize_2;
		tmp_offset += attribSize_2;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	put_uint32_be(&tmp_buf1, attributeId_3);

	if (TEE_ATTR_NONE != attributeId_3) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_3);
		memcpy(tmp_buf2, attribValue_3, (size_t)attribSize_3);
		tmp_buf2 += attribSize_3;
		tmp_offset += attribSize_3;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	put_uint32_be(&tmp_buf1, attributeId_4);

	if (TEE_ATTR_NONE != attributeId_4) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_4);
		memcpy(tmp_buf2, attribValue_4, (size_t)attribSize_4);
		tmp_buf2 += attribSize_4;
		tmp_offset += attribSize_4;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	put_uint32_be(&tmp_buf1, attributeId_5);

	if (TEE_ATTR_NONE != attributeId_5) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_5);
		memcpy(tmp_buf2, attribValue_5, (size_t)attribSize_5);
		tmp_buf2 += attribSize_5;
		tmp_offset += attribSize_5;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	op.params[0].value.a = objectType;
	op.params[0].value.b = objectSize;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, SHARE_MEM01, 60)
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, SHARE_MEM02, tmp_offset)
	op.params[3].value.a = subTestCase;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_MEMREF_PARTIAL_INPUT,
		TEEC_MEMREF_PARTIAL_INPUT, TEEC_VALUE_INPUT);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	TEEC_ReleaseSharedMemory(SHARE_MEM02);
mem02_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

static TEEC_Result Invoke_StartNGetPersistentObjectEnumerator_itemNotFound(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId)
{
	TEEC_Result res = TEEC_SUCCESS;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_OUTPUT, TEEC_NONE, TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	(void)ADBG_EXPECT_COMPARE_SIGNED(c, op.params[0].value.a, ==, 0);
	(void)ADBG_EXPECT_COMPARE_SIGNED(c, op.params[0].value.b, ==, 0);

	return res;
}

static TEEC_Result Invoke_GetRSAAttributes(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t attributeType, uint32_t attributeId)
{
	TEEC_Result res = TEEC_SUCCESS;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;
	void *tmp_buf;
	uint32_t tmp_int1;
	uint32_t tmp_int2;

	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM01, DS_BIG_SIZE,
			       TEEC_MEM_OUTPUT, mem01_exit)
	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM02, DS_BIG_SIZE,
			       TEEC_MEM_OUTPUT, mem02_exit)
	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM03, DS_BIG_SIZE,
			       TEEC_MEM_OUTPUT, mem03_exit)
	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM04, DS_BIG_SIZE,
			       (TEEC_MEM_INPUT | TEEC_MEM_OUTPUT), mem04_exit)

	tmp_buf = SHARE_MEM04->buffer;
	put_uint32_be(&tmp_buf, attributeType);
	put_uint32_be(&tmp_buf, attributeId);

	SET_SHARED_MEMORY_OPERATION_PARAMETER(0, 0, SHARE_MEM04,
					      SHARE_MEM04->size)
	SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, SHARE_MEM01,
					      SHARE_MEM01->size)
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, SHARE_MEM02,
					      SHARE_MEM02->size)
	SET_SHARED_MEMORY_OPERATION_PARAMETER(3, 0, SHARE_MEM03,
					      SHARE_MEM03->size)

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_MEMREF_PARTIAL_INOUT, TEEC_MEMREF_PARTIAL_OUTPUT,
		TEEC_MEMREF_PARTIAL_OUTPUT, TEEC_MEMREF_PARTIAL_OUTPUT);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	if ((res != TEEC_SUCCESS) || (VALUE_ATTRIBUTE == attributeType))
		goto exit;

	tmp_buf = SHARE_MEM04->buffer;
	tmp_int1 = get_uint32_be(&tmp_buf);
	tmp_int2 = TEE_ATTR_RSA_PRIME1;
	(void)ADBG_EXPECT_COMPARE_SIGNED(c, tmp_int1, !=, tmp_int2);

	tmp_buf = SHARE_MEM01->buffer;
	tmp_int1 = get_uint32_be(&tmp_buf);
	tmp_int2 = TEE_ATTR_RSA_PRIME2;
	(void)ADBG_EXPECT_COMPARE_SIGNED(c, tmp_int1, !=, tmp_int2);

	tmp_buf = SHARE_MEM02->buffer;
	tmp_int1 = get_uint32_be(&tmp_buf);
	tmp_int2 = TEE_ATTR_RSA_PRIVATE_EXPONENT;
	(void)ADBG_EXPECT_COMPARE_SIGNED(c, tmp_int1, !=, tmp_int2);

	tmp_buf = SHARE_MEM03->buffer;
	tmp_int1 = get_uint32_be(&tmp_buf);
	(void)ADBG_EXPECT_COMPARE_SIGNED(c, tmp_int1, !=, attributeId);

exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM04);
mem04_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM03);
mem03_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM02);
mem02_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

static TEEC_Result Invoke_GenerateKey(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t subTestCase,
	uint32_t objectType, uint32_t objectSize, uint32_t keySize,
	uint32_t attributeId_1, const void *attribValue_1,
	uint32_t attribSize_1,
	uint32_t attributeId_2, const void *attribValue_2,
	uint32_t attribSize_2,
	uint32_t attributeId_3, const void *attribValue_3,
	uint32_t attribSize_3)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;
	void *tmp_buf1 = NULL;
	uint8_t *tmp_buf2 = NULL;
	int tmp_offset = 0;

	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM01, BIG_SIZE,
			       TEEC_MEM_INPUT, mem01_exit)

	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM02, DS_BIG_SIZE,
			       TEEC_MEM_INPUT, mem02_exit)

	tmp_buf1 = SHARE_MEM01->buffer;
	tmp_buf2 = (uint8_t *)SHARE_MEM02->buffer;
	put_uint32_be(&tmp_buf1, attributeId_1);

	if (TEE_ATTR_NONE != attributeId_1) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_1);
		memcpy(tmp_buf2, attribValue_1, (size_t)attribSize_1);
		tmp_buf2 += attribSize_1;
		tmp_offset += attribSize_1;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	put_uint32_be(&tmp_buf1, attributeId_2);

	if (TEE_ATTR_NONE != attributeId_2) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_2);
		memcpy(tmp_buf2, attribValue_2, (size_t)attribSize_2);
		tmp_buf2 += attribSize_2;
		tmp_offset += attribSize_2;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	put_uint32_be(&tmp_buf1, attributeId_3);

	if (TEE_ATTR_NONE != attributeId_3) {
		put_uint32_be(&tmp_buf1, tmp_offset);
		put_uint32_be(&tmp_buf1, attribSize_3);
		memcpy(tmp_buf2, attribValue_3, (size_t)attribSize_3);
		tmp_buf2 += attribSize_3;
		tmp_offset += attribSize_3;
	} else {
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
		put_uint32_be(&tmp_buf1, TEE_ATTR_NONE);
	}

	op.params[0].value.a = objectType;
	op.params[0].value.b = objectSize;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, SHARE_MEM01, 36)
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, SHARE_MEM02, tmp_offset)
	op.params[3].value.a = subTestCase;
	op.params[3].value.b = keySize;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_MEMREF_PARTIAL_INPUT,
		TEEC_MEMREF_PARTIAL_INPUT, TEEC_VALUE_INPUT);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	TEEC_ReleaseSharedMemory(SHARE_MEM02);
mem02_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

static TEEC_Result Invoke_ReadObjectData(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t readSize, void *initialBuffer, uint32_t initialBufferSize)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM01, DS_BIG_SIZE,
			       TEEC_MEM_OUTPUT, mem01_exit)

	op.params[0].value.a = readSize;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, SHARE_MEM01,
					      SHARE_MEM01->size)

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_MEMREF_PARTIAL_OUTPUT, TEEC_NONE,
		TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	if (readSize <= initialBufferSize) {
		(void)ADBG_EXPECT_COMPARE_SIGNED(c,
						 0, ==,
						 memcmp(SHARE_MEM01->buffer,
							initialBuffer,
							readSize));
	} else {
		(void)ADBG_EXPECT_COMPARE_SIGNED(c,
						 0, ==,
						 memcmp(SHARE_MEM01->buffer,
							initialBuffer,
							initialBufferSize));
	}

	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

static TEEC_Result Invoke_InitValueAttribute(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t attributeID)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	op.params[0].value.a = attributeID;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	return res;
}

static TEEC_Result Invoke_GetDHAttributes(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t attributeType, uint32_t attributeId)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	ALLOCATE_AND_FILL_SHARED_MEMORY(CONTEXT01, SHARE_MEM01, DS_BIG_SIZE,
					TEEC_MEM_INPUT,
					sizeof(TEE_ATTR_DH_PRIME_VALUE01),
					TEE_ATTR_DH_PRIME_VALUE01, mem01_exit)
	ALLOCATE_AND_FILL_SHARED_MEMORY(CONTEXT01, SHARE_MEM02, DS_BIG_SIZE,
					TEEC_MEM_INPUT,
					sizeof(TEE_ATTR_DH_BASE_VALUE01),
					TEE_ATTR_DH_BASE_VALUE01, mem02_exit)
	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM03, DS_BIG_SIZE,
			       TEEC_MEM_OUTPUT, mem03_exit)

	op.params[0].value.a = attributeType;
	op.params[0].value.b = attributeId;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, SHARE_MEM01,
					      sizeof(TEE_ATTR_DH_PRIME_VALUE01))
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, SHARE_MEM02,
					      sizeof(TEE_ATTR_DH_BASE_VALUE01))
	SET_SHARED_MEMORY_OPERATION_PARAMETER(3, 0, SHARE_MEM03,
					      SHARE_MEM03->size)

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INOUT, TEEC_MEMREF_PARTIAL_INPUT,
		TEEC_MEMREF_PARTIAL_INPUT, TEEC_MEMREF_PARTIAL_OUTPUT);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	if (VALUE_ATTRIBUTE == attributeType) {
		/* Check if attributeId is coherent
			with TEE_ATTR_DH_PRIME_VALUE01 and
			TEE_ATTR_DH_BASE_VALUE01 */
	} else if ((BUFFER_ATTRIBUTE == attributeType) ||
		   (res == TEEC_SUCCESS)) {
		/* Check if attributeId (SHARE_MEM03) is coherent
			with TEE_ATTR_DH_PRIME_VALUE01 and
			TEE_ATTR_DH_BASE_VALUE01 */
	}

	TEEC_ReleaseSharedMemory(SHARE_MEM03);
mem03_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM02);
mem02_exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

static TEEC_Result Invoke_EnumeratorOnPersistentObjects(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_OUTPUT, TEEC_NONE, TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	if (res != TEEC_SUCCESS)
		return res;

	(void)ADBG_EXPECT_COMPARE_SIGNED(c,
					 (op.params[0].value.b -
					  op.params[0].value.a), ==, 3);

	return res;
}

static TEEC_Result Invoke_TruncateReadObjectData(
	ADBG_Case_t *c, uint32_t cmdId, TEEC_Session *sess,
	uint32_t numberOfBytes, uint32_t expectedReturn)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;
	uint8_t *buf0 = NULL;

	if (numberOfBytes > INITIAL_DATA_SIZE) {
		buf0 = (uint8_t *)malloc(numberOfBytes - INITIAL_DATA_SIZE);
		memset(buf0, 0, numberOfBytes - INITIAL_DATA_SIZE);
	}

	ALLOCATE_SHARED_MEMORY(CONTEXT01, SHARE_MEM01, DS_BIG_SIZE,
			       TEEC_MEM_OUTPUT, mem01_exit)

	op.params[0].value.a = numberOfBytes;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(3, 0, SHARE_MEM01,
					      SHARE_MEM01->size)

	op.paramTypes = TEEC_PARAM_TYPES(
		TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE,
		TEEC_MEMREF_PARTIAL_OUTPUT);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	if (!ADBG_EXPECT_COMPARE_SIGNED(c, res, ==, expectedReturn))
		goto exit;

	(void)ADBG_EXPECT_COMPARE_SIGNED(c, SHARE_MEM01->size, !=,
					 numberOfBytes);

	if (numberOfBytes <= INITIAL_DATA_SIZE) {
		(void)ADBG_EXPECT_COMPARE_SIGNED(c,
						 0, ==,
						 memcmp(SHARE_MEM01->buffer,
							INITIAL_DATA,
							numberOfBytes));
	} else {
		(void)ADBG_EXPECT_COMPARE_SIGNED(c,
						 0, ==,
						 memcmp(SHARE_MEM01->buffer,
							INITIAL_DATA,
							INITIAL_DATA_SIZE));
		uint8_t *tmp_buf = (uint8_t *)SHARE_MEM01->buffer +
				   INITIAL_DATA_SIZE;
		(void)ADBG_EXPECT_COMPARE_SIGNED(c,
						 0, ==,
						 memcmp(tmp_buf, buf0,
							numberOfBytes -
							INITIAL_DATA_SIZE));
	}

exit:
	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	free(buf0);
	return res;
}

#endif /* XML_DATASTORAGE_API_H_ */
